/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.interest.experiment;

import Jama.Matrix;
import gnu.trove.list.array.TDoubleArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.openimaj.feature.local.ScaleSpaceLocation;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.colour.Transforms;
import org.openimaj.image.feature.local.interest.EllipticInterestPointData;
import org.openimaj.image.feature.local.interest.InterestPointData;
import org.openimaj.image.feature.local.interest.InterestPointDetector;
import org.openimaj.image.feature.local.interest.InterestPointVisualiser;
import org.openimaj.knn.CoordinateKDTree;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Coordinate;
import org.openimaj.math.geometry.point.PayloadCoordinate;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Ellipse;
import org.openimaj.math.geometry.shape.EllipseUtilities;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.math.geometry.transforms.TransformUtilities;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.Pair;

public class IPDRepeatability<T extends InterestPointData> {
    static Logger logger = Logger.getLogger(IPDRepeatability.class);
    private Matrix homography;
    private List<Ellipse> validImage2Points;
    private List<Ellipse> validImage1Points;
    private List<ScoredPair<Integer, Pair<Integer>>> prunedOverlapping;
    private double maximumDistanceMultiple = 4.0;
    private int imageWidth;
    private int imageHeight;

    public IPDRepeatability() {
    }

    public IPDRepeatability(Image<?, ?> image1, Image<?, ?> image2, List<Ellipse> image1Points, List<Ellipse> image2Points, Matrix homography) {
        this.setup(image1, image2, image1Points, image2Points, homography);
    }

    public IPDRepeatability(File image1f, File image2f, InterestPointDetector<T> ipd, File homographyf) throws IOException {
        MBFImage image1 = ImageUtilities.readMBF((File)image1f);
        MBFImage image2 = ImageUtilities.readMBF((File)image2f);
        ipd.findInterestPoints(Transforms.calculateIntensityNTSC((MBFImage)image1));
        List<T> image1Points = ipd.getInterestPoints(20);
        ipd.findInterestPoints(Transforms.calculateIntensityNTSC((MBFImage)image2));
        List<T> image2Points = ipd.getInterestPoints(20);
        ArrayList<Ellipse> image1Ellipse = new ArrayList<Ellipse>();
        ArrayList<Ellipse> image2Ellipse = new ArrayList<Ellipse>();
        for (InterestPointData d : image1Points) {
            image1Ellipse.add(d.getEllipse());
        }
        for (InterestPointData d : image2Points) {
            image2Ellipse.add(d.getEllipse());
        }
        Matrix homography = IPDRepeatability.readHomography(homographyf);
        this.setup((Image<?, ?>)image1, (Image<?, ?>)image2, (List<Ellipse>)image1Ellipse, (List<Ellipse>)image2Ellipse, homography);
    }

    public IPDRepeatability(MBFImage image1, MBFImage image2, InterestPointDetector<T> ipd, InputStream homographyf) throws IOException {
        ipd.findInterestPoints(Transforms.calculateIntensityNTSC((MBFImage)image1));
        List<T> image1Points = ipd.getInterestPoints(20);
        ipd.findInterestPoints(Transforms.calculateIntensityNTSC((MBFImage)image2));
        List<T> image2Points = ipd.getInterestPoints(20);
        ArrayList<Ellipse> image1Ellipse = new ArrayList<Ellipse>();
        ArrayList<Ellipse> image2Ellipse = new ArrayList<Ellipse>();
        for (InterestPointData d : image1Points) {
            image1Ellipse.add(d.getEllipse());
        }
        for (InterestPointData d : image2Points) {
            image2Ellipse.add(d.getEllipse());
        }
        Matrix homography = IPDRepeatability.readHomography(homographyf);
        this.setup((Image<?, ?>)image1, (Image<?, ?>)image2, (List<Ellipse>)image1Ellipse, (List<Ellipse>)image2Ellipse, homography);
    }

    public IPDRepeatability(MBFImage image1, MBFImage image2, InterestPointDetector<T> ipd, Matrix homography) throws IOException {
        ipd.findInterestPoints(Transforms.calculateIntensityNTSC((MBFImage)image1));
        List<T> image1Points = ipd.getInterestPoints(20);
        ipd.findInterestPoints(Transforms.calculateIntensityNTSC((MBFImage)image2));
        List<T> image2Points = ipd.getInterestPoints(20);
        ArrayList<Ellipse> image1Ellipse = new ArrayList<Ellipse>();
        ArrayList<Ellipse> image2Ellipse = new ArrayList<Ellipse>();
        for (InterestPointData d : image1Points) {
            image1Ellipse.add(d.getEllipse());
        }
        for (InterestPointData d : image2Points) {
            image2Ellipse.add(d.getEllipse());
        }
        this.setup((Image<?, ?>)image1, (Image<?, ?>)image2, (List<Ellipse>)image1Ellipse, (List<Ellipse>)image2Ellipse, homography);
    }

    public IPDRepeatability(List<Ellipse> firstImagePoints, List<Ellipse> secondImagePoints, Matrix transform) {
        this.validImage1Points = firstImagePoints;
        this.validImage2Points = secondImagePoints;
        this.homography = transform;
    }

    private void setup(Image<?, ?> image1, Image<?, ?> image2, List<Ellipse> image1Points, List<Ellipse> image2Points, Matrix homography) {
        this.homography = homography;
        this.validImage2Points = IPDRepeatability.validPoints(image2Points, image1, homography);
        this.validImage1Points = IPDRepeatability.validPoints(image1Points, image2, homography.inverse());
        this.imageWidth = image1.getWidth();
        this.imageHeight = image1.getHeight();
        if (logger.getLevel() == Level.DEBUG) {
            MBFImage combined = new MBFImage(image1.getWidth() + image2.getWidth(), Math.max(image1.getHeight(), image2.getHeight()), ColourSpace.RGB);
            InterestPointVisualiser<Float[], MBFImage> ipdv1 = new InterestPointVisualiser<Float[], MBFImage>((MBFImage)image1, this.validImage1Points);
            combined.drawImage((Image)ipdv1.drawPatches(RGBColour.RED, RGBColour.BLUE), 0, 0);
            InterestPointVisualiser<Float[], MBFImage> ipdv2 = new InterestPointVisualiser<Float[], MBFImage>((MBFImage)image2, this.validImage2Points);
            combined.drawImage((Image)ipdv2.drawPatches(RGBColour.RED, RGBColour.BLUE), image1.getWidth(), 0);
        }
    }

    public double repeatability(double percentageOverlap) {
        this.prepare();
        double potentialMatches = Math.min(this.validImage2Points.size(), this.validImage1Points.size());
        if (potentialMatches == 0.0) {
            return 0.0;
        }
        double countMatches = 0.0;
        for (ScoredPair<Integer, Pair<Integer>> d : this.prunedOverlapping) {
            if (!(((ScoredPair)d).score >= percentageOverlap)) continue;
            countMatches += 1.0;
        }
        return countMatches / potentialMatches;
    }

    public List<ScoredPair<Integer, Pair<Integer>>> calculateOverlappingEllipses() {
        int smallerSetSize = Math.min(this.validImage1Points.size(), this.validImage2Points.size());
        PriorityQueue<ScoredPair<Integer, Pair<Integer>>> overlapping = new PriorityQueue<ScoredPair<Integer, Pair<Integer>>>(this.validImage1Points.size() * this.validImage2Points.size());
        int oldQueueSize = 0;
        CoordinateKDTree tree = new CoordinateKDTree();
        int j = 0;
        for (Ellipse ellipse : this.validImage2Points) {
            Ellipse ellipse2 = ellipse.transformAffine(this.homography.inverse());
            ScaleSpaceLocation ep = new ScaleSpaceLocation(ellipse2.calculateCentroid().getX(), ellipse2.calculateCentroid().getY(), (float)IPDRepeatability.getRadius(ellipse2, this.maximumDistanceMultiple));
            tree.insert((Coordinate)PayloadCoordinate.payload((Coordinate)ep, (Object)new IndependentPair((Object)j, (Object)ellipse2)));
            ++j;
        }
        int i = 0;
        logger.debug((Object)"Checking all ellipses against each other");
        for (Ellipse ellipse1 : this.validImage1Points) {
            float radius = (float)IPDRepeatability.getRadius(ellipse1, this.maximumDistanceMultiple);
            ArrayList possible = new ArrayList();
            Point2d left = ellipse1.calculateCentroid();
            left.translate(-radius, -radius);
            Point2d right = ellipse1.calculateCentroid();
            right.translate(radius, radius);
            float scaleRadius = (float)((double)radius * 0.5);
            tree.rangeSearch(possible, (Coordinate)new ScaleSpaceLocation(left.getX(), left.getY(), radius - scaleRadius), (Coordinate)new ScaleSpaceLocation(right.getX(), right.getY(), radius + scaleRadius));
            for (PayloadCoordinate payloadCoordinate : possible) {
                Matrix e2Mat;
                IndependentPair pl = (IndependentPair)payloadCoordinate.getPayload();
                j = (Integer)pl.firstObject();
                Ellipse ellipse2 = (Ellipse)pl.secondObject();
                Matrix e1Mat = EllipseUtilities.ellipseToCovariance((Ellipse)ellipse1).inverse();
                double overlap = this.calculateOverlapPercentageOxford(e1Mat, e2Mat = EllipseUtilities.ellipseToCovariance((Ellipse)ellipse2).inverse(), ellipse1, ellipse2, this.maximumDistanceMultiple);
                if (!(overlap >= 0.0)) continue;
                overlapping.add(new ScoredPair(new Pair((Object)i, (Object)j), overlap));
                if (oldQueueSize == overlapping.size()) {
                    System.err.println("The queue didn't change in size!!");
                }
                oldQueueSize = overlapping.size();
            }
            ++i;
        }
        logger.debug((Object)"pruning overlapping ellipses, finding best case for each ellipse");
        List<ScoredPair<Integer, Pair<Integer>>> list = this.pruneOverlapping(overlapping, smallerSetSize);
        return list;
    }

    private static void displayEllipsesZoomed(Ellipse ellipse1, Ellipse ellipse2) {
        int zoomHeight = 400;
        int zoomWidth = 400;
        int midzoomx = 200;
        int midzoomy = 200;
        double e1Radius = IPDRepeatability.getRadius(ellipse1, 1.0);
        double scale = 200.0 / e1Radius;
        Matrix scaleMatrix = TransformUtilities.scaleMatrixAboutPoint((double)(1.0 / scale), (double)(1.0 / scale), (int)0, (int)0);
        MBFImage zoomed = new MBFImage(400, 400, ColourSpace.RGB);
        Matrix translateE1 = Matrix.identity((int)3, (int)3);
        translateE1 = translateE1.times(TransformUtilities.translateToPointMatrix((Point2d)new Point2dImpl(0.0f, 0.0f), (Point2d)new Point2dImpl(200.0f, 200.0f)));
        translateE1 = translateE1.times(scaleMatrix);
        translateE1 = translateE1.times(TransformUtilities.translateToPointMatrix((Point2d)ellipse1.calculateCentroid(), (Point2d)new Point2dImpl(0.0f, 0.0f)));
        Ellipse expandedTranslated1 = ellipse1.transformAffine(translateE1);
        Ellipse expandedTranslated2 = ellipse2.transformAffine(translateE1);
        zoomed.drawShape((Shape)expandedTranslated1, (Object)RGBColour.RED);
        zoomed.drawShape((Shape)expandedTranslated2, (Object)RGBColour.BLUE);
        DisplayUtilities.displayName((Image)zoomed, (String)"zoomed image");
        System.out.println();
    }

    private void displayEllipsesFull(Ellipse ellipse1, Ellipse ellipse2) {
        MBFImage debugDisplay = new MBFImage(this.imageWidth, this.imageHeight, ColourSpace.RGB);
        debugDisplay.drawShape((Shape)ellipse1, (Object)RGBColour.RED);
        debugDisplay.drawShape((Shape)ellipse2, (Object)RGBColour.BLUE);
        debugDisplay.drawShape((Shape)ellipse2.calculateRegularBoundingBox().union(ellipse1.calculateRegularBoundingBox()), (Object)RGBColour.BLUE);
        DisplayUtilities.displayName((Image)debugDisplay, (String)"debug display full");
    }

    private static double getRadius(Ellipse ellipse, double maximumDistanceFactor) {
        double maxDistance = Math.sqrt(ellipse.getMajor() * ellipse.getMinor());
        return maxDistance *= maximumDistanceFactor;
    }

    private List<ScoredPair<Integer, Pair<Integer>>> pruneOverlapping(PriorityQueue<ScoredPair<Integer, Pair<Integer>>> overlapping, int smallerSetSize) {
        HashSet<Object> seenE1 = new HashSet<Object>();
        HashSet<Object> seenE2 = new HashSet<Object>();
        ArrayList<ScoredPair<Integer, Pair<Integer>>> prunedOverlapping = new ArrayList<ScoredPair<Integer, Pair<Integer>>>();
        while (overlapping.size() > 0 && seenE1.size() < smallerSetSize) {
            ScoredPair<Integer, Pair<Integer>> scoredPair = overlapping.poll();
            if (seenE1.contains(((ScoredPair)scoredPair).pair.firstObject()) || seenE2.contains(((ScoredPair)scoredPair).pair.secondObject())) continue;
            prunedOverlapping.add(scoredPair);
            seenE1.add(((ScoredPair)scoredPair).pair.firstObject());
            seenE2.add(((ScoredPair)scoredPair).pair.secondObject());
        }
        return prunedOverlapping;
    }

    public static IPDRepeatability<EllipticInterestPointData> repeatability(Image<?, ?> img1, Image<?, ?> img2, List<Ellipse> e1, List<Ellipse> e2, Matrix transform, double maximumDistanceMultiple) {
        IPDRepeatability<EllipticInterestPointData> rep = new IPDRepeatability<EllipticInterestPointData>(img1, img2, e1, e2, transform);
        rep.maximumDistanceMultiple = maximumDistanceMultiple;
        super.prepare();
        return rep;
    }

    public static <T extends InterestPointData> IPDRepeatability<T> repeatability(MBFImage image1, MBFImage image2, List<T> interestPoints1, List<T> interestPoints2, Matrix transform, int maximumDistanceMultiple2) {
        ArrayList<Ellipse> image1Ellipse = new ArrayList<Ellipse>();
        ArrayList<Ellipse> image2Ellipse = new ArrayList<Ellipse>();
        for (InterestPointData d : interestPoints1) {
            image1Ellipse.add(d.getEllipse());
        }
        for (InterestPointData d : interestPoints2) {
            image2Ellipse.add(d.getEllipse());
        }
        logger.debug((Object)("Comparing: " + image1Ellipse.size() + " to " + image2Ellipse.size() + " ellipses"));
        IPDRepeatability<T> rep = new IPDRepeatability<T>((Image<?, ?>)image1, (Image<?, ?>)image2, (List<Ellipse>)image1Ellipse, (List<Ellipse>)image2Ellipse, transform);
        rep.maximumDistanceMultiple = 4.0;
        super.prepare();
        return rep;
    }

    private void prepare() {
        if (this.prunedOverlapping == null) {
            this.prunedOverlapping = this.calculateOverlappingEllipses();
        }
    }

    public static List<Ellipse> validPoints(List<Ellipse> allPoints, Image<?, ?> sourceImage, Matrix transform) {
        ArrayList<Ellipse> valid = new ArrayList<Ellipse>();
        Rectangle validArea = sourceImage.getBounds();
        for (Ellipse data : allPoints) {
            if (data.calculateCentroid().getX() == 294.079f && data.calculateCentroid().getY() == 563.356f) {
                System.out.println();
            }
            if (!validArea.isInside(data.transformAffine(transform.inverse()).calculateRegularBoundingBox())) continue;
            valid.add(data);
        }
        return valid;
    }

    public static List<ScoredPair<Integer, Pair<Integer>>> calculateOverlappingEllipses(List<Ellipse> firstImagePoints, List<Ellipse> secondImagePoints, Matrix transform, double maximumDistanceMultiple) {
        IPDRepeatability rep = new IPDRepeatability(firstImagePoints, secondImagePoints, transform);
        rep.maximumDistanceMultiple = maximumDistanceMultiple;
        return rep.calculateOverlappingEllipses();
    }

    public static Matrix readHomography(File homographyf) throws IOException {
        return IPDRepeatability.readHomography(new FileInputStream(homographyf));
    }

    public static Matrix readHomography(InputStream homographyf) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(homographyf));
        ArrayList<TDoubleArrayList> doubleListList = new ArrayList<TDoubleArrayList>();
        String line = null;
        int nCols = -1;
        int nRows = 0;
        while ((line = reader.readLine()) != null) {
            boolean anyAdded = false;
            String[] parts = line.split(" ");
            TDoubleArrayList doubleList = new TDoubleArrayList();
            int currCols = 0;
            for (String part : parts) {
                if (part.length() == 0) continue;
                anyAdded = true;
                doubleList.add(Double.parseDouble(part));
                ++currCols;
            }
            if (nCols == -1) {
                nCols = currCols;
            }
            if (currCols != nCols) {
                throw new IOException("Could not read matrix file");
            }
            if (!anyAdded) continue;
            doubleListList.add(doubleList);
            ++nRows;
        }
        Matrix ret = new Matrix(nRows, nCols);
        int rowNumber = 0;
        for (TDoubleArrayList doubleList : doubleListList) {
            doubleList.toArray(ret.getArray()[rowNumber++], 0, nCols);
        }
        return ret;
    }

    public double calculateOverlapPercentage(Ellipse e1, Ellipse e2, double maximumDistanceFactor) {
        double maxDistance = IPDRepeatability.getRadius(e1, maximumDistanceFactor);
        double scaleFactor = IPDRepeatability.getScaleFactor(e1);
        Line2d line2d = new Line2d(e1.calculateCentroid(), e2.calculateCentroid());
        if (line2d.calculateLength() >= maxDistance) {
            return 0.0;
        }
        Matrix scaleMatrix1 = TransformUtilities.scaleMatrixAboutPoint((double)scaleFactor, (double)scaleFactor, (Point2d)e1.calculateCentroid());
        Matrix scaleMatrix2 = TransformUtilities.scaleMatrixAboutPoint((double)scaleFactor, (double)scaleFactor, (Point2d)e2.calculateCentroid());
        Ellipse e1Corrected = e1.transformAffine(scaleMatrix1);
        Ellipse e2Corrected = e2.transformAffine(scaleMatrix2);
        double intersection = e1Corrected.intersectionArea((Shape)e2Corrected, 50);
        double e1Area = e1Corrected.calculateArea();
        double e2Area = e2Corrected.calculateArea();
        return intersection / (e1Area - intersection + (e2Area - intersection) + intersection);
    }

    public double calculateOverlapPercentageOxford(Matrix e1Mat, Matrix e2Mat, Ellipse e1, Ellipse e2, double multiplier) {
        double maxDistance = Math.sqrt(e1.getMajor() * e1.getMinor());
        double scaleFactor = 30.0 / maxDistance;
        scaleFactor = 1.0 / (scaleFactor * scaleFactor);
        maxDistance *= multiplier;
        Line2d line2d = new Line2d(e1.calculateCentroid(), e2.calculateCentroid());
        if (line2d.calculateLength() >= maxDistance) {
            return -1.0;
        }
        float dx = e2.calculateCentroid().getX() - e1.calculateCentroid().getX();
        float dy = e2.calculateCentroid().getY() - e1.calculateCentroid().getY();
        double yy1 = e1Mat.get(1, 1) * scaleFactor;
        double xx1 = e1Mat.get(0, 0) * scaleFactor;
        double xy1 = e1Mat.get(0, 1) * scaleFactor;
        double yy2 = e2Mat.get(1, 1) * scaleFactor;
        double xx2 = e2Mat.get(0, 0) * scaleFactor;
        double xy2 = e2Mat.get(0, 1) * scaleFactor;
        double e1Width = Math.sqrt(yy1 / (xx1 * yy1 - xy1 * xy1));
        double e1Height = Math.sqrt(xx1 / (xx1 * yy1 - xy1 * xy1));
        double e2Width = Math.sqrt(yy2 / (xx2 * yy2 - xy2 * xy2));
        double e2Height = Math.sqrt(xx2 / (xx2 * yy2 - xy2 * xy2));
        float maxx = (float)Math.ceil(e1Width > (double)dx + e2Width ? e1Width : (double)dx + e2Width);
        float minx = (float)Math.floor(-e1Width < (double)dx - e2Width ? -e1Width : (double)dx - e2Width);
        float maxy = (float)Math.ceil(e1Height > (double)dy + e2Height ? e1Height : (double)dy + e2Height);
        float miny = (float)Math.floor(-e1Height < (double)dy - e2Height ? -e1Height : (double)dy - e2Height);
        float mina = maxx - minx < maxy - miny ? maxx - minx : maxy - miny;
        float dr = (float)((double)mina / 50.0);
        int bua = 0;
        int bna = 0;
        for (float rx = minx; rx <= maxx; rx += dr) {
            float rx2 = rx - dx;
            for (float ry = miny; ry <= maxy; ry += dr) {
                float ry2 = ry - dy;
                float a = (float)(xx1 * (double)rx * (double)rx + 2.0 * xy1 * (double)rx * (double)ry + yy1 * (double)ry * (double)ry);
                float b = (float)(xx2 * (double)rx2 * (double)rx2 + 2.0 * xy2 * (double)rx2 * (double)ry2 + yy2 * (double)ry2 * (double)ry2);
                if (a < 1.0f && b < 1.0f) {
                    ++bna;
                }
                if (!(a < 1.0f) && !(b < 1.0f)) continue;
                ++bua;
            }
        }
        return (double)bna / (double)bua;
    }

    private static double getScaleFactor(Ellipse ellipse) {
        double maxDistance = Math.sqrt(ellipse.getMajor() * ellipse.getMinor());
        double scaleFactor = 30.0 / maxDistance;
        return scaleFactor;
    }

    public static List<Ellipse> readMatlabInterestPoints(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        reader.readLine();
        reader.readLine();
        String line = "";
        ArrayList<Ellipse> ret = new ArrayList<Ellipse>();
        while ((line = reader.readLine()) != null) {
            String[] parts = line.split(" ");
            float x = Float.parseFloat(parts[0]);
            float y = Float.parseFloat(parts[1]);
            float xx = Float.parseFloat(parts[2]);
            float xy = Float.parseFloat(parts[3]);
            float yy = Float.parseFloat(parts[4]);
            Ellipse e = EllipseUtilities.ellipseFromCovariance((float)x, (float)y, (Matrix)new Matrix((double[][])new double[][]{{xx, xy}, {xy, yy}}).inverse(), (float)1.0f);
            ret.add(e);
        }
        return ret;
    }

    public static void main(String[] args) throws IOException {
        IPDRepeatability.testSingleEllipseFromMatlab();
    }

    /*
     * WARNING - void declaration
     */
    public static void testSingleEllipseFromMatlab() throws IOException {
        void e2_689_18;
        void e1_689_18;
        void secondMoments2_689_18;
        void secondMoments1_689_18;
        void e2_452_18;
        void e1_452_18;
        void secondMoments2_452_18;
        void secondMoments1_452_18;
        void e2_451_18;
        void e1_451_18;
        void secondMoments2_451_18;
        void secondMoments1_451_18;
        void e2_181_18;
        void e1_181_18;
        void secondMoments2_181_18;
        void secondMoments1_181_18;
        void e2_180_18;
        void e1_180_18;
        void secondMoments2_180_18;
        void secondMoments1_180_18;
        void e2_90_18;
        void e1_90_18;
        void secondMoments2_90_18;
        void secondMoments1_90_18;
        void e2_89_18;
        void e1_89_18;
        void secondMoments2_89_18;
        void secondMoments1_89_18;
        void e2_1207_17;
        void e1_1207_17;
        void secondMoments2_1207_17;
        void secondMoments1_1207_17;
        void e2_1156_17;
        void e1_1156_17;
        void secondMoments2_1156_17;
        void secondMoments1_1156_17;
        void e2_1030_17;
        void e1_1030_17;
        void secondMoments2_1030_17;
        void secondMoments1_1030_17;
        void e2_789_17;
        void e1_789_17;
        void secondMoments2_789_17;
        void secondMoments1_789_17;
        void e2_682_17;
        void e1_682_17;
        void secondMoments2_682_17;
        void secondMoments1_682_17;
        void e2_580_17;
        void e1_580_17;
        void secondMoments2_580_17;
        void secondMoments1_580_17;
        void e2_295_17;
        void e1_295_17;
        void secondMoments2_295_17;
        void secondMoments1_295_17;
        void e2_293_17;
        void e1_293_17;
        void secondMoments2_293_17;
        void secondMoments1_293_17;
        void e2_173_17;
        void e1_173_17;
        void secondMoments2_173_17;
        void secondMoments1_173_17;
        void e2_39_17;
        void e1_39_17;
        void secondMoments2_39_17;
        void secondMoments1_39_17;
        void e2_997_16;
        void e1_997_16;
        void secondMoments2_997_16;
        void secondMoments1_997_16;
        void e2_573_16;
        void e1_573_16;
        void secondMoments2_573_16;
        void secondMoments1_573_16;
        void e2_501_16;
        void e1_501_16;
        void secondMoments2_501_16;
        void secondMoments1_501_16;
        void e2_440_16;
        void e1_440_16;
        void secondMoments2_440_16;
        void secondMoments1_440_16;
        void e2_386_16;
        void e1_386_16;
        void secondMoments2_386_16;
        void secondMoments1_386_16;
        void e2_73_16;
        void e1_73_16;
        void secondMoments2_73_16;
        void secondMoments1_73_16;
        void e2_71_16;
        void e1_71_16;
        void secondMoments2_71_16;
        void secondMoments1_71_16;
        void e2_10_16;
        void e1_10_16;
        void secondMoments2_10_16;
        void secondMoments1_10_16;
        void e2_570_15;
        void e1_570_15;
        void secondMoments2_570_15;
        void secondMoments1_570_15;
        void e2_437_15;
        void e1_437_15;
        void secondMoments2_437_15;
        void secondMoments1_437_15;
        void e2_284_15;
        void e1_284_15;
        void secondMoments2_284_15;
        void secondMoments1_284_15;
        void e2_281_15;
        void e1_281_15;
        void secondMoments2_281_15;
        void secondMoments1_281_15;
        void e2_167_15;
        void e1_167_15;
        void secondMoments2_167_15;
        void secondMoments1_167_15;
        void e2_68_15;
        void e1_68_15;
        void secondMoments2_68_15;
        void secondMoments1_68_15;
        void e2_776_14;
        void e1_776_14;
        void secondMoments2_776_14;
        void secondMoments1_776_14;
        void e2_554_14;
        void e1_554_14;
        void secondMoments2_554_14;
        void secondMoments1_554_14;
        void e2_160_14;
        void e1_160_14;
        void secondMoments2_160_14;
        void secondMoments1_160_14;
        void e2_7_14;
        void e1_7_14;
        void secondMoments2_7_14;
        void secondMoments1_7_14;
        void e2_1312_13;
        void e1_1312_13;
        void secondMoments2_1312_13;
        void secondMoments1_1312_13;
        void e2_883_13;
        void e1_883_13;
        void secondMoments2_883_13;
        void secondMoments1_883_13;
        Matrix secondMoments1_220_0 = new Matrix((double[][])new double[][]{{0.002523f, -8.88E-4f}, {-8.88E-4f, 8.02E-4f}});
        Matrix secondMoments2_220_0 = new Matrix((double[][])new double[][]{{7.88E-4f, -4.06E-4f}, {-4.06E-4f, 6.68E-4f}});
        Ellipse e1_220_0 = EllipseUtilities.ellipseFromCovariance((float)185.13f, (float)139.15f, (Matrix)secondMoments1_220_0.inverse(), (float)1.0f);
        Ellipse e2_220_0 = EllipseUtilities.ellipseFromCovariance((float)185.28732f, (float)137.54903f, (Matrix)secondMoments2_220_0.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_220_0, secondMoments2_220_0, e1_220_0, e2_220_0, 0.533756f);
        Matrix secondMoments1_265_0 = new Matrix((double[][])new double[][]{{0.002523f, -8.88E-4f}, {-8.88E-4f, 8.02E-4f}});
        Matrix secondMoments2_265_0 = new Matrix((double[][])new double[][]{{4.24E-4f, -3.77E-4f}, {-3.77E-4f, 9.93E-4f}});
        Ellipse e1_265_0 = EllipseUtilities.ellipseFromCovariance((float)185.13f, (float)139.15f, (Matrix)secondMoments1_265_0.inverse(), (float)1.0f);
        Ellipse e2_265_0 = EllipseUtilities.ellipseFromCovariance((float)178.69762f, (float)134.16748f, (Matrix)secondMoments2_265_0.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_265_0, secondMoments2_265_0, e1_265_0, e2_265_0, 0.391304f);
        Matrix secondMoments1_424_0 = new Matrix((double[][])new double[][]{{0.002523f, -8.88E-4f}, {-8.88E-4f, 8.02E-4f}});
        Matrix secondMoments2_424_0 = new Matrix((double[][])new double[][]{{3.15E-4f, -2.8E-4f}, {-2.8E-4f, 8.51E-4f}});
        Ellipse e1_424_0 = EllipseUtilities.ellipseFromCovariance((float)185.13f, (float)139.15f, (Matrix)secondMoments1_424_0.inverse(), (float)1.0f);
        Ellipse e2_424_0 = EllipseUtilities.ellipseFromCovariance((float)177.85895f, (float)134.84554f, (Matrix)secondMoments2_424_0.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_424_0, secondMoments2_424_0, e1_424_0, e2_424_0, 0.345265f);
        Matrix secondMoments1_548_0 = new Matrix((double[][])new double[][]{{0.002523f, -8.88E-4f}, {-8.88E-4f, 8.02E-4f}});
        Matrix secondMoments2_548_0 = new Matrix((double[][])new double[][]{{3.64E-4f, -2.45E-4f}, {-2.45E-4f, 4.88E-4f}});
        Ellipse e1_548_0 = EllipseUtilities.ellipseFromCovariance((float)185.13f, (float)139.15f, (Matrix)secondMoments1_548_0.inverse(), (float)1.0f);
        Ellipse e2_548_0 = EllipseUtilities.ellipseFromCovariance((float)183.98631f, (float)136.92941f, (Matrix)secondMoments2_548_0.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_548_0, secondMoments2_548_0, e1_548_0, e2_548_0, 0.30955f);
        Matrix secondMoments1_664_0 = new Matrix((double[][])new double[][]{{0.002523f, -8.88E-4f}, {-8.88E-4f, 8.02E-4f}});
        Matrix secondMoments2_664_0 = new Matrix((double[][])new double[][]{{2.05E-4f, -1.9E-4f}, {-1.9E-4f, 6.21E-4f}});
        Ellipse e1_664_0 = EllipseUtilities.ellipseFromCovariance((float)185.13f, (float)139.15f, (Matrix)secondMoments1_664_0.inverse(), (float)1.0f);
        Ellipse e2_664_0 = EllipseUtilities.ellipseFromCovariance((float)177.75218f, (float)135.82877f, (Matrix)secondMoments2_664_0.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_664_0, secondMoments2_664_0, e1_664_0, e2_664_0, 0.269426f);
        Matrix secondMoments1_772_0 = new Matrix((double[][])new double[][]{{0.002523f, -8.88E-4f}, {-8.88E-4f, 8.02E-4f}});
        Matrix secondMoments2_772_0 = new Matrix((double[][])new double[][]{{1.48E-4f, -1.5E-4f}, {-1.5E-4f, 5.61E-4f}});
        Ellipse e1_772_0 = EllipseUtilities.ellipseFromCovariance((float)185.13f, (float)139.15f, (Matrix)secondMoments1_772_0.inverse(), (float)1.0f);
        Ellipse e2_772_0 = EllipseUtilities.ellipseFromCovariance((float)176.39917f, (float)135.96706f, (Matrix)secondMoments2_772_0.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_772_0, secondMoments2_772_0, e1_772_0, e2_772_0, 0.22097f);
        Matrix secondMoments1_944_0 = new Matrix((double[][])new double[][]{{0.002523f, -8.88E-4f}, {-8.88E-4f, 8.02E-4f}});
        Matrix secondMoments2_944_0 = new Matrix((double[][])new double[][]{{9.9E-5f, -5.9E-5f}, {-5.9E-5f, 3.09E-4f}});
        Ellipse e1_944_0 = EllipseUtilities.ellipseFromCovariance((float)185.13f, (float)139.15f, (Matrix)secondMoments1_944_0.inverse(), (float)1.0f);
        Ellipse e2_944_0 = EllipseUtilities.ellipseFromCovariance((float)176.54541f, (float)138.19862f, (Matrix)secondMoments2_944_0.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_944_0, secondMoments2_944_0, e1_944_0, e2_944_0, 0.14682f);
        Matrix secondMoments1_1199_0 = new Matrix((double[][])new double[][]{{0.002523f, -8.88E-4f}, {-8.88E-4f, 8.02E-4f}});
        Matrix secondMoments2_1199_0 = new Matrix((double[][])new double[][]{{7.1E-5f, 2.4E-5f}, {2.4E-5f, 9.4E-5f}});
        Ellipse e1_1199_0 = EllipseUtilities.ellipseFromCovariance((float)185.13f, (float)139.15f, (Matrix)secondMoments1_1199_0.inverse(), (float)1.0f);
        Ellipse e2_1199_0 = EllipseUtilities.ellipseFromCovariance((float)175.62366f, (float)142.29115f, (Matrix)secondMoments2_1199_0.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_1199_0, secondMoments2_1199_0, e1_1199_0, e2_1199_0, 0.069626f);
        Matrix secondMoments1_1269_0 = new Matrix((double[][])new double[][]{{0.002523f, -8.88E-4f}, {-8.88E-4f, 8.02E-4f}});
        Matrix secondMoments2_1269_0 = new Matrix((double[][])new double[][]{{7.0E-5f, 3.4E-5f}, {3.4E-5f, 5.8E-5f}});
        Ellipse e1_1269_0 = EllipseUtilities.ellipseFromCovariance((float)185.13f, (float)139.15f, (Matrix)secondMoments1_1269_0.inverse(), (float)1.0f);
        Ellipse e2_1269_0 = EllipseUtilities.ellipseFromCovariance((float)171.91997f, (float)142.70366f, (Matrix)secondMoments2_1269_0.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_1269_0, secondMoments2_1269_0, e1_1269_0, e2_1269_0, 0.048306f);
        Matrix secondMoments1_3_1 = new Matrix((double[][])new double[][]{{0.001639f, 2.29E-4f}, {2.29E-4f, 7.85E-4f}});
        Matrix secondMoments2_3_1 = new Matrix((double[][])new double[][]{{7.24E-4f, 6.18E-4f}, {6.18E-4f, 0.00152f}});
        Ellipse e1_3_1 = EllipseUtilities.ellipseFromCovariance((float)273.46f, (float)145.2f, (Matrix)secondMoments1_3_1.inverse(), (float)1.0f);
        Ellipse e2_3_1 = EllipseUtilities.ellipseFromCovariance((float)280.30466f, (float)140.13483f, (Matrix)secondMoments2_3_1.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_3_1, secondMoments2_3_1, e1_3_1, e2_3_1, 0.523566f);
        Matrix secondMoments1_4_1 = new Matrix((double[][])new double[][]{{0.001639f, 2.29E-4f}, {2.29E-4f, 7.85E-4f}});
        Matrix secondMoments2_4_1 = new Matrix((double[][])new double[][]{{0.001578f, 4.86E-4f}, {4.86E-4f, 6.31E-4f}});
        Ellipse e1_4_1 = EllipseUtilities.ellipseFromCovariance((float)273.46f, (float)145.2f, (Matrix)secondMoments1_4_1.inverse(), (float)1.0f);
        Ellipse e2_4_1 = EllipseUtilities.ellipseFromCovariance((float)272.3613f, (float)144.96849f, (Matrix)secondMoments2_4_1.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_4_1, secondMoments2_4_1, e1_4_1, e2_4_1, 0.75156f);
        Matrix secondMoments1_154_1 = new Matrix((double[][])new double[][]{{0.001639f, 2.29E-4f}, {2.29E-4f, 7.85E-4f}});
        Matrix secondMoments2_154_1 = new Matrix((double[][])new double[][]{{5.93E-4f, 6.61E-4f}, {6.61E-4f, 0.00131f}});
        Ellipse e1_154_1 = EllipseUtilities.ellipseFromCovariance((float)273.46f, (float)145.2f, (Matrix)secondMoments1_154_1.inverse(), (float)1.0f);
        Ellipse e2_154_1 = EllipseUtilities.ellipseFromCovariance((float)280.76303f, (float)139.85315f, (Matrix)secondMoments2_154_1.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_154_1, secondMoments2_154_1, e1_154_1, e2_154_1, 0.417829f);
        Matrix secondMoments1_156_1 = new Matrix((double[][])new double[][]{{0.001639f, 2.29E-4f}, {2.29E-4f, 7.85E-4f}});
        Matrix secondMoments2_156_1 = new Matrix((double[][])new double[][]{{6.44E-4f, 3.44E-4f}, {3.44E-4f, 6.76E-4f}});
        Ellipse e1_156_1 = EllipseUtilities.ellipseFromCovariance((float)273.46f, (float)145.2f, (Matrix)secondMoments1_156_1.inverse(), (float)1.0f);
        Ellipse e2_156_1 = EllipseUtilities.ellipseFromCovariance((float)275.1137f, (float)140.12453f, (Matrix)secondMoments2_156_1.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_156_1, secondMoments2_156_1, e1_156_1, e2_156_1, 0.502418f);
        Matrix secondMoments1_157_1 = new Matrix((double[][])new double[][]{{0.001639f, 2.29E-4f}, {2.29E-4f, 7.85E-4f}});
        Matrix secondMoments2_157_1 = new Matrix((double[][])new double[][]{{0.001396f, 3.82E-4f}, {3.82E-4f, 3.52E-4f}});
        Ellipse e1_157_1 = EllipseUtilities.ellipseFromCovariance((float)273.46f, (float)145.2f, (Matrix)secondMoments1_157_1.inverse(), (float)1.0f);
        Ellipse e2_157_1 = EllipseUtilities.ellipseFromCovariance((float)271.70865f, (float)149.1028f, (Matrix)secondMoments2_157_1.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_157_1, secondMoments2_157_1, e1_157_1, e2_157_1, 0.530884f);
        Matrix secondMoments1_261_1 = new Matrix((double[][])new double[][]{{0.001639f, 2.29E-4f}, {2.29E-4f, 7.85E-4f}});
        Matrix secondMoments2_261_1 = new Matrix((double[][])new double[][]{{6.09E-4f, 3.52E-4f}, {3.52E-4f, 5.54E-4f}});
        Ellipse e1_261_1 = EllipseUtilities.ellipseFromCovariance((float)273.46f, (float)145.2f, (Matrix)secondMoments1_261_1.inverse(), (float)1.0f);
        Ellipse e2_261_1 = EllipseUtilities.ellipseFromCovariance((float)275.61713f, (float)141.71782f, (Matrix)secondMoments2_261_1.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_261_1, secondMoments2_261_1, e1_261_1, e2_261_1, 0.416771f);
        Matrix secondMoments1_513_1 = new Matrix((double[][])new double[][]{{0.001639f, 2.29E-4f}, {2.29E-4f, 7.85E-4f}});
        Matrix secondMoments2_513_1 = new Matrix((double[][])new double[][]{{7.41E-4f, 2.25E-4f}, {2.25E-4f, 2.21E-4f}});
        Ellipse e1_513_1 = EllipseUtilities.ellipseFromCovariance((float)273.46f, (float)145.2f, (Matrix)secondMoments1_513_1.inverse(), (float)1.0f);
        Ellipse e2_513_1 = EllipseUtilities.ellipseFromCovariance((float)272.49542f, (float)149.94693f, (Matrix)secondMoments2_513_1.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_513_1, secondMoments2_513_1, e1_513_1, e2_513_1, 0.302778f);
        Matrix secondMoments1_545_1 = new Matrix((double[][])new double[][]{{0.001639f, 2.29E-4f}, {2.29E-4f, 7.85E-4f}});
        Matrix secondMoments2_545_1 = new Matrix((double[][])new double[][]{{6.29E-4f, 2.7E-4f}, {2.7E-4f, 2.85E-4f}});
        Ellipse e1_545_1 = EllipseUtilities.ellipseFromCovariance((float)273.46f, (float)145.2f, (Matrix)secondMoments1_545_1.inverse(), (float)1.0f);
        Ellipse e2_545_1 = EllipseUtilities.ellipseFromCovariance((float)273.26474f, (float)150.11642f, (Matrix)secondMoments2_545_1.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_545_1, secondMoments2_545_1, e1_545_1, e2_545_1, 0.295045f);
        Matrix secondMoments1_769_1 = new Matrix((double[][])new double[][]{{0.001639f, 2.29E-4f}, {2.29E-4f, 7.85E-4f}});
        Matrix secondMoments2_769_1 = new Matrix((double[][])new double[][]{{3.86E-4f, 2.22E-4f}, {2.22E-4f, 2.48E-4f}});
        Ellipse e1_769_1 = EllipseUtilities.ellipseFromCovariance((float)273.46f, (float)145.2f, (Matrix)secondMoments1_769_1.inverse(), (float)1.0f);
        Ellipse e2_769_1 = EllipseUtilities.ellipseFromCovariance((float)275.39136f, (float)152.35323f, (Matrix)secondMoments2_769_1.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_769_1, secondMoments2_769_1, e1_769_1, e2_769_1, 0.194111f);
        Matrix secondMoments1_995_1 = new Matrix((double[][])new double[][]{{0.001639f, 2.29E-4f}, {2.29E-4f, 7.85E-4f}});
        Matrix secondMoments2_995_1 = new Matrix((double[][])new double[][]{{2.17E-4f, 1.08E-4f}, {1.08E-4f, 1.31E-4f}});
        Ellipse e1_995_1 = EllipseUtilities.ellipseFromCovariance((float)273.46f, (float)145.2f, (Matrix)secondMoments1_995_1.inverse(), (float)1.0f);
        Ellipse e2_995_1 = EllipseUtilities.ellipseFromCovariance((float)284.4956f, (float)151.9368f, (Matrix)secondMoments2_995_1.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_995_1, secondMoments2_995_1, e1_995_1, e2_995_1, 0.11442f);
        Matrix secondMoments1_1015_2 = new Matrix((double[][])new double[][]{{0.001145f, -4.4E-5f}, {-4.4E-5f, 0.00108f}});
        Matrix secondMoments2_1015_2 = new Matrix((double[][])new double[][]{{1.57E-4f, 9.0E-6f}, {9.0E-6f, 1.02E-4f}});
        Ellipse e1_1015_2 = EllipseUtilities.ellipseFromCovariance((float)332.75f, (float)191.18f, (Matrix)secondMoments1_1015_2.inverse(), (float)1.0f);
        Ellipse e2_1015_2 = EllipseUtilities.ellipseFromCovariance((float)334.84015f, (float)197.35881f, (Matrix)secondMoments2_1015_2.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_1015_2, secondMoments2_1015_2, e1_1015_2, e2_1015_2, 0.113011f);
        Matrix secondMoments1_1125_2 = new Matrix((double[][])new double[][]{{0.001145f, -4.4E-5f}, {-4.4E-5f, 0.00108f}});
        Matrix secondMoments2_1125_2 = new Matrix((double[][])new double[][]{{1.17E-4f, -1.7E-5f}, {-1.7E-5f, 6.5E-5f}});
        Ellipse e1_1125_2 = EllipseUtilities.ellipseFromCovariance((float)332.75f, (float)191.18f, (Matrix)secondMoments1_1125_2.inverse(), (float)1.0f);
        Ellipse e2_1125_2 = EllipseUtilities.ellipseFromCovariance((float)336.49698f, (float)184.81216f, (Matrix)secondMoments2_1125_2.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_1125_2, secondMoments2_1125_2, e1_1125_2, e2_1125_2, 0.076743f);
        Matrix secondMoments1_1200_2 = new Matrix((double[][])new double[][]{{0.001145f, -4.4E-5f}, {-4.4E-5f, 0.00108f}});
        Matrix secondMoments2_1200_2 = new Matrix((double[][])new double[][]{{9.0E-5f, -5.0E-6f}, {-5.0E-6f, 5.3E-5f}});
        Ellipse e1_1200_2 = EllipseUtilities.ellipseFromCovariance((float)332.75f, (float)191.18f, (Matrix)secondMoments1_1200_2.inverse(), (float)1.0f);
        Ellipse e2_1200_2 = EllipseUtilities.ellipseFromCovariance((float)336.90735f, (float)186.7591f, (Matrix)secondMoments2_1200_2.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_1200_2, secondMoments2_1200_2, e1_1200_2, e2_1200_2, 0.061274f);
        Matrix secondMoments1_1227_2 = new Matrix((double[][])new double[][]{{0.001145f, -4.4E-5f}, {-4.4E-5f, 0.00108f}});
        Matrix secondMoments2_1227_2 = new Matrix((double[][])new double[][]{{6.9E-5f, -7.0E-6f}, {-7.0E-6f, 4.5E-5f}});
        Ellipse e1_1227_2 = EllipseUtilities.ellipseFromCovariance((float)332.75f, (float)191.18f, (Matrix)secondMoments1_1227_2.inverse(), (float)1.0f);
        Ellipse e2_1227_2 = EllipseUtilities.ellipseFromCovariance((float)334.0204f, (float)183.70993f, (Matrix)secondMoments2_1227_2.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_1227_2, secondMoments2_1227_2, e1_1227_2, e2_1227_2, 0.04878f);
        Matrix secondMoments1_56_3 = new Matrix((double[][])new double[][]{{0.002428f, 4.24E-4f}, {4.24E-4f, 5.83E-4f}});
        Matrix secondMoments2_56_3 = new Matrix((double[][])new double[][]{{0.001432f, 3.31E-4f}, {3.31E-4f, 3.6E-4f}});
        Ellipse e1_56_3 = EllipseUtilities.ellipseFromCovariance((float)435.6f, (float)191.18f, (Matrix)secondMoments1_56_3.inverse(), (float)1.0f);
        Ellipse e2_56_3 = EllipseUtilities.ellipseFromCovariance((float)435.05408f, (float)192.22552f, (Matrix)secondMoments2_56_3.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_56_3, secondMoments2_56_3, e1_56_3, e2_56_3, 0.572848f);
        Matrix secondMoments1_158_3 = new Matrix((double[][])new double[][]{{0.002428f, 4.24E-4f}, {4.24E-4f, 5.83E-4f}});
        Matrix secondMoments2_158_3 = new Matrix((double[][])new double[][]{{0.001311f, 2.2E-4f}, {2.2E-4f, 2.57E-4f}});
        Ellipse e1_158_3 = EllipseUtilities.ellipseFromCovariance((float)435.6f, (float)191.18f, (Matrix)secondMoments1_158_3.inverse(), (float)1.0f);
        Ellipse e2_158_3 = EllipseUtilities.ellipseFromCovariance((float)435.86942f, (float)192.42447f, (Matrix)secondMoments2_158_3.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_158_3, secondMoments2_158_3, e1_158_3, e2_158_3, 0.483477f);
        Matrix secondMoments1_428_4 = new Matrix((double[][])new double[][]{{0.001743f, -2.79E-4f}, {-2.79E-4f, 7.53E-4f}});
        Matrix secondMoments2_428_4 = new Matrix((double[][])new double[][]{{6.41E-4f, -1.35E-4f}, {-1.35E-4f, 2.1E-4f}});
        Ellipse e1_428_4 = EllipseUtilities.ellipseFromCovariance((float)492.47f, (float)228.69f, (Matrix)secondMoments1_428_4.inverse(), (float)1.0f);
        Ellipse e2_428_4 = EllipseUtilities.ellipseFromCovariance((float)491.93384f, (float)234.39622f, (Matrix)secondMoments2_428_4.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_428_4, secondMoments2_428_4, e1_428_4, e2_428_4, 0.305591f);
        Matrix secondMoments1_516_4 = new Matrix((double[][])new double[][]{{0.001743f, -2.79E-4f}, {-2.79E-4f, 7.53E-4f}});
        Matrix secondMoments2_516_4 = new Matrix((double[][])new double[][]{{8.92E-4f, 1.66E-4f}, {1.66E-4f, 1.25E-4f}});
        Ellipse e1_516_4 = EllipseUtilities.ellipseFromCovariance((float)492.47f, (float)228.69f, (Matrix)secondMoments1_516_4.inverse(), (float)1.0f);
        Ellipse e2_516_4 = EllipseUtilities.ellipseFromCovariance((float)492.85583f, (float)226.03445f, (Matrix)secondMoments2_516_4.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_516_4, secondMoments2_516_4, e1_516_4, e2_516_4, 0.259701f);
        Matrix secondMoments1_627_4 = new Matrix((double[][])new double[][]{{0.001743f, -2.79E-4f}, {-2.79E-4f, 7.53E-4f}});
        Matrix secondMoments2_627_4 = new Matrix((double[][])new double[][]{{6.34E-4f, 1.33E-4f}, {1.33E-4f, 1.12E-4f}});
        Ellipse e1_627_4 = EllipseUtilities.ellipseFromCovariance((float)492.47f, (float)228.69f, (Matrix)secondMoments1_627_4.inverse(), (float)1.0f);
        Ellipse e2_627_4 = EllipseUtilities.ellipseFromCovariance((float)491.87662f, (float)226.47054f, (Matrix)secondMoments2_627_4.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_627_4, secondMoments2_627_4, e1_627_4, e2_627_4, 0.20772f);
        Matrix secondMoments1_669_4 = new Matrix((double[][])new double[][]{{0.001743f, -2.79E-4f}, {-2.79E-4f, 7.53E-4f}});
        Matrix secondMoments2_669_4 = new Matrix((double[][])new double[][]{{4.56E-4f, -6.0E-5f}, {-6.0E-5f, 1.31E-4f}});
        Ellipse e1_669_4 = EllipseUtilities.ellipseFromCovariance((float)492.47f, (float)228.69f, (Matrix)secondMoments1_669_4.inverse(), (float)1.0f);
        Ellipse e2_669_4 = EllipseUtilities.ellipseFromCovariance((float)491.16257f, (float)235.04578f, (Matrix)secondMoments2_669_4.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_669_4, secondMoments2_669_4, e1_669_4, e2_669_4, 0.213105f);
        Matrix secondMoments1_1149_4 = new Matrix((double[][])new double[][]{{0.001743f, -2.79E-4f}, {-2.79E-4f, 7.53E-4f}});
        Matrix secondMoments2_1149_4 = new Matrix((double[][])new double[][]{{1.16E-4f, -3.5E-5f}, {-3.5E-5f, 5.9E-5f}});
        Ellipse e1_1149_4 = EllipseUtilities.ellipseFromCovariance((float)492.47f, (float)228.69f, (Matrix)secondMoments1_1149_4.inverse(), (float)1.0f);
        Ellipse e2_1149_4 = EllipseUtilities.ellipseFromCovariance((float)491.60925f, (float)242.63493f, (Matrix)secondMoments2_1149_4.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_1149_4, secondMoments2_1149_4, e1_1149_4, e2_1149_4, 0.067179f);
        Matrix secondMoments1_365_5 = new Matrix((double[][])new double[][]{{9.58E-4f, -9.71E-4f}, {-9.71E-4f, 0.002273f}});
        Matrix secondMoments2_365_5 = new Matrix((double[][])new double[][]{{3.09E-4f, -2.72E-4f}, {-2.72E-4f, 8.08E-4f}});
        Ellipse e1_365_5 = EllipseUtilities.ellipseFromCovariance((float)337.59f, (float)240.79f, (Matrix)secondMoments1_365_5.inverse(), (float)1.0f);
        Ellipse e2_365_5 = EllipseUtilities.ellipseFromCovariance((float)336.63373f, (float)239.69354f, (Matrix)secondMoments2_365_5.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_365_5, secondMoments2_365_5, e1_365_5, e2_365_5, 0.379938f);
        Matrix secondMoments1_638_5 = new Matrix((double[][])new double[][]{{9.58E-4f, -9.71E-4f}, {-9.71E-4f, 0.002273f}});
        Matrix secondMoments2_638_5 = new Matrix((double[][])new double[][]{{2.17E-4f, -2.27E-4f}, {-2.27E-4f, 6.18E-4f}});
        Ellipse e1_638_5 = EllipseUtilities.ellipseFromCovariance((float)337.59f, (float)240.79f, (Matrix)secondMoments1_638_5.inverse(), (float)1.0f);
        Ellipse e2_638_5 = EllipseUtilities.ellipseFromCovariance((float)328.57718f, (float)245.18642f, (Matrix)secondMoments2_638_5.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_638_5, secondMoments2_638_5, e1_638_5, e2_638_5, 0.259821f);
        Matrix secondMoments1_838_5 = new Matrix((double[][])new double[][]{{9.58E-4f, -9.71E-4f}, {-9.71E-4f, 0.002273f}});
        Matrix secondMoments2_838_5 = new Matrix((double[][])new double[][]{{1.29E-4f, 1.01E-4f}, {1.01E-4f, 3.6E-4f}});
        Ellipse e1_838_5 = EllipseUtilities.ellipseFromCovariance((float)337.59f, (float)240.79f, (Matrix)secondMoments1_838_5.inverse(), (float)1.0f);
        Ellipse e2_838_5 = EllipseUtilities.ellipseFromCovariance((float)326.46143f, (float)235.04622f, (Matrix)secondMoments2_838_5.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_838_5, secondMoments2_838_5, e1_838_5, e2_838_5, 0.171267f);
        Matrix secondMoments1_996_5 = new Matrix((double[][])new double[][]{{9.58E-4f, -9.71E-4f}, {-9.71E-4f, 0.002273f}});
        Matrix secondMoments2_996_5 = new Matrix((double[][])new double[][]{{9.4E-5f, 7.4E-5f}, {7.4E-5f, 2.42E-4f}});
        Ellipse e1_996_5 = EllipseUtilities.ellipseFromCovariance((float)337.59f, (float)240.79f, (Matrix)secondMoments1_996_5.inverse(), (float)1.0f);
        Ellipse e2_996_5 = EllipseUtilities.ellipseFromCovariance((float)328.3563f, (float)234.28633f, (Matrix)secondMoments2_996_5.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_996_5, secondMoments2_996_5, e1_996_5, e2_996_5, 0.118915f);
        Matrix secondMoments1_1060_5 = new Matrix((double[][])new double[][]{{9.58E-4f, -9.71E-4f}, {-9.71E-4f, 0.002273f}});
        Matrix secondMoments2_1060_5 = new Matrix((double[][])new double[][]{{1.05E-4f, -8.0E-6f}, {-8.0E-6f, 1.13E-4f}});
        Ellipse e1_1060_5 = EllipseUtilities.ellipseFromCovariance((float)337.59f, (float)240.79f, (Matrix)secondMoments1_1060_5.inverse(), (float)1.0f);
        Ellipse e2_1060_5 = EllipseUtilities.ellipseFromCovariance((float)349.7317f, (float)234.44229f, (Matrix)secondMoments2_1060_5.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_1060_5, secondMoments2_1060_5, e1_1060_5, e2_1060_5, 0.095904f);
        Matrix secondMoments1_668_6 = new Matrix((double[][])new double[][]{{0.001354f, 5.23E-4f}, {5.23E-4f, 0.001113f}});
        Matrix secondMoments2_668_6 = new Matrix((double[][])new double[][]{{3.87E-4f, -8.5E-5f}, {-8.5E-5f, 1.69E-4f}});
        Ellipse e1_668_6 = EllipseUtilities.ellipseFromCovariance((float)574.75f, (float)249.26f, (Matrix)secondMoments1_668_6.inverse(), (float)1.0f);
        Ellipse e2_668_6 = EllipseUtilities.ellipseFromCovariance((float)565.2591f, (float)250.98895f, (Matrix)secondMoments2_668_6.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_668_6, secondMoments2_668_6, e1_668_6, e2_668_6, 0.218441f);
        Matrix secondMoments1_777_6 = new Matrix((double[][])new double[][]{{0.001354f, 5.23E-4f}, {5.23E-4f, 0.001113f}});
        Matrix secondMoments2_777_6 = new Matrix((double[][])new double[][]{{2.83E-4f, -3.2E-5f}, {-3.2E-5f, 1.45E-4f}});
        Ellipse e1_777_6 = EllipseUtilities.ellipseFromCovariance((float)574.75f, (float)249.26f, (Matrix)secondMoments1_777_6.inverse(), (float)1.0f);
        Ellipse e2_777_6 = EllipseUtilities.ellipseFromCovariance((float)567.0004f, (float)251.16943f, (Matrix)secondMoments2_777_6.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_777_6, secondMoments2_777_6, e1_777_6, e2_777_6, 0.180799f);
        Matrix secondMoments1_874_6 = new Matrix((double[][])new double[][]{{0.001354f, 5.23E-4f}, {5.23E-4f, 0.001113f}});
        Matrix secondMoments2_874_6 = new Matrix((double[][])new double[][]{{3.09E-4f, -6.3E-5f}, {-6.3E-5f, 9.7E-5f}});
        Ellipse e1_874_6 = EllipseUtilities.ellipseFromCovariance((float)574.75f, (float)249.26f, (Matrix)secondMoments1_874_6.inverse(), (float)1.0f);
        Ellipse e2_874_6 = EllipseUtilities.ellipseFromCovariance((float)566.1967f, (float)250.69354f, (Matrix)secondMoments2_874_6.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_874_6, secondMoments2_874_6, e1_874_6, e2_874_6, 0.1466f);
        Matrix secondMoments1_947_6 = new Matrix((double[][])new double[][]{{0.001354f, 5.23E-4f}, {5.23E-4f, 0.001113f}});
        Matrix secondMoments2_947_6 = new Matrix((double[][])new double[][]{{2.61E-4f, -5.4E-5f}, {-5.4E-5f, 7.5E-5f}});
        Ellipse e1_947_6 = EllipseUtilities.ellipseFromCovariance((float)574.75f, (float)249.26f, (Matrix)secondMoments1_947_6.inverse(), (float)1.0f);
        Ellipse e2_947_6 = EllipseUtilities.ellipseFromCovariance((float)567.4394f, (float)247.64919f, (Matrix)secondMoments2_947_6.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_947_6, secondMoments2_947_6, e1_947_6, e2_947_6, 0.117028f);
        Matrix secondMoments1_1311_6 = new Matrix((double[][])new double[][]{{0.001354f, 5.23E-4f}, {5.23E-4f, 0.001113f}});
        Matrix secondMoments2_1311_6 = new Matrix((double[][])new double[][]{{5.8E-5f, -9.0E-6f}, {-9.0E-6f, 1.6E-5f}});
        Ellipse e1_1311_6 = EllipseUtilities.ellipseFromCovariance((float)574.75f, (float)249.26f, (Matrix)secondMoments1_1311_6.inverse(), (float)1.0f);
        Ellipse e2_1311_6 = EllipseUtilities.ellipseFromCovariance((float)566.5724f, (float)256.81622f, (Matrix)secondMoments2_1311_6.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_1311_6, secondMoments2_1311_6, e1_1311_6, e2_1311_6, 0.025298f);
        Matrix secondMoments1_1315_6 = new Matrix((double[][])new double[][]{{0.001354f, 5.23E-4f}, {5.23E-4f, 0.001113f}});
        Matrix secondMoments2_1315_6 = new Matrix((double[][])new double[][]{{4.7E-5f, -8.0E-6f}, {-8.0E-6f, 1.8E-5f}});
        Ellipse e1_1315_6 = EllipseUtilities.ellipseFromCovariance((float)574.75f, (float)249.26f, (Matrix)secondMoments1_1315_6.inverse(), (float)1.0f);
        Ellipse e2_1315_6 = EllipseUtilities.ellipseFromCovariance((float)562.5378f, (float)255.1071f, (Matrix)secondMoments2_1315_6.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_1315_6, secondMoments2_1315_6, e1_1315_6, e2_1315_6, 0.024782f);
        Matrix secondMoments1_164_7 = new Matrix((double[][])new double[][]{{5.73E-4f, 4.92E-4f}, {4.92E-4f, 0.002577f}});
        Matrix secondMoments2_164_7 = new Matrix((double[][])new double[][]{{3.86E-4f, 4.74E-4f}, {4.74E-4f, 0.001509f}});
        Ellipse e1_164_7 = EllipseUtilities.ellipseFromCovariance((float)383.57f, (float)254.1f, (Matrix)secondMoments1_164_7.inverse(), (float)1.0f);
        Ellipse e2_164_7 = EllipseUtilities.ellipseFromCovariance((float)384.6428f, (float)253.1833f, (Matrix)secondMoments2_164_7.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_164_7, secondMoments2_164_7, e1_164_7, e2_164_7, 0.53905f);
        Matrix secondMoments1_9_8 = new Matrix((double[][])new double[][]{{0.001197f, 8.42E-4f}, {8.42E-4f, 0.001625f}});
        Matrix secondMoments2_9_8 = new Matrix((double[][])new double[][]{{0.001259f, 0.001575f}, {0.001575f, 0.002509f}});
        Ellipse e1_9_8 = EllipseUtilities.ellipseFromCovariance((float)400.51f, (float)263.78f, (Matrix)secondMoments1_9_8.inverse(), (float)1.0f);
        Ellipse e2_9_8 = EllipseUtilities.ellipseFromCovariance((float)408.48132f, (float)259.5347f, (Matrix)secondMoments2_9_8.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_9_8, secondMoments2_9_8, e1_9_8, e2_9_8, 0.580043f);
        Matrix secondMoments1_63_8 = new Matrix((double[][])new double[][]{{0.001197f, 8.42E-4f}, {8.42E-4f, 0.001625f}});
        Matrix secondMoments2_63_8 = new Matrix((double[][])new double[][]{{9.68E-4f, 0.001248f}, {0.001248f, 0.002056f}});
        Ellipse e1_63_8 = EllipseUtilities.ellipseFromCovariance((float)400.51f, (float)263.78f, (Matrix)secondMoments1_63_8.inverse(), (float)1.0f);
        Ellipse e2_63_8 = EllipseUtilities.ellipseFromCovariance((float)408.23398f, (float)260.16122f, (Matrix)secondMoments2_63_8.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_63_8, secondMoments2_63_8, e1_63_8, e2_63_8, 0.536834f);
        Matrix secondMoments1_65_8 = new Matrix((double[][])new double[][]{{0.001197f, 8.42E-4f}, {8.42E-4f, 0.001625f}});
        Matrix secondMoments2_65_8 = new Matrix((double[][])new double[][]{{7.71E-4f, 9.45E-4f}, {9.45E-4f, 0.001809f}});
        Ellipse e1_65_8 = EllipseUtilities.ellipseFromCovariance((float)400.51f, (float)263.78f, (Matrix)secondMoments1_65_8.inverse(), (float)1.0f);
        Ellipse e2_65_8 = EllipseUtilities.ellipseFromCovariance((float)411.98376f, (float)264.16464f, (Matrix)secondMoments2_65_8.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_65_8, secondMoments2_65_8, e1_65_8, e2_65_8, 0.511713f);
        Matrix secondMoments1_1365_9 = new Matrix((double[][])new double[][]{{0.001053f, 8.82E-4f}, {8.82E-4f, 0.001912f}});
        Matrix secondMoments2_1365_9 = new Matrix((double[][])new double[][]{{1.3E-5f, -6.0E-6f}, {-6.0E-6f, 2.6E-5f}});
        Ellipse e1_1365_9 = EllipseUtilities.ellipseFromCovariance((float)393.25f, (float)266.2f, (Matrix)secondMoments1_1365_9.inverse(), (float)1.0f);
        Ellipse e2_1365_9 = EllipseUtilities.ellipseFromCovariance((float)383.42523f, (float)274.20898f, (Matrix)secondMoments2_1365_9.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_1365_9, secondMoments2_1365_9, e1_1365_9, e2_1365_9, 0.016473f);
        Matrix secondMoments1_1388_9 = new Matrix((double[][])new double[][]{{0.001053f, 8.82E-4f}, {8.82E-4f, 0.001912f}});
        Matrix secondMoments2_1388_9 = new Matrix((double[][])new double[][]{{1.1E-5f, -1.3E-5f}, {-1.3E-5f, 2.9E-5f}});
        Ellipse e1_1388_9 = EllipseUtilities.ellipseFromCovariance((float)393.25f, (float)266.2f, (Matrix)secondMoments1_1388_9.inverse(), (float)1.0f);
        Ellipse e2_1388_9 = EllipseUtilities.ellipseFromCovariance((float)380.05228f, (float)270.74356f, (Matrix)secondMoments2_1388_9.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_1388_9, secondMoments2_1388_9, e1_1388_9, e2_1388_9, 0.011116f);
        Matrix secondMoments1_9_10 = new Matrix((double[][])new double[][]{{0.001525f, 0.00164f}, {0.00164f, 0.002574f}});
        Matrix secondMoments2_9_10 = new Matrix((double[][])new double[][]{{0.001211f, 0.001514f}, {0.001514f, 0.002412f}});
        Ellipse e1_9_10 = EllipseUtilities.ellipseFromCovariance((float)407.77f, (float)266.2f, (Matrix)secondMoments1_9_10.inverse(), (float)1.0f);
        Ellipse e2_9_10 = EllipseUtilities.ellipseFromCovariance((float)408.48132f, (float)259.5347f, (Matrix)secondMoments2_9_10.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_9_10, secondMoments2_9_10, e1_9_10, e2_9_10, 0.57732f);
        Matrix secondMoments1_63_10 = new Matrix((double[][])new double[][]{{0.001525f, 0.00164f}, {0.00164f, 0.002574f}});
        Matrix secondMoments2_63_10 = new Matrix((double[][])new double[][]{{9.3E-4f, 0.0012f}, {0.0012f, 0.001976f}});
        Ellipse e1_63_10 = EllipseUtilities.ellipseFromCovariance((float)407.77f, (float)266.2f, (Matrix)secondMoments1_63_10.inverse(), (float)1.0f);
        Ellipse e2_63_10 = EllipseUtilities.ellipseFromCovariance((float)408.23398f, (float)260.16122f, (Matrix)secondMoments2_63_10.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_63_10, secondMoments2_63_10, e1_63_10, e2_63_10, 0.524812f);
        Matrix secondMoments1_65_10 = new Matrix((double[][])new double[][]{{0.001525f, 0.00164f}, {0.00164f, 0.002574f}});
        Matrix secondMoments2_65_10 = new Matrix((double[][])new double[][]{{7.41E-4f, 9.08E-4f}, {9.08E-4f, 0.001739f}});
        Ellipse e1_65_10 = EllipseUtilities.ellipseFromCovariance((float)407.77f, (float)266.2f, (Matrix)secondMoments1_65_10.inverse(), (float)1.0f);
        Ellipse e2_65_10 = EllipseUtilities.ellipseFromCovariance((float)411.98376f, (float)264.16464f, (Matrix)secondMoments2_65_10.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_65_10, secondMoments2_65_10, e1_65_10, e2_65_10, 0.615385f);
        Matrix secondMoments1_563_11 = new Matrix((double[][])new double[][]{{0.001142f, 1.97E-4f}, {1.97E-4f, 0.001115f}});
        Matrix secondMoments2_563_11 = new Matrix((double[][])new double[][]{{3.67E-4f, 1.6E-4f}, {1.6E-4f, 3.64E-4f}});
        Ellipse e1_563_11 = EllipseUtilities.ellipseFromCovariance((float)451.33f, (float)267.41f, (Matrix)secondMoments1_563_11.inverse(), (float)1.0f);
        Ellipse e2_563_11 = EllipseUtilities.ellipseFromCovariance((float)442.27594f, (float)258.45688f, (Matrix)secondMoments2_563_11.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_563_11, secondMoments2_563_11, e1_563_11, e2_563_11, 0.292264f);
        Matrix secondMoments1_637_11 = new Matrix((double[][])new double[][]{{0.001142f, 1.97E-4f}, {1.97E-4f, 0.001115f}});
        Matrix secondMoments2_637_11 = new Matrix((double[][])new double[][]{{2.7E-4f, 1.28E-4f}, {1.28E-4f, 3.27E-4f}});
        Ellipse e1_637_11 = EllipseUtilities.ellipseFromCovariance((float)451.33f, (float)267.41f, (Matrix)secondMoments1_637_11.inverse(), (float)1.0f);
        Ellipse e2_637_11 = EllipseUtilities.ellipseFromCovariance((float)438.14426f, (float)264.25516f, (Matrix)secondMoments2_637_11.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_637_11, secondMoments2_637_11, e1_637_11, e2_637_11, 0.241868f);
        Matrix secondMoments1_739_11 = new Matrix((double[][])new double[][]{{0.001142f, 1.97E-4f}, {1.97E-4f, 0.001115f}});
        Matrix secondMoments2_739_11 = new Matrix((double[][])new double[][]{{2.42E-4f, 9.9E-5f}, {9.9E-5f, 2.2E-4f}});
        Ellipse e1_739_11 = EllipseUtilities.ellipseFromCovariance((float)451.33f, (float)267.41f, (Matrix)secondMoments1_739_11.inverse(), (float)1.0f);
        Ellipse e2_739_11 = EllipseUtilities.ellipseFromCovariance((float)443.5061f, (float)258.97437f, (Matrix)secondMoments2_739_11.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_739_11, secondMoments2_739_11, e1_739_11, e2_739_11, 0.187706f);
        Matrix secondMoments1_782_11 = new Matrix((double[][])new double[][]{{0.001142f, 1.97E-4f}, {1.97E-4f, 0.001115f}});
        Matrix secondMoments2_782_11 = new Matrix((double[][])new double[][]{{2.58E-4f, 1.04E-4f}, {1.04E-4f, 2.29E-4f}});
        Ellipse e1_782_11 = EllipseUtilities.ellipseFromCovariance((float)451.33f, (float)267.41f, (Matrix)secondMoments1_782_11.inverse(), (float)1.0f);
        Ellipse e2_782_11 = EllipseUtilities.ellipseFromCovariance((float)442.6067f, (float)260.86847f, (Matrix)secondMoments2_782_11.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_782_11, secondMoments2_782_11, e1_782_11, e2_782_11, 0.198262f);
        Matrix secondMoments1_9_12 = new Matrix((double[][])new double[][]{{0.001146f, 8.03E-4f}, {8.03E-4f, 0.00164f}});
        Matrix secondMoments2_9_12 = new Matrix((double[][])new double[][]{{0.001229f, 0.001538f}, {0.001538f, 0.002449f}});
        Ellipse e1_9_12 = EllipseUtilities.ellipseFromCovariance((float)400.51f, (float)268.62f, (Matrix)secondMoments1_9_12.inverse(), (float)1.0f);
        Ellipse e2_9_12 = EllipseUtilities.ellipseFromCovariance((float)408.48132f, (float)259.5347f, (Matrix)secondMoments2_9_12.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_9_12, secondMoments2_9_12, e1_9_12, e2_9_12, 0.55089f);
        Matrix secondMoments1_63_12 = new Matrix((double[][])new double[][]{{0.001146f, 8.03E-4f}, {8.03E-4f, 0.00164f}});
        Matrix secondMoments2_63_12 = new Matrix((double[][])new double[][]{{9.45E-4f, 0.001218f}, {0.001218f, 0.002007f}});
        Ellipse e1_63_12 = EllipseUtilities.ellipseFromCovariance((float)400.51f, (float)268.62f, (Matrix)secondMoments1_63_12.inverse(), (float)1.0f);
        Ellipse e2_63_12 = EllipseUtilities.ellipseFromCovariance((float)408.23398f, (float)260.16122f, (Matrix)secondMoments2_63_12.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_63_12, secondMoments2_63_12, e1_63_12, e2_63_12, 0.504769f);
        Matrix secondMoments1_65_12 = new Matrix((double[][])new double[][]{{0.001146f, 8.03E-4f}, {8.03E-4f, 0.00164f}});
        Matrix secondMoments2_65_12 = new Matrix((double[][])new double[][]{{7.52E-4f, 9.22E-4f}, {9.22E-4f, 0.001766f}});
        Ellipse e1_65_12 = EllipseUtilities.ellipseFromCovariance((float)400.51f, (float)268.62f, (Matrix)secondMoments1_65_12.inverse(), (float)1.0f);
        Ellipse e2_65_12 = EllipseUtilities.ellipseFromCovariance((float)411.98376f, (float)264.16464f, (Matrix)secondMoments2_65_12.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_65_12, secondMoments2_65_12, e1_65_12, e2_65_12, 0.585214f);
        Matrix secondMoments1_15_13 = new Matrix((double[][])new double[][]{{6.6E-4f, 1.47E-4f}, {1.47E-4f, 0.001903f}});
        Matrix secondMoments2_15_13 = new Matrix((double[][])new double[][]{{5.12E-4f, 9.9E-5f}, {9.9E-5f, 0.001657f}});
        Ellipse e1_15_13 = EllipseUtilities.ellipseFromCovariance((float)95.59f, (float)274.67f, (Matrix)secondMoments1_15_13.inverse(), (float)1.0f);
        Ellipse e2_15_13 = EllipseUtilities.ellipseFromCovariance((float)96.2562f, (float)271.63718f, (Matrix)secondMoments2_15_13.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_15_13, secondMoments2_15_13, e1_15_13, e2_15_13, 0.793562f);
        Matrix secondMoments1_81_13 = new Matrix((double[][])new double[][]{{6.6E-4f, 1.47E-4f}, {1.47E-4f, 0.001903f}});
        Matrix secondMoments2_81_13 = new Matrix((double[][])new double[][]{{5.37E-4f, 1.07E-4f}, {1.07E-4f, 0.00119f}});
        Ellipse e1_81_13 = EllipseUtilities.ellipseFromCovariance((float)95.59f, (float)274.67f, (Matrix)secondMoments1_81_13.inverse(), (float)1.0f);
        Ellipse e2_81_13 = EllipseUtilities.ellipseFromCovariance((float)95.77783f, (float)271.37582f, (Matrix)secondMoments2_81_13.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_81_13, secondMoments2_81_13, e1_81_13, e2_81_13, 0.713031f);
        Matrix secondMoments1_176_13 = new Matrix((double[][])new double[][]{{6.6E-4f, 1.47E-4f}, {1.47E-4f, 0.001903f}});
        Matrix secondMoments2_176_13 = new Matrix((double[][])new double[][]{{3.72E-4f, 8.5E-5f}, {8.5E-5f, 0.001114f}});
        Ellipse e1_176_13 = EllipseUtilities.ellipseFromCovariance((float)95.59f, (float)274.67f, (Matrix)secondMoments1_176_13.inverse(), (float)1.0f);
        Ellipse e2_176_13 = EllipseUtilities.ellipseFromCovariance((float)96.78289f, (float)272.08044f, (Matrix)secondMoments2_176_13.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_176_13, secondMoments2_176_13, e1_176_13, e2_176_13, 0.572466f);
        Matrix secondMoments1_502_13 = new Matrix((double[][])new double[][]{{6.6E-4f, 1.47E-4f}, {1.47E-4f, 0.001903f}});
        Matrix secondMoments2_502_13 = new Matrix((double[][])new double[][]{{5.76E-4f, -5.6E-5f}, {-5.6E-5f, 2.2E-4f}});
        Ellipse e1_502_13 = EllipseUtilities.ellipseFromCovariance((float)95.59f, (float)274.67f, (Matrix)secondMoments1_502_13.inverse(), (float)1.0f);
        Ellipse e2_502_13 = EllipseUtilities.ellipseFromCovariance((float)91.53244f, (float)286.34457f, (Matrix)secondMoments2_502_13.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_502_13, secondMoments2_502_13, e1_502_13, e2_502_13, 0.307848f);
        Matrix secondMoments1_583_13 = new Matrix((double[][])new double[][]{{6.6E-4f, 1.47E-4f}, {1.47E-4f, 0.001903f}});
        Matrix secondMoments2_583_13 = new Matrix((double[][])new double[][]{{9.7E-5f, -3.1E-5f}, {-3.1E-5f, 0.001458f}});
        Ellipse e1_583_13 = EllipseUtilities.ellipseFromCovariance((float)95.59f, (float)274.67f, (Matrix)secondMoments1_583_13.inverse(), (float)1.0f);
        Ellipse e2_583_13 = EllipseUtilities.ellipseFromCovariance((float)94.860435f, (float)282.85873f, (Matrix)secondMoments2_583_13.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_583_13, secondMoments2_583_13, e1_583_13, e2_583_13, 0.304291f);
        Matrix secondMoments1_640_13 = new Matrix((double[][])new double[][]{{6.6E-4f, 1.47E-4f}, {1.47E-4f, 0.001903f}});
        Matrix secondMoments2_640_13 = new Matrix((double[][])new double[][]{{1.38E-4f, -2.0E-6f}, {-2.0E-6f, 6.2E-4f}});
        Ellipse e1_640_13 = EllipseUtilities.ellipseFromCovariance((float)95.59f, (float)274.67f, (Matrix)secondMoments1_640_13.inverse(), (float)1.0f);
        Ellipse e2_640_13 = EllipseUtilities.ellipseFromCovariance((float)95.10278f, (float)281.83633f, (Matrix)secondMoments2_640_13.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_640_13, secondMoments2_640_13, e1_640_13, e2_640_13, 0.263184f);
        Matrix secondMoments1_846_13 = new Matrix((double[][])new double[][]{{6.6E-4f, 1.47E-4f}, {1.47E-4f, 0.001903f}});
        Matrix secondMoments2_846_13 = new Matrix((double[][])new double[][]{{1.0E-4f, -3.0E-6f}, {-3.0E-6f, 4.45E-4f}});
        Ellipse e1_846_13 = EllipseUtilities.ellipseFromCovariance((float)95.59f, (float)274.67f, (Matrix)secondMoments1_846_13.inverse(), (float)1.0f);
        Ellipse e2_846_13 = EllipseUtilities.ellipseFromCovariance((float)92.76451f, (float)288.55008f, (Matrix)secondMoments2_846_13.inverse(), (float)1.0f);
        IPDRepeatability.doTest(secondMoments1_846_13, secondMoments2_846_13, e1_846_13, e2_846_13, 0.18957f);
        Matrix matrix = new Matrix((double[][])new double[][]{{6.6E-4f, 1.47E-4f}, {1.47E-4f, 0.001903f}});
        Matrix matrix2 = new Matrix((double[][])new double[][]{{6.02E-4f, -0.0}, {-0.0, 6.3E-5f}});
        Ellipse ellipse = EllipseUtilities.ellipseFromCovariance((float)95.59f, (float)274.67f, (Matrix)secondMoments1_883_13.inverse(), (float)1.0f);
        Ellipse ellipse2 = EllipseUtilities.ellipseFromCovariance((float)93.45989f, (float)267.1118f, (Matrix)secondMoments2_883_13.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_883_13, (Matrix)secondMoments2_883_13, (Ellipse)e1_883_13, (Ellipse)e2_883_13, 0.17642f);
        Matrix matrix3 = new Matrix((double[][])new double[][]{{6.6E-4f, 1.47E-4f}, {1.47E-4f, 0.001903f}});
        Matrix matrix4 = new Matrix((double[][])new double[][]{{6.6E-5f, -0.0}, {-0.0, 2.1E-5f}});
        Ellipse ellipse3 = EllipseUtilities.ellipseFromCovariance((float)95.59f, (float)274.67f, (Matrix)secondMoments1_1312_13.inverse(), (float)1.0f);
        Ellipse ellipse4 = EllipseUtilities.ellipseFromCovariance((float)97.90647f, (float)268.44067f, (Matrix)secondMoments2_1312_13.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_1312_13, (Matrix)secondMoments2_1312_13, (Ellipse)e1_1312_13, (Ellipse)e2_1312_13, 0.033122f);
        Matrix matrix5 = new Matrix((double[][])new double[][]{{6.29E-4f, 6.51E-4f}, {6.51E-4f, 0.002635f}});
        Matrix matrix6 = new Matrix((double[][])new double[][]{{3.33E-4f, 4.25E-4f}, {4.25E-4f, 0.001766f}});
        Ellipse ellipse5 = EllipseUtilities.ellipseFromCovariance((float)735.68f, (float)289.19f, (Matrix)secondMoments1_7_14.inverse(), (float)1.0f);
        Ellipse ellipse6 = EllipseUtilities.ellipseFromCovariance((float)735.2157f, (float)289.47037f, (Matrix)secondMoments2_7_14.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_7_14, (Matrix)secondMoments2_7_14, (Ellipse)e1_7_14, (Ellipse)e2_7_14, 0.574898f);
        Matrix matrix7 = new Matrix((double[][])new double[][]{{6.29E-4f, 6.51E-4f}, {6.51E-4f, 0.002635f}});
        Matrix matrix8 = new Matrix((double[][])new double[][]{{2.4E-4f, 3.57E-4f}, {3.57E-4f, 0.001342f}});
        Ellipse ellipse7 = EllipseUtilities.ellipseFromCovariance((float)735.68f, (float)289.19f, (Matrix)secondMoments1_160_14.inverse(), (float)1.0f);
        Ellipse ellipse8 = EllipseUtilities.ellipseFromCovariance((float)737.2195f, (float)288.98636f, (Matrix)secondMoments2_160_14.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_160_14, (Matrix)secondMoments2_160_14, (Ellipse)e1_160_14, (Ellipse)e2_160_14, 0.398695f);
        Matrix matrix9 = new Matrix((double[][])new double[][]{{6.29E-4f, 6.51E-4f}, {6.51E-4f, 0.002635f}});
        Matrix matrix10 = new Matrix((double[][])new double[][]{{1.45E-4f, 1.72E-4f}, {1.72E-4f, 6.49E-4f}});
        Ellipse ellipse9 = EllipseUtilities.ellipseFromCovariance((float)735.68f, (float)289.19f, (Matrix)secondMoments1_554_14.inverse(), (float)1.0f);
        Ellipse ellipse10 = EllipseUtilities.ellipseFromCovariance((float)737.72626f, (float)289.16522f, (Matrix)secondMoments2_554_14.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_554_14, (Matrix)secondMoments2_554_14, (Ellipse)e1_554_14, (Ellipse)e2_554_14, 0.22817f);
        Matrix matrix11 = new Matrix((double[][])new double[][]{{6.29E-4f, 6.51E-4f}, {6.51E-4f, 0.002635f}});
        Matrix matrix12 = new Matrix((double[][])new double[][]{{1.21E-4f, 7.1E-5f}, {7.1E-5f, 2.73E-4f}});
        Ellipse ellipse11 = EllipseUtilities.ellipseFromCovariance((float)735.68f, (float)289.19f, (Matrix)secondMoments1_776_14.inverse(), (float)1.0f);
        Ellipse ellipse12 = EllipseUtilities.ellipseFromCovariance((float)737.1463f, (float)287.77185f, (Matrix)secondMoments2_776_14.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_776_14, (Matrix)secondMoments2_776_14, (Ellipse)e1_776_14, (Ellipse)e2_776_14, 0.150452f);
        Matrix matrix13 = new Matrix((double[][])new double[][]{{6.21E-4f, 2.38E-4f}, {2.38E-4f, 0.002079f}});
        Matrix matrix14 = new Matrix((double[][])new double[][]{{2.71E-4f, 2.65E-4f}, {2.65E-4f, 0.001672f}});
        Ellipse ellipse13 = EllipseUtilities.ellipseFromCovariance((float)486.42f, (float)306.13f, (Matrix)secondMoments1_68_15.inverse(), (float)1.0f);
        Ellipse ellipse14 = EllipseUtilities.ellipseFromCovariance((float)485.4356f, (float)306.18365f, (Matrix)secondMoments2_68_15.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_68_15, (Matrix)secondMoments2_68_15, (Ellipse)e1_68_15, (Ellipse)e2_68_15, 0.555658f);
        Matrix matrix15 = new Matrix((double[][])new double[][]{{6.21E-4f, 2.38E-4f}, {2.38E-4f, 0.002079f}});
        Matrix matrix16 = new Matrix((double[][])new double[][]{{2.24E-4f, 2.11E-4f}, {2.11E-4f, 0.001501f}});
        Ellipse ellipse15 = EllipseUtilities.ellipseFromCovariance((float)486.42f, (float)306.13f, (Matrix)secondMoments1_167_15.inverse(), (float)1.0f);
        Ellipse ellipse16 = EllipseUtilities.ellipseFromCovariance((float)484.11084f, (float)305.83664f, (Matrix)secondMoments2_167_15.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_167_15, (Matrix)secondMoments2_167_15, (Ellipse)e1_167_15, (Ellipse)e2_167_15, 0.486276f);
        Matrix matrix17 = new Matrix((double[][])new double[][]{{6.21E-4f, 2.38E-4f}, {2.38E-4f, 0.002079f}});
        Matrix matrix18 = new Matrix((double[][])new double[][]{{1.76E-4f, 1.68E-4f}, {1.68E-4f, 0.001212f}});
        Ellipse ellipse17 = EllipseUtilities.ellipseFromCovariance((float)486.42f, (float)306.13f, (Matrix)secondMoments1_281_15.inverse(), (float)1.0f);
        Ellipse ellipse18 = EllipseUtilities.ellipseFromCovariance((float)485.02133f, (float)306.07513f, (Matrix)secondMoments2_281_15.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_281_15, (Matrix)secondMoments2_281_15, (Ellipse)e1_281_15, (Ellipse)e2_281_15, 0.38794f);
        Matrix matrix19 = new Matrix((double[][])new double[][]{{6.21E-4f, 2.38E-4f}, {2.38E-4f, 0.002079f}});
        Matrix matrix20 = new Matrix((double[][])new double[][]{{4.14E-4f, -2.9E-4f}, {-2.9E-4f, 6.89E-4f}});
        Ellipse ellipse19 = EllipseUtilities.ellipseFromCovariance((float)486.42f, (float)306.13f, (Matrix)secondMoments1_284_15.inverse(), (float)1.0f);
        Ellipse ellipse20 = EllipseUtilities.ellipseFromCovariance((float)490.3259f, (float)314.9144f, (Matrix)secondMoments2_284_15.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_284_15, (Matrix)secondMoments2_284_15, (Ellipse)e1_284_15, (Ellipse)e2_284_15, 0.391179f);
        Matrix matrix21 = new Matrix((double[][])new double[][]{{6.21E-4f, 2.38E-4f}, {2.38E-4f, 0.002079f}});
        Matrix matrix22 = new Matrix((double[][])new double[][]{{1.5E-4f, 1.5E-4f}, {1.5E-4f, 0.001084f}});
        Ellipse ellipse21 = EllipseUtilities.ellipseFromCovariance((float)486.42f, (float)306.13f, (Matrix)secondMoments1_437_15.inverse(), (float)1.0f);
        Ellipse ellipse22 = EllipseUtilities.ellipseFromCovariance((float)482.68347f, (float)305.83472f, (Matrix)secondMoments2_437_15.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_437_15, (Matrix)secondMoments2_437_15, (Ellipse)e1_437_15, (Ellipse)e2_437_15, 0.337182f);
        Matrix matrix23 = new Matrix((double[][])new double[][]{{6.21E-4f, 2.38E-4f}, {2.38E-4f, 0.002079f}});
        Matrix matrix24 = new Matrix((double[][])new double[][]{{1.59E-4f, 2.1E-5f}, {2.1E-5f, 5.37E-4f}});
        Ellipse ellipse23 = EllipseUtilities.ellipseFromCovariance((float)486.42f, (float)306.13f, (Matrix)secondMoments1_570_15.inverse(), (float)1.0f);
        Ellipse ellipse24 = EllipseUtilities.ellipseFromCovariance((float)482.17514f, (float)304.67825f, (Matrix)secondMoments2_570_15.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_570_15, (Matrix)secondMoments2_570_15, (Ellipse)e1_570_15, (Ellipse)e2_570_15, 0.262092f);
        Matrix matrix25 = new Matrix((double[][])new double[][]{{0.001599f, 4.93E-4f}, {4.93E-4f, 9.24E-4f}});
        Matrix matrix26 = new Matrix((double[][])new double[][]{{6.33E-4f, 2.95E-4f}, {2.95E-4f, 9.5E-4f}});
        Ellipse ellipse25 = EllipseUtilities.ellipseFromCovariance((float)464.64f, (float)315.81f, (Matrix)secondMoments1_10_16.inverse(), (float)1.0f);
        Ellipse ellipse26 = EllipseUtilities.ellipseFromCovariance((float)461.03592f, (float)312.04227f, (Matrix)secondMoments2_10_16.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_10_16, (Matrix)secondMoments2_10_16, (Ellipse)e1_10_16, (Ellipse)e2_10_16, 0.592315f);
        Matrix matrix27 = new Matrix((double[][])new double[][]{{0.001599f, 4.93E-4f}, {4.93E-4f, 9.24E-4f}});
        Matrix matrix28 = new Matrix((double[][])new double[][]{{6.46E-4f, 2.23E-4f}, {2.23E-4f, 6.56E-4f}});
        Ellipse ellipse27 = EllipseUtilities.ellipseFromCovariance((float)464.64f, (float)315.81f, (Matrix)secondMoments1_71_16.inverse(), (float)1.0f);
        Ellipse ellipse28 = EllipseUtilities.ellipseFromCovariance((float)466.6459f, (float)316.58856f, (Matrix)secondMoments2_71_16.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_71_16, (Matrix)secondMoments2_71_16, (Ellipse)e1_71_16, (Ellipse)e2_71_16, 0.550661f);
        Matrix matrix29 = new Matrix((double[][])new double[][]{{0.001599f, 4.93E-4f}, {4.93E-4f, 9.24E-4f}});
        Matrix matrix30 = new Matrix((double[][])new double[][]{{0.001083f, -2.52E-4f}, {-2.52E-4f, 4.35E-4f}});
        Ellipse ellipse29 = EllipseUtilities.ellipseFromCovariance((float)464.64f, (float)315.81f, (Matrix)secondMoments1_73_16.inverse(), (float)1.0f);
        Ellipse ellipse30 = EllipseUtilities.ellipseFromCovariance((float)455.66217f, (float)321.3276f, (Matrix)secondMoments2_73_16.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_73_16, (Matrix)secondMoments2_73_16, (Ellipse)e1_73_16, (Ellipse)e2_73_16, 0.430947f);
        Matrix matrix31 = new Matrix((double[][])new double[][]{{0.001599f, 4.93E-4f}, {4.93E-4f, 9.24E-4f}});
        Matrix matrix32 = new Matrix((double[][])new double[][]{{2.63E-4f, 1.55E-4f}, {1.55E-4f, 5.96E-4f}});
        Ellipse ellipse31 = EllipseUtilities.ellipseFromCovariance((float)464.64f, (float)315.81f, (Matrix)secondMoments1_386_16.inverse(), (float)1.0f);
        Ellipse ellipse32 = EllipseUtilities.ellipseFromCovariance((float)462.82724f, (float)312.51535f, (Matrix)secondMoments2_386_16.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_386_16, (Matrix)secondMoments2_386_16, (Ellipse)e1_386_16, (Ellipse)e2_386_16, 0.328313f);
        Matrix matrix33 = new Matrix((double[][])new double[][]{{0.001599f, 4.93E-4f}, {4.93E-4f, 9.24E-4f}});
        Matrix matrix34 = new Matrix((double[][])new double[][]{{7.2E-4f, 3.3E-5f}, {3.3E-5f, 1.74E-4f}});
        Ellipse ellipse33 = EllipseUtilities.ellipseFromCovariance((float)464.64f, (float)315.81f, (Matrix)secondMoments1_440_16.inverse(), (float)1.0f);
        Ellipse ellipse34 = EllipseUtilities.ellipseFromCovariance((float)456.31693f, (float)311.14423f, (Matrix)secondMoments2_440_16.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_440_16, (Matrix)secondMoments2_440_16, (Ellipse)e1_440_16, (Ellipse)e2_440_16, 0.316909f);
        Matrix matrix35 = new Matrix((double[][])new double[][]{{0.001599f, 4.93E-4f}, {4.93E-4f, 9.24E-4f}});
        Matrix matrix36 = new Matrix((double[][])new double[][]{{7.1E-4f, 6.1E-5f}, {6.1E-5f, 1.33E-4f}});
        Ellipse ellipse35 = EllipseUtilities.ellipseFromCovariance((float)464.64f, (float)315.81f, (Matrix)secondMoments1_501_16.inverse(), (float)1.0f);
        Ellipse ellipse36 = EllipseUtilities.ellipseFromCovariance((float)456.26697f, (float)310.32428f, (Matrix)secondMoments2_501_16.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_501_16, (Matrix)secondMoments2_501_16, (Ellipse)e1_501_16, (Ellipse)e2_501_16, 0.271487f);
        Matrix matrix37 = new Matrix((double[][])new double[][]{{0.001599f, 4.93E-4f}, {4.93E-4f, 9.24E-4f}});
        Matrix matrix38 = new Matrix((double[][])new double[][]{{5.92E-4f, 3.7E-5f}, {3.7E-5f, 1.42E-4f}});
        Ellipse ellipse37 = EllipseUtilities.ellipseFromCovariance((float)464.64f, (float)315.81f, (Matrix)secondMoments1_573_16.inverse(), (float)1.0f);
        Ellipse ellipse38 = EllipseUtilities.ellipseFromCovariance((float)456.40067f, (float)309.131f, (Matrix)secondMoments2_573_16.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_573_16, (Matrix)secondMoments2_573_16, (Ellipse)e1_573_16, (Ellipse)e2_573_16, 0.259374f);
        Matrix matrix39 = new Matrix((double[][])new double[][]{{0.001599f, 4.93E-4f}, {4.93E-4f, 9.24E-4f}});
        Matrix matrix40 = new Matrix((double[][])new double[][]{{1.83E-4f, 1.2E-5f}, {1.2E-5f, 7.0E-5f}});
        Ellipse ellipse39 = EllipseUtilities.ellipseFromCovariance((float)464.64f, (float)315.81f, (Matrix)secondMoments1_997_16.inverse(), (float)1.0f);
        Ellipse ellipse40 = EllipseUtilities.ellipseFromCovariance((float)458.80826f, (float)308.42197f, (Matrix)secondMoments2_997_16.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_997_16, (Matrix)secondMoments2_997_16, (Ellipse)e1_997_16, (Ellipse)e2_997_16, 0.102489f);
        Matrix matrix41 = new Matrix((double[][])new double[][]{{0.001362f, -7.74E-4f}, {-7.74E-4f, 0.001346f}});
        Matrix matrix42 = new Matrix((double[][])new double[][]{{7.46E-4f, -5.33E-4f}, {-5.33E-4f, 0.001187f}});
        Ellipse ellipse41 = EllipseUtilities.ellipseFromCovariance((float)314.6f, (float)318.23f, (Matrix)secondMoments1_39_17.inverse(), (float)1.0f);
        Ellipse ellipse42 = EllipseUtilities.ellipseFromCovariance((float)313.9537f, (float)317.9001f, (Matrix)secondMoments2_39_17.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_39_17, (Matrix)secondMoments2_39_17, (Ellipse)e1_39_17, (Ellipse)e2_39_17, 0.697906f);
        Matrix matrix43 = new Matrix((double[][])new double[][]{{0.001362f, -7.74E-4f}, {-7.74E-4f, 0.001346f}});
        Matrix matrix44 = new Matrix((double[][])new double[][]{{5.38E-4f, -4.03E-4f}, {-4.03E-4f, 9.19E-4f}});
        Ellipse ellipse43 = EllipseUtilities.ellipseFromCovariance((float)314.6f, (float)318.23f, (Matrix)secondMoments1_173_17.inverse(), (float)1.0f);
        Ellipse ellipse44 = EllipseUtilities.ellipseFromCovariance((float)313.22552f, (float)318.4468f, (Matrix)secondMoments2_173_17.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_173_17, (Matrix)secondMoments2_173_17, (Ellipse)e1_173_17, (Ellipse)e2_173_17, 0.519941f);
        Matrix matrix45 = new Matrix((double[][])new double[][]{{0.001362f, -7.74E-4f}, {-7.74E-4f, 0.001346f}});
        Matrix matrix46 = new Matrix((double[][])new double[][]{{4.36E-4f, -3.19E-4f}, {-3.19E-4f, 7.64E-4f}});
        Ellipse ellipse45 = EllipseUtilities.ellipseFromCovariance((float)314.6f, (float)318.23f, (Matrix)secondMoments1_293_17.inverse(), (float)1.0f);
        Ellipse ellipse46 = EllipseUtilities.ellipseFromCovariance((float)312.59656f, (float)318.6021f, (Matrix)secondMoments2_293_17.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_293_17, (Matrix)secondMoments2_293_17, (Ellipse)e1_293_17, (Ellipse)e2_293_17, 0.431624f);
        Matrix matrix47 = new Matrix((double[][])new double[][]{{0.001362f, -7.74E-4f}, {-7.74E-4f, 0.001346f}});
        Matrix matrix48 = new Matrix((double[][])new double[][]{{3.31E-4f, 2.12E-4f}, {2.12E-4f, 8.42E-4f}});
        Ellipse ellipse47 = EllipseUtilities.ellipseFromCovariance((float)314.6f, (float)318.23f, (Matrix)secondMoments1_295_17.inverse(), (float)1.0f);
        Ellipse ellipse48 = EllipseUtilities.ellipseFromCovariance((float)301.9434f, (float)319.2953f, (Matrix)secondMoments2_295_17.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_295_17, (Matrix)secondMoments2_295_17, (Ellipse)e1_295_17, (Ellipse)e2_295_17, 0.373724f);
        Matrix matrix49 = new Matrix((double[][])new double[][]{{0.001362f, -7.74E-4f}, {-7.74E-4f, 0.001346f}});
        Matrix matrix50 = new Matrix((double[][])new double[][]{{2.06E-4f, 1.05E-4f}, {1.05E-4f, 5.43E-4f}});
        Ellipse ellipse49 = EllipseUtilities.ellipseFromCovariance((float)314.6f, (float)318.23f, (Matrix)secondMoments1_580_17.inverse(), (float)1.0f);
        Ellipse ellipse50 = EllipseUtilities.ellipseFromCovariance((float)302.97067f, (float)318.7307f, (Matrix)secondMoments2_580_17.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_580_17, (Matrix)secondMoments2_580_17, (Ellipse)e1_580_17, (Ellipse)e2_580_17, 0.283702f);
        Matrix matrix51 = new Matrix((double[][])new double[][]{{0.001362f, -7.74E-4f}, {-7.74E-4f, 0.001346f}});
        Matrix matrix52 = new Matrix((double[][])new double[][]{{1.89E-4f, -8.6E-5f}, {-8.6E-5f, 3.76E-4f}});
        Ellipse ellipse51 = EllipseUtilities.ellipseFromCovariance((float)314.6f, (float)318.23f, (Matrix)secondMoments1_682_17.inverse(), (float)1.0f);
        Ellipse ellipse52 = EllipseUtilities.ellipseFromCovariance((float)309.48666f, (float)319.42038f, (Matrix)secondMoments2_682_17.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_682_17, (Matrix)secondMoments2_682_17, (Ellipse)e1_682_17, (Ellipse)e2_682_17, 0.22846f);
        Matrix matrix53 = new Matrix((double[][])new double[][]{{0.001362f, -7.74E-4f}, {-7.74E-4f, 0.001346f}});
        Matrix matrix54 = new Matrix((double[][])new double[][]{{1.49E-4f, -3.3E-5f}, {-3.3E-5f, 3.29E-4f}});
        Ellipse ellipse53 = EllipseUtilities.ellipseFromCovariance((float)314.6f, (float)318.23f, (Matrix)secondMoments1_789_17.inverse(), (float)1.0f);
        Ellipse ellipse54 = EllipseUtilities.ellipseFromCovariance((float)307.8192f, (float)318.7265f, (Matrix)secondMoments2_789_17.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_789_17, (Matrix)secondMoments2_789_17, (Ellipse)e1_789_17, (Ellipse)e2_789_17, 0.196657f);
        Matrix matrix55 = new Matrix((double[][])new double[][]{{0.001362f, -7.74E-4f}, {-7.74E-4f, 0.001346f}});
        Matrix matrix56 = new Matrix((double[][])new double[][]{{9.2E-5f, -1.8E-5f}, {-1.8E-5f, 1.59E-4f}});
        Ellipse ellipse55 = EllipseUtilities.ellipseFromCovariance((float)314.6f, (float)318.23f, (Matrix)secondMoments1_1030_17.inverse(), (float)1.0f);
        Ellipse ellipse56 = EllipseUtilities.ellipseFromCovariance((float)307.42914f, (float)320.5162f, (Matrix)secondMoments2_1030_17.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_1030_17, (Matrix)secondMoments2_1030_17, (Ellipse)e1_1030_17, (Ellipse)e2_1030_17, 0.10904f);
        Matrix matrix57 = new Matrix((double[][])new double[][]{{0.001362f, -7.74E-4f}, {-7.74E-4f, 0.001346f}});
        Matrix matrix58 = new Matrix((double[][])new double[][]{{7.8E-5f, -1.9E-5f}, {-1.9E-5f, 9.7E-5f}});
        Ellipse ellipse57 = EllipseUtilities.ellipseFromCovariance((float)314.6f, (float)318.23f, (Matrix)secondMoments1_1156_17.inverse(), (float)1.0f);
        Ellipse ellipse58 = EllipseUtilities.ellipseFromCovariance((float)307.77188f, (float)324.11685f, (Matrix)secondMoments2_1156_17.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_1156_17, (Matrix)secondMoments2_1156_17, (Ellipse)e1_1156_17, (Ellipse)e2_1156_17, 0.077324f);
        Matrix matrix59 = new Matrix((double[][])new double[][]{{0.001362f, -7.74E-4f}, {-7.74E-4f, 0.001346f}});
        Matrix matrix60 = new Matrix((double[][])new double[][]{{6.9E-5f, -7.0E-6f}, {-7.0E-6f, 7.0E-5f}});
        Ellipse ellipse59 = EllipseUtilities.ellipseFromCovariance((float)314.6f, (float)318.23f, (Matrix)secondMoments1_1207_17.inverse(), (float)1.0f);
        Ellipse ellipse60 = EllipseUtilities.ellipseFromCovariance((float)305.4102f, (float)323.89493f, (Matrix)secondMoments2_1207_17.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_1207_17, (Matrix)secondMoments2_1207_17, (Ellipse)e1_1207_17, (Ellipse)e2_1207_17, 0.060606f);
        Matrix matrix61 = new Matrix((double[][])new double[][]{{0.001609f, -7.68E-4f}, {-7.68E-4f, 0.001134f}});
        Matrix matrix62 = new Matrix((double[][])new double[][]{{8.44E-4f, -4.44E-4f}, {-4.44E-4f, 9.33E-4f}});
        Ellipse ellipse61 = EllipseUtilities.ellipseFromCovariance((float)122.21f, (float)323.07f, (Matrix)secondMoments1_89_18.inverse(), (float)1.0f);
        Ellipse ellipse62 = EllipseUtilities.ellipseFromCovariance((float)121.24881f, (float)322.86533f, (Matrix)secondMoments2_89_18.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_89_18, (Matrix)secondMoments2_89_18, (Ellipse)e1_89_18, (Ellipse)e2_89_18, 0.691817f);
        Matrix matrix63 = new Matrix((double[][])new double[][]{{0.001609f, -7.68E-4f}, {-7.68E-4f, 0.001134f}});
        Matrix matrix64 = new Matrix((double[][])new double[][]{{9.38E-4f, 8.3E-5f}, {8.3E-5f, 7.07E-4f}});
        Ellipse ellipse63 = EllipseUtilities.ellipseFromCovariance((float)122.21f, (float)323.07f, (Matrix)secondMoments1_90_18.inverse(), (float)1.0f);
        Ellipse ellipse64 = EllipseUtilities.ellipseFromCovariance((float)125.11152f, (float)334.00427f, (Matrix)secondMoments2_90_18.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_90_18, (Matrix)secondMoments2_90_18, (Ellipse)e1_90_18, (Ellipse)e2_90_18, 0.528642f);
        Matrix matrix65 = new Matrix((double[][])new double[][]{{0.001609f, -7.68E-4f}, {-7.68E-4f, 0.001134f}});
        Matrix matrix66 = new Matrix((double[][])new double[][]{{8.14E-4f, -3.93E-4f}, {-3.93E-4f, 7.48E-4f}});
        Ellipse ellipse65 = EllipseUtilities.ellipseFromCovariance((float)122.21f, (float)323.07f, (Matrix)secondMoments1_180_18.inverse(), (float)1.0f);
        Ellipse ellipse66 = EllipseUtilities.ellipseFromCovariance((float)121.6346f, (float)323.11783f, (Matrix)secondMoments2_180_18.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_180_18, (Matrix)secondMoments2_180_18, (Ellipse)e1_180_18, (Ellipse)e2_180_18, 0.605201f);
        Matrix matrix67 = new Matrix((double[][])new double[][]{{0.001609f, -7.68E-4f}, {-7.68E-4f, 0.001134f}});
        Matrix matrix68 = new Matrix((double[][])new double[][]{{5.79E-4f, 1.29E-4f}, {1.29E-4f, 7.83E-4f}});
        Ellipse ellipse67 = EllipseUtilities.ellipseFromCovariance((float)122.21f, (float)323.07f, (Matrix)secondMoments1_181_18.inverse(), (float)1.0f);
        Ellipse ellipse68 = EllipseUtilities.ellipseFromCovariance((float)124.29042f, (float)334.91824f, (Matrix)secondMoments2_181_18.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_181_18, (Matrix)secondMoments2_181_18, (Ellipse)e1_181_18, (Ellipse)e2_181_18, 0.439394f);
        Matrix matrix69 = new Matrix((double[][])new double[][]{{0.001609f, -7.68E-4f}, {-7.68E-4f, 0.001134f}});
        Matrix matrix70 = new Matrix((double[][])new double[][]{{4.34E-4f, -1.97E-4f}, {-1.97E-4f, 5.69E-4f}});
        Ellipse ellipse69 = EllipseUtilities.ellipseFromCovariance((float)122.21f, (float)323.07f, (Matrix)secondMoments1_451_18.inverse(), (float)1.0f);
        Ellipse ellipse70 = EllipseUtilities.ellipseFromCovariance((float)120.56259f, (float)323.77655f, (Matrix)secondMoments2_451_18.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_451_18, (Matrix)secondMoments2_451_18, (Ellipse)e1_451_18, (Ellipse)e2_451_18, 0.41104f);
        Matrix matrix71 = new Matrix((double[][])new double[][]{{0.001609f, -7.68E-4f}, {-7.68E-4f, 0.001134f}});
        Matrix matrix72 = new Matrix((double[][])new double[][]{{4.0E-4f, 7.0E-5f}, {7.0E-5f, 5.35E-4f}});
        Ellipse ellipse71 = EllipseUtilities.ellipseFromCovariance((float)122.21f, (float)323.07f, (Matrix)secondMoments1_452_18.inverse(), (float)1.0f);
        Ellipse ellipse72 = EllipseUtilities.ellipseFromCovariance((float)123.132286f, (float)334.05136f, (Matrix)secondMoments2_452_18.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_452_18, (Matrix)secondMoments2_452_18, (Ellipse)e1_452_18, (Ellipse)e2_452_18, 0.370512f);
        Matrix matrix73 = new Matrix((double[][])new double[][]{{0.001609f, -7.68E-4f}, {-7.68E-4f, 0.001134f}});
        Matrix matrix74 = new Matrix((double[][])new double[][]{{2.81E-4f, 2.9E-5f}, {2.9E-5f, 3.57E-4f}});
        Ellipse ellipse73 = EllipseUtilities.ellipseFromCovariance((float)122.21f, (float)323.07f, (Matrix)secondMoments1_689_18.inverse(), (float)1.0f);
        Ellipse ellipse74 = EllipseUtilities.ellipseFromCovariance((float)122.57989f, (float)333.18814f, (Matrix)secondMoments2_689_18.inverse(), (float)1.0f);
        IPDRepeatability.doTest((Matrix)secondMoments1_689_18, (Matrix)secondMoments2_689_18, (Ellipse)e1_689_18, (Ellipse)e2_689_18, 0.282375f);
    }

    private static void doTest(Matrix secondMoments1, Matrix secondMoments2, Ellipse e1, Ellipse e2, float f) {
        System.out.println(e1 + " vs " + e2);
        IPDRepeatability dummy = new IPDRepeatability();
        double overlap = dummy.calculateOverlapPercentageOxford(secondMoments1, secondMoments2, e1, e2, 4.0);
        System.out.format("\tGot overlap: %4.2f, expecting %4.2f\n", overlap, Float.valueOf(f));
        if (Math.abs((double)f - overlap) > 0.02) {
            System.err.println("THERE WAS AN ERROR WITH THE ABOVE ELLIPSE!!");
        }
    }

    static {
        BasicConfigurator.configure();
        logger.setLevel(Level.INFO);
    }

    public static class ScoredPair<B extends Comparable<B>, T extends Pair<B>>
    implements Comparable<ScoredPair<B, T>> {
        private T pair;
        private double score;

        ScoredPair(T pair, double score) {
            this.pair = pair;
            this.score = score;
        }

        @Override
        public int compareTo(ScoredPair<B, T> that) {
            int diff = Double.compare(this.score, that.score);
            if (diff != 0) {
                return -diff;
            }
            diff = ((Comparable)this.pair.firstObject()).compareTo(that.pair.firstObject());
            if (diff == 0) {
                return ((Comparable)this.pair.secondObject()).compareTo(that.pair.secondObject());
            }
            return diff;
        }
    }
}

