/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.affine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.Image;
import org.openimaj.image.processing.transform.AffineParams;
import org.openimaj.image.processing.transform.AffineSimulation;
import org.openimaj.math.geometry.point.ScaleSpacePoint;

@Reference(type=ReferenceType.Article, author={"Morel, Jean-Michel", "Yu, Guoshen"}, title="{ASIFT: A New Framework for Fully Affine Invariant Image Comparison}", year="2009", journal="SIAM J. Img. Sci.", publisher="Society for Industrial and Applied Mathematics")
public abstract class AffineSimulationExtractor<Q extends List<T>, T extends ScaleSpacePoint, I extends Image<P, I>, P> {
    protected static final float PI = (float)Math.PI;
    protected float BorderFact = 6.0f * (float)Math.sqrt(2.0);
    public Q allInterestPoints;
    public Map<AffineParams, Q> mappedInterestPoints;
    public List<AffineParams> simulationOrder;

    protected abstract Q detectFeatures(I var1);

    protected abstract Q newList();

    public Q getFeatures() {
        return this.allInterestPoints;
    }

    public void detectFeatures(I image, int num_of_tilts) {
        if (num_of_tilts < 1) {
            throw new IllegalArgumentException("Number of tilts num_tilt should be equal or larger than 1.");
        }
        this.allInterestPoints = this.newList();
        this.mappedInterestPoints = new HashMap<AffineParams, Q>();
        this.simulationOrder = new ArrayList<AffineParams>();
        int num_rot_t2 = 10;
        float t_min = 1.0f;
        float t_k = (float)Math.sqrt(2.0);
        for (int tt = 1; tt <= num_of_tilts; ++tt) {
            float t = 1.0f * (float)Math.pow(t_k, tt - 1);
            AffineParams addedParams = null;
            if (t == 1.0f) {
                addedParams = new AffineParams(0.0f, t);
                Q keypoints = this.detectFeatures(image.clone());
                this.mappedInterestPoints.put(addedParams, keypoints);
                this.allInterestPoints.addAll(keypoints);
                this.simulationOrder.add(addedParams);
                continue;
            }
            int num_rots = Math.round(10.0f * t / 2.0f);
            if (num_rots % 2 == 1) {
                ++num_rots;
            }
            float delta_theta = (float)Math.PI / (float)(num_rots /= 2);
            for (int rr = 1; rr <= num_rots; ++rr) {
                float theta = delta_theta * (float)(rr - 1);
                Image image_tmp1 = AffineSimulation.transformImage(image, (float)theta, (float)t);
                Q keypoints = this.detectFeatures(image_tmp1);
                this.filterEdgesTransformed(keypoints, theta, image, 1.0f / t);
                AffineSimulation.transformToOriginal(keypoints, image, (float)theta, (float)t);
                addedParams = new AffineParams(theta, t);
                this.mappedInterestPoints.put(addedParams, keypoints);
                this.allInterestPoints.addAll(keypoints);
                this.simulationOrder.add(addedParams);
            }
        }
    }

    public Q detectFeatures(I image, AffineParams params) {
        return this.detectFeatures(image, params.theta, params.tilt);
    }

    public Q detectFeatures(I image, float theta, float tilt) {
        Image image_tmp1 = AffineSimulation.transformImage(image, (float)theta, (float)tilt);
        Q keypoints = this.detectFeatures(image_tmp1);
        this.filterEdgesTransformed(keypoints, theta, image, 1.0f / tilt);
        AffineSimulation.transformToOriginal(keypoints, image, (float)theta, (float)tilt);
        return keypoints;
    }

    protected void filterEdgesTransformed(Q keypoints, float theta, I image, float t2) {
        ArrayList keys_to_remove = new ArrayList();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        for (int cc = 0; cc < keypoints.size(); ++cc) {
            float y3;
            float x2;
            float y4;
            float x4;
            float x3;
            float y2;
            float y1;
            float x1;
            float x0 = ((ScaleSpacePoint)keypoints.get(cc)).getX();
            float y0 = ((ScaleSpacePoint)keypoints.get(cc)).getY();
            float scale1 = ((ScaleSpacePoint)keypoints.get(cc)).getScale();
            float sin_theta = (float)Math.sin(theta);
            float cos_theta1 = (float)Math.cos(theta);
            if ((double)theta <= 1.5707963705062866) {
                x1 = (float)imageHeight * sin_theta;
                y1 = 0.0f;
                y2 = (float)imageWidth * sin_theta;
                x3 = (float)imageWidth * cos_theta1;
                x4 = 0.0f;
                y4 = (float)imageHeight * cos_theta1;
                x2 = x1 + x3;
                y3 = y2 + y4;
                y1 = y3 - y1;
                y2 = y3 - y2;
                y4 = y3 - y4;
                y3 = 0.0f;
            } else {
                y1 = (float)(-imageHeight) * cos_theta1;
                x2 = (float)imageHeight * sin_theta;
                x3 = 0.0f;
                y3 = (float)imageWidth * sin_theta;
                x4 = (float)(-imageWidth) * cos_theta1;
                y4 = 0.0f;
                x1 = x2 + x4;
                y2 = y1 + y3;
                y1 = y2 - y1;
                y3 = y2 - y3;
                y4 = y2 - y4;
                y2 = 0.0f;
            }
            float d1 = (float)((double)Math.abs((x2 - x1) * ((y1 *= t2) - y0) - (x1 - x0) * ((y2 *= t2) - y1)) / Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)));
            float d2 = (float)((double)Math.abs((x3 - x2) * (y2 - y0) - (x2 - x0) * ((y3 *= t2) - y2)) / Math.sqrt((x3 - x2) * (x3 - x2) + (y3 - y2) * (y3 - y2)));
            float d3 = (float)((double)Math.abs((x4 - x3) * (y3 - y0) - (x3 - x0) * ((y4 *= t2) - y3)) / Math.sqrt((x4 - x3) * (x4 - x3) + (y4 - y3) * (y4 - y3)));
            float d4 = (float)((double)Math.abs((x1 - x4) * (y4 - y0) - (x4 - x0) * (y1 - y4)) / Math.sqrt((x1 - x4) * (x1 - x4) + (y1 - y4) * (y1 - y4)));
            float BorderTh = this.BorderFact * scale1;
            if (!(d1 < BorderTh || d2 < BorderTh || d3 < BorderTh) && !(d4 < BorderTh)) continue;
            keys_to_remove.add(keypoints.get(cc));
        }
        keypoints.removeAll(keys_to_remove);
    }

    public Map<AffineParams, Q> getKeypointsMap() {
        return this.mappedInterestPoints;
    }
}

