/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.matcher.quantised;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.feature.local.matcher.LocalFeatureMatcher;
import org.openimaj.feature.local.quantised.QuantisedLocalFeature;
import org.openimaj.util.pair.Pair;

public class BasicQuantisedKeypointMatcher<T extends QuantisedLocalFeature<?>>
implements LocalFeatureMatcher<T> {
    protected TIntObjectHashMap<List<T>> modelKeypoints;
    protected List<Pair<T>> matches;
    protected boolean allowMultiple;

    public BasicQuantisedKeypointMatcher(boolean allowMultiple) {
        this.allowMultiple = allowMultiple;
    }

    @Override
    public List<Pair<T>> getMatches() {
        return this.matches;
    }

    @Override
    public boolean findMatches(List<T> keys1) {
        this.matches = new ArrayList<Pair<T>>();
        for (QuantisedLocalFeature k : keys1) {
            if (!this.modelKeypoints.contains(k.id) || !this.allowMultiple && ((List)this.modelKeypoints.get(k.id)).size() != 1) continue;
            for (QuantisedLocalFeature match : (List)this.modelKeypoints.get(k.id)) {
                this.matches.add(new Pair((Object)k, (Object)match));
            }
        }
        return true;
    }

    @Override
    public void setModelFeatures(List<T> modelkeys) {
        this.modelKeypoints = new TIntObjectHashMap();
        for (QuantisedLocalFeature k : modelkeys) {
            if (!this.modelKeypoints.contains(k.id)) {
                this.modelKeypoints.put(k.id, new ArrayList());
            }
            ((List)this.modelKeypoints.get(k.id)).add(k);
        }
    }
}

