/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.matcher;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.feature.DoubleFVComparison;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.matcher.LocalFeatureMatcher;
import org.openimaj.util.pair.Pair;

public class BasicTwoWayMatcher<T extends LocalFeature<?, ?>>
implements LocalFeatureMatcher<T> {
    protected List<T> modelKeypoints;
    protected List<Pair<T>> matches;

    @Override
    public void setModelFeatures(List<T> modelkeys) {
        this.modelKeypoints = modelkeys;
    }

    protected T findMatch(T query, List<T> features) {
        double distsq = Double.MAX_VALUE;
        LocalFeature minkey = null;
        for (LocalFeature target : features) {
            double dsq = target.getFeatureVector().asDoubleFV().compare(query.getFeatureVector().asDoubleFV(), DoubleFVComparison.SUM_SQUARE);
            if (!(dsq < distsq)) continue;
            distsq = dsq;
            minkey = target;
        }
        return (T)minkey;
    }

    @Override
    public boolean findMatches(List<T> queryfeatures) {
        this.matches = new ArrayList<Pair<T>>();
        TObjectIntHashMap targets = new TObjectIntHashMap();
        for (LocalFeature query : queryfeatures) {
            LocalFeature querytarget;
            LocalFeature modeltarget = this.findMatch(query, this.modelKeypoints);
            if (modeltarget == null || (querytarget = this.findMatch(modeltarget, queryfeatures)) != query) continue;
            this.matches.add(new Pair((Object)query, (Object)modeltarget));
            targets.adjustOrPutValue((Object)modeltarget, 1, 1);
        }
        final ArrayList matchesToRemove = new ArrayList();
        targets.forEachEntry(new TObjectIntProcedure<T>(){

            public boolean execute(T a, int b) {
                if (b > 1) {
                    for (Pair p : BasicTwoWayMatcher.this.matches) {
                        if (p.secondObject() != a) continue;
                        matchesToRemove.add(p);
                    }
                }
                return true;
            }
        });
        this.matches.removeAll(matchesToRemove);
        return this.matches.size() > 0;
    }

    @Override
    public List<Pair<T>> getMatches() {
        return this.matches;
    }
}

