/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.text.extraction.swt;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.pixel.PixelSet;
import org.openimaj.image.text.extraction.swt.Candidate;
import org.openimaj.image.text.extraction.swt.LineCandidate;
import org.openimaj.image.text.extraction.swt.SWTTextDetector;
import org.openimaj.image.text.extraction.swt.WordCandidate;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;

public class LetterCandidate
extends Candidate {
    protected WordCandidate word;
    protected LineCandidate line;
    protected PixelSet cc;
    protected float averageBrightness;
    protected Pixel centroid;
    protected float medianStrokeWidth;

    protected LetterCandidate(PixelSet cc, float medianStrokeWidth, FImage image) {
        this.cc = cc;
        this.medianStrokeWidth = medianStrokeWidth;
        this.regularBoundingBox = cc.calculateRegularBoundingBox();
        this.centroid = cc.calculateCentroidPixel();
        this.averageBrightness = 0.0f;
        for (Pixel p : cc.pixels) {
            this.averageBrightness += image.pixels[p.y][p.x];
        }
        this.averageBrightness /= (float)cc.pixels.size();
    }

    public static Rectangle computeBounds(List<LetterCandidate> letters) {
        float minx = Float.MAX_VALUE;
        float miny = Float.MAX_VALUE;
        float maxx = 0.0f;
        float maxy = 0.0f;
        for (LetterCandidate letter : letters) {
            Rectangle r = letter.cc.calculateRegularBoundingBox();
            if (r.x < minx) {
                minx = r.x;
            }
            if (r.y < miny) {
                miny = r.y;
            }
            if (r.x + r.width > maxx) {
                maxx = r.x + r.width;
            }
            if (!(r.y + r.height > maxy)) continue;
            maxy = r.y + r.height;
        }
        return new Rectangle(minx, miny, maxx - minx, maxy - miny);
    }

    public String toString() {
        return this.regularBoundingBox.toString();
    }

    protected static List<LetterCandidate> findLetters(List<ConnectedComponent> components, FImage swt, FImage image, SWTTextDetector.Options options) {
        ArrayList<LetterCandidate> output = new ArrayList<LetterCandidate>();
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (ConnectedComponent cc : components) {
            float diameter;
            if (cc.pixels.size() < options.minArea) continue;
            LetterCandidate.computeStats(stats, (PixelSet)cc, swt);
            double mean = stats.getMean();
            double variance = stats.getVariance();
            double median = stats.getPercentile(50.0);
            if (variance > options.letterVarianceMean * mean) continue;
            Rectangle bb = cc.calculateRegularBoundingBox();
            double aspect = Math.max(bb.width, bb.height) / Math.min(bb.width, bb.height);
            if (aspect > options.maxAspectRatio || (double)(diameter = Math.max(bb.width, bb.height)) / median > options.maxDiameterStrokeRatio) continue;
            int overlapping = 0;
            for (ConnectedComponent cc2 : components) {
                Rectangle bb2;
                if (cc2 == cc || !((bb2 = cc2.calculateRegularBoundingBox()).intersectionArea((Shape)bb) > 0.0)) continue;
                ++overlapping;
            }
            if (overlapping > options.maxNumOverlappingBoxes || bb.height < options.minHeight || bb.height > options.maxHeight) continue;
            output.add(new LetterCandidate((PixelSet)cc, (float)median, image));
        }
        return output;
    }

    private static void computeStats(DescriptiveStatistics stats, PixelSet cc, FImage swt) {
        stats.clear();
        for (Pixel p : cc.pixels) {
            stats.addValue((double)swt.pixels[p.y][p.x]);
        }
    }
}

