/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.pixel.statistics;

import Jama.Matrix;
import java.util.Arrays;
import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.stat.descriptive.MultivariateSummaryStatistics;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.sampling.FLineSampler;
import org.openimaj.image.pixel.statistics.PixelProfileModel;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.util.FloatArrayStatsUtils;
import org.openimaj.util.array.ArrayUtils;

public class FStatisticalPixelProfileModel
implements PixelProfileModel<FImage> {
    private MultivariateSummaryStatistics statistics;
    private int nsamples;
    private FLineSampler sampler;
    private double[] mean;
    private Matrix invCovar;

    public FStatisticalPixelProfileModel(int nsamples, FLineSampler sampler) {
        this.nsamples = nsamples;
        this.statistics = new MultivariateSummaryStatistics(nsamples, true);
        this.sampler = sampler;
    }

    private float[] normaliseSamples(float[] samples) {
        float sum = FloatArrayStatsUtils.sum((float[])samples);
        int i = 0;
        while (i < samples.length) {
            int n = i++;
            samples[n] = samples[n] / sum;
        }
        return samples;
    }

    @Override
    public void updateModel(FImage image, Line2d line) {
        float[] samples = this.normaliseSamples(this.sampler.extractSamples(line, image, this.nsamples));
        try {
            this.statistics.addValue(ArrayUtils.convertToDouble((float[])samples));
        }
        catch (DimensionMismatchException e) {
            throw new RuntimeException(e);
        }
        this.invCovar = null;
        this.mean = null;
    }

    public double[] getMean() {
        if (this.mean == null) {
            this.mean = this.statistics.getMean();
            this.invCovar = new Matrix(this.statistics.getCovariance().getData()).inverse();
        }
        return this.mean;
    }

    public Matrix getCovariance() {
        if (this.mean == null) {
            this.mean = this.statistics.getMean();
            this.invCovar = new Matrix(this.statistics.getCovariance().getData()).inverse();
        }
        return new Matrix(this.statistics.getCovariance().getData());
    }

    public Matrix getInverseCovariance() {
        if (this.mean == null) {
            this.mean = this.statistics.getMean();
            this.invCovar = new Matrix(this.statistics.getCovariance().getData()).inverse();
        }
        return this.invCovar;
    }

    public float computeMahalanobis(float[] vector) {
        if (this.mean == null) {
            this.mean = this.statistics.getMean();
            try {
                this.invCovar = new Matrix(this.statistics.getCovariance().getData()).inverse();
            }
            catch (RuntimeException e) {
                this.invCovar = Matrix.identity((int)this.nsamples, (int)this.nsamples);
            }
        }
        double[] meanCentered = new double[this.mean.length];
        for (int i = 0; i < this.mean.length; ++i) {
            meanCentered[i] = (double)vector[i] - this.mean[i];
        }
        Matrix mct = new Matrix((double[][])new double[][]{meanCentered});
        Matrix mc = mct.transpose();
        Matrix dist = mct.times(this.invCovar).times(mc);
        return (float)dist.get(0, 0);
    }

    public float computeMahalanobis(FImage image, Line2d line) {
        float[] samples = this.normaliseSamples(this.sampler.extractSamples(line, image, this.nsamples));
        return this.computeMahalanobis(samples);
    }

    public float[] computeMahalanobisWindowed(FImage image, Line2d line, int numSamples) {
        float[] samples = this.sampler.extractSamples(line, image, numSamples);
        return this.computeMahalanobisWindowed(samples);
    }

    @Override
    public Point2d computeNewBest(FImage image, Line2d line, int numSamples) {
        int minIdx;
        int offset;
        float[] resp = this.computeMahalanobisWindowed(image, line, numSamples);
        if (resp[offset = (numSamples - this.nsamples) / 2] == resp[minIdx = ArrayUtils.minIndex((float[])resp)]) {
            return line.calculateCentroid();
        }
        line = this.sampler.getSampleLine(line, image, numSamples);
        float x = line.begin.getX();
        float y = line.begin.getY();
        float dxStep = (line.end.getX() - x) / (float)(numSamples - 1);
        float dyStep = (line.end.getY() - y) / (float)(numSamples - 1);
        return new Point2dImpl(x + (float)(minIdx + offset) * dxStep, y + (float)(minIdx + offset) * dyStep);
    }

    @Override
    public float computeMovementDistance(FImage image, Line2d line, int numSamples, Point2d pt) {
        Line2d sampleLine = this.sampler.getSampleLine(line, image, numSamples);
        return (float)(2.0 * Line2d.distance((Point2d)sampleLine.calculateCentroid(), (Point2d)pt) / sampleLine.calculateLength());
    }

    public float[] computeMahalanobisWindowed(float[] vector) {
        int maxShift = vector.length - this.nsamples + 1;
        float[] responses = new float[maxShift];
        float[] samples = new float[this.nsamples];
        for (int i = 0; i < maxShift; ++i) {
            System.arraycopy(vector, i, samples, 0, this.nsamples);
            samples = this.normaliseSamples(samples);
            responses[i] = this.computeMahalanobis(samples);
        }
        return responses;
    }

    public String toString() {
        return "\nPixelProfileModel[\n\tcount = " + this.statistics.getN() + "\n\tmean = " + Arrays.toString(this.statistics.getMean()) + "\n\tcovar = " + this.statistics.getCovariance() + "\n]";
    }

    public int getNumberSamples() {
        return this.nsamples;
    }

    public FLineSampler getSampler() {
        return this.sampler;
    }

    @Override
    public float computeCost(FImage image, Line2d line) {
        return this.computeMahalanobis(image, line);
    }
}

