/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.pixel.statistics;

import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.procedure.TIntIntProcedure;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.pixel.statistics.AbstractPixelStatisticsModel;
import org.openimaj.image.pixel.statistics.HashMax;

public class BasicDescriptiveStatisticsModel
extends AbstractPixelStatisticsModel {
    private static final long serialVersionUID = 1L;
    public double[] mean;
    public double[] mode;
    public double[] median;
    public double[] range;
    public double[] variance;

    public BasicDescriptiveStatisticsModel(int ndims) {
        super(ndims);
        this.mean = new double[ndims];
        this.mode = new double[ndims];
        this.median = new double[ndims];
        this.range = new double[ndims];
        this.variance = new double[ndims];
    }

    @Override
    public void estimateModel(MBFImage ... images) {
        for (int i = 0; i < this.ndims; ++i) {
            this.mean[i] = 0.0;
            TFloatArrayList values = new TFloatArrayList();
            TIntIntHashMap freqs = new TIntIntHashMap();
            int count = 0;
            for (MBFImage im : images) {
                FImage band = (FImage)im.getBand(i);
                for (int r = 0; r < band.height; ++r) {
                    for (int c = 0; c < band.width; ++c) {
                        float val = band.pixels[r][c];
                        int n = i;
                        this.mean[n] = this.mean[n] + (double)val;
                        values.add(val);
                        freqs.adjustOrPutValue(Math.round(val * 255.0f), 1, 1);
                        ++count;
                    }
                }
            }
            int n = i;
            this.mean[n] = this.mean[n] / (double)count;
            values.sort();
            int idx = values.size() / 2;
            this.median[i] = values.size() % 2 == 0 ? (double)(values.get(idx) + values.get(idx - 1)) / 2.0 : (double)values.get(idx);
            HashMax hm = new HashMax();
            freqs.forEachEntry((TIntIntProcedure)hm);
            this.mode[i] = (double)hm.idx / 255.0;
            this.range[i] = values.get(values.size() - 1) - values.get(0);
            this.variance[i] = 0.0;
            for (int j = 0; j < values.size(); ++j) {
                int n2 = i;
                this.variance[n2] = this.variance[n2] + ((double)values.get(j) - this.mean[i]) * ((double)values.get(j) - this.mean[i]);
            }
            this.variance[i] = Math.sqrt(this.variance[i] / (double)values.size());
        }
    }

    public String toString() {
        int i;
        String desc = "";
        for (i = 0; i < this.ndims; ++i) {
            desc = desc + String.format("%2.2f, ", this.mean[i]);
        }
        for (i = 0; i < this.ndims; ++i) {
            desc = desc + String.format("%2.2f, ", this.mode[i]);
        }
        for (i = 0; i < this.ndims; ++i) {
            desc = desc + String.format("%2.2f, ", this.median[i]);
        }
        for (i = 0; i < this.ndims; ++i) {
            desc = desc + String.format("%2.2f, ", this.range[i]);
        }
        for (i = 0; i < this.ndims; ++i) {
            desc = desc + String.format("%2.2f, ", this.variance[i]);
        }
        return desc.substring(0, desc.length() - 2);
    }
}

