/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.model.patch;

import org.openimaj.feature.DoubleFVComparison;
import org.openimaj.feature.MultidimensionalDoubleFV;
import org.openimaj.image.MBFImage;
import org.openimaj.image.model.patch.MBFPatchClassificationModel;
import org.openimaj.image.pixel.statistics.HistogramModel;

public class HistogramPatchModel
extends MBFPatchClassificationModel {
    private static final long serialVersionUID = 1L;
    public HistogramModel model;
    protected DoubleFVComparison compare = DoubleFVComparison.BHATTACHARYYA;

    public HistogramPatchModel(int patchWidth, int patchHeight, int ... nbins) {
        super(nbins.length, patchWidth, patchHeight);
        this.model = new HistogramModel(nbins);
    }

    public HistogramPatchModel(int patchWidth, int patchHeight, DoubleFVComparison compare, int ... nbins) {
        this(patchWidth, patchHeight, nbins);
        this.compare = compare;
        this.model = new HistogramModel(nbins);
    }

    public DoubleFVComparison getComparisonMeasure() {
        return this.compare;
    }

    public void setComparisonMeasure(DoubleFVComparison compare) {
        this.compare = compare;
    }

    @Override
    public float classifyPatch(MBFImage patch) {
        HistogramModel h = new HistogramModel(this.model.histogram.nbins);
        h.estimateModel(patch);
        return (float)this.model.histogram.compare((MultidimensionalDoubleFV)h.histogram, this.compare);
    }

    @Override
    public HistogramPatchModel clone() {
        HistogramPatchModel newmodel = new HistogramPatchModel(this.patchWidth, this.patchHeight, this.model.histogram.nbins);
        newmodel.model = this.model.clone();
        return newmodel;
    }

    public void learnModel(MBFImage ... images) {
        this.model.estimateModel(images);
    }
}

