/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.mask.AbstractMaskedObject;

@Reference(type=ReferenceType.Inproceedings, author={"Jose San Pedro", "Stefan Siersdorfer"}, title="Ranking and Classifying Attractiveness of Photos in Folksonomies", year="2009", booktitle="18th International World Wide Web Conference", pages={"771", "", "771"}, url="http://www2009.eprints.org/78/", month="April")
public class Saturation
extends AbstractMaskedObject<FImage>
implements ImageAnalyser<MBFImage>,
FeatureVectorProvider<DoubleFV> {
    double saturation;

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.saturation});
    }

    public void analyseImage(MBFImage image) {
        FImage R = (FImage)image.getBand(0);
        FImage G = (FImage)image.getBand(1);
        FImage B = (FImage)image.getBand(2);
        int N = 0;
        double sat = 0.0;
        if (this.mask != null) {
            for (int y = 0; y < R.height; ++y) {
                for (int x = 0; x < R.width; ++x) {
                    if (((FImage)this.mask).pixels[y][x] != 1.0f) continue;
                    float min = Math.min(Math.min(R.pixels[y][x], G.pixels[y][x]), B.pixels[y][x]);
                    float max = Math.max(Math.max(R.pixels[y][x], G.pixels[y][x]), B.pixels[y][x]);
                    sat += (double)(max - min);
                    ++N;
                }
            }
        } else {
            for (int y = 0; y < R.height; ++y) {
                for (int x = 0; x < R.width; ++x) {
                    float min = Math.min(Math.min(R.pixels[y][x], G.pixels[y][x]), B.pixels[y][x]);
                    float max = Math.max(Math.max(R.pixels[y][x], G.pixels[y][x]), B.pixels[y][x]);
                    sat += (double)(max - min);
                    ++N;
                }
            }
        }
        this.saturation = sat / (double)N;
    }

    public double getSaturation() {
        return this.saturation;
    }
}

