/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.colour.Transforms;
import org.openimaj.image.mask.AbstractMaskedObject;

@Reference(type=ReferenceType.Article, author={"Huang, Kai-Qi", "Wang, Qiao", "Wu, Zhen-Yang"}, title="Natural color image enhancement and evaluation algorithm based on human visual system", year="2006", journal="Comput. Vis. Image Underst.", pages={"52", "", "63"}, url="http://dx.doi.org/10.1016/j.cviu.2006.02.007", month="jul", number="1", publisher="Elsevier Science Inc.", volume="103")
public class Naturalness
extends AbstractMaskedObject<FImage>
implements ImageAnalyser<MBFImage>,
FeatureVectorProvider<DoubleFV> {
    private static final double grassLower = 0.2638888888888889;
    private static final double grassUpper = 0.375;
    private static final double skinLower = 0.06944444444444445;
    private static final double skinUpper = 0.19444444444444445;
    private static final double skyLower = 0.5138888888888888;
    private static final double skyUpper = 0.7222222222222222;
    private static final double satLower = 0.1;
    private static final double lightnessLower = 0.2;
    private static final double lightnessUpper = 0.8;
    private double skyMean = 0.0;
    private int skyN = 0;
    private double skinMean = 0.0;
    private int skinN = 0;
    private double grassMean = 0.0;
    private int grassN = 0;

    public Naturalness() {
    }

    public Naturalness(FImage mask) {
        super((Image)mask);
    }

    public void analyseImage(MBFImage image) {
        this.skyMean = 0.0;
        this.skyN = 0;
        this.skinMean = 0.0;
        this.skinN = 0;
        this.grassMean = 0.0;
        this.grassN = 0;
        MBFImage hsl = Transforms.RGB_TO_HSL((MBFImage)image);
        FImage H = (FImage)hsl.getBand(0);
        FImage S = (FImage)hsl.getBand(1);
        FImage L = (FImage)hsl.getBand(2);
        for (int y = 0; y < H.height; ++y) {
            for (int x = 0; x < H.width; ++x) {
                if (this.mask != null && ((FImage)this.mask).pixels[y][x] == 0.0f || !(0.2 <= (double)L.pixels[y][x]) || !((double)L.pixels[y][x] <= 0.8) || !((double)S.pixels[y][x] > 0.1)) continue;
                double hue = H.pixels[y][x];
                double sat = S.pixels[y][x];
                if (0.5138888888888888 <= hue && hue <= 0.7222222222222222) {
                    this.skyMean += sat;
                    ++this.skyN;
                }
                if (0.06944444444444445 <= hue && hue <= 0.19444444444444445) {
                    this.skinMean += sat;
                    ++this.skinN;
                }
                if (!(0.2638888888888889 <= hue) || !(hue <= 0.375)) continue;
                this.grassMean += sat;
                ++this.grassN;
            }
        }
        if (this.skyN != 0) {
            this.skyMean /= (double)this.skyN;
        }
        if (this.skinN != 0) {
            this.skinMean /= (double)this.skinN;
        }
        if (this.grassN != 0) {
            this.grassMean /= (double)this.grassN;
        }
    }

    public double getNaturalness() {
        double NSkin = Math.exp(-0.5 * Math.pow((this.skinMean - 0.76) / 0.52, 2.0));
        double NGrass = Math.exp(-0.5 * Math.pow((this.grassMean - 0.81) / 0.53, 2.0));
        double NSky = Math.exp(-0.5 * Math.pow((this.skyMean - 0.43) / 0.22, 2.0));
        double nPixels = this.skinN + this.grassN + this.skyN;
        if (nPixels == 0.0) {
            return 0.0;
        }
        double wSkin = (double)this.skinN / nPixels;
        double wGrass = (double)this.grassN / nPixels;
        double wSky = (double)this.skyN / nPixels;
        return wSkin * NSkin + wGrass * NGrass + wSky * NSky;
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.getNaturalness()});
    }
}

