/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.FloatFV;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.MultiBandImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.colour.ColourMap;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.processing.algorithm.FourierTransform;
import org.openimaj.image.processing.convolution.FourierConvolve;
import org.openimaj.image.processing.convolution.GaborFilters;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;

@Reference(type=ReferenceType.Article, author={"Oliva, Aude", "Torralba, Antonio"}, title="Modeling the Shape of the Scene: A Holistic Representation of the Spatial Envelope", year="2001", journal="Int. J. Comput. Vision", pages={"145", "", "175"}, url="http://dx.doi.org/10.1023/A:1011139631724", month="May", number="3", publisher="Kluwer Academic Publishers", volume="42", customData={"issn", "0920-5691", "numpages", "31", "doi", "10.1023/A:1011139631724", "acmid", "598462", "address", "Hingham, MA, USA", "keywords", "energy spectrum, natural images, principal components, scene recognition, spatial layout"})
public class Gist<IMAGE extends Image<?, IMAGE>>
implements ImageAnalyser<IMAGE> {
    public static final int[] DEFAULT_ORIENTATIONS_PER_SCALE = new int[]{8, 8, 8, 8};
    public static final int DEFAULT_NUMBER_OF_BLOCKS = 4;
    public static final int DEFAULT_PREFILTER_FC = 4;
    public static final int DEFAULT_BOUNDARY_EXTENSION = 32;
    public int numberOfBlocks = 4;
    public int prefilterFC = 4;
    public int boundaryExtension = 32;
    public static final int DEFAULT_SIZE = 128;
    protected FImage[] gaborFilters;
    protected FloatFV response;
    protected int[] orientationsPerScale;
    protected boolean fixedSize;
    protected int imageWidth;
    protected int imageHeight;

    public Gist() {
        this(true);
    }

    public Gist(boolean fixedSize) {
        this(128, 128, DEFAULT_ORIENTATIONS_PER_SCALE, fixedSize);
    }

    public Gist(int width, int height) {
        this(width, height, DEFAULT_ORIENTATIONS_PER_SCALE);
    }

    public Gist(int width, int height, int[] orientationsPerScale) {
        this(width, height, orientationsPerScale, true);
    }

    public Gist(int[] orientationsPerScale, boolean fixedSize) {
        this(128, 128, orientationsPerScale, fixedSize);
    }

    public Gist(int width, int height, int[] orientationsPerScale, boolean fixedSize) {
        this.fixedSize = fixedSize;
        this.orientationsPerScale = orientationsPerScale;
        this.imageWidth = width;
        this.imageHeight = height;
        if (fixedSize) {
            this.gaborFilters = GaborFilters.createGaborJets((int)(width + 2 * this.boundaryExtension), (int)(height + 2 * this.boundaryExtension), (int[])orientationsPerScale);
        }
    }

    public void analyseImage(IMAGE image) {
        if (this.fixedSize) {
            double sc = Math.max((double)this.imageWidth / (double)image.getWidth(), (double)this.imageHeight / (double)image.getHeight());
            Image resized = ((SinglebandImageProcessor.Processable)image).process((SinglebandImageProcessor)new ResizeProcessor((float)sc));
            Image roi = resized.extractCenter(this.imageWidth, this.imageHeight);
            this.extractGist(roi);
        } else {
            if (this.gaborFilters == null || this.gaborFilters[0].width != image.getWidth() || this.gaborFilters[0].height != image.getHeight()) {
                this.gaborFilters = GaborFilters.createGaborJets((int)(image.getWidth() + 2 * this.boundaryExtension), (int)(image.getHeight() + 2 * this.boundaryExtension), (int[])this.orientationsPerScale);
            }
            this.extractGist(image.clone());
        }
    }

    protected Gist(int[] orientationsPerScale) {
        this.orientationsPerScale = orientationsPerScale;
    }

    protected void extractGist(IMAGE image) {
        MBFImage mbfimage;
        if (image instanceof FImage) {
            mbfimage = new MBFImage(new FImage[]{(FImage)image});
        } else if (image instanceof MBFImage) {
            mbfimage = (MBFImage)image;
        } else {
            throw new UnsupportedOperationException("Image type " + image.getClass() + " is not currently supported. Please file a bug report.");
        }
        MBFImage o = this.prefilter((MBFImage)mbfimage.normalise());
        this.response = this.gistGabor(o);
    }

    private MBFImage prefilter(MBFImage img) {
        int w = 5;
        double s1 = (double)this.prefilterFC / Math.sqrt(Math.log(2.0));
        int sw = img.getWidth() + 10;
        int sh = img.getHeight() + 10;
        int n = Math.max(sw, sh);
        n += n % 2;
        img = (MBFImage)img.paddingSymmetric(5, 5, 5 + n - sw, 5 + n - sh);
        FImage filter = new FImage(2 * n, n);
        for (int j = 0; j < n; ++j) {
            int fy = j - n / 2;
            for (int i = 0; i < n * 2; i += 2) {
                int fx = i / 2 - n / 2;
                filter.pixels[j][i] = (float)Math.exp((double)(-(fx * fx + fy * fy)) / (s1 * s1));
            }
        }
        MBFImage output = new MBFImage();
        for (int b = 0; b < img.numBands(); ++b) {
            FImage band = (FImage)img.getBand(b);
            for (int y = 0; y < band.height; ++y) {
                for (int x = 0; x < band.width; ++x) {
                    band.pixels[y][x] = (float)Math.log(1.0f + band.pixels[y][x] * 255.0f);
                }
            }
            output.bands.add(band.subtractInplace(FourierConvolve.convolvePrepared((FImage)band, (FImage)filter, (boolean)true)));
        }
        FImage mean = output.flatten();
        FImage meansq = (FImage)mean.multiply((Image)mean);
        FImage localstd = FourierConvolve.convolvePrepared((FImage)meansq, (FImage)filter, (boolean)true);
        for (int b = 0; b < img.numBands(); ++b) {
            FImage band = (FImage)output.getBand(b);
            for (int y = 0; y < localstd.height; ++y) {
                for (int x = 0; x < localstd.width; ++x) {
                    band.pixels[y][x] = (float)((double)band.pixels[y][x] / (0.2 + Math.sqrt(Math.abs(localstd.pixels[y][x]))));
                }
            }
        }
        return (MBFImage)output.extractROI(5, 5, sw - 5 - 5, sh - 5 - 5);
    }

    private FloatFV gistGabor(MBFImage img) {
        int blocksPerFilter = this.computeNumberOfSamplingBlocks();
        int nFeaturesPerBand = this.gaborFilters.length * blocksPerFilter;
        int nFilters = this.gaborFilters.length;
        img = (MBFImage)img.paddingSymmetric(this.boundaryExtension, this.boundaryExtension, this.boundaryExtension, this.boundaryExtension);
        int cols = img.getCols();
        int rows = img.getRows();
        FloatFFT_2D fft = new FloatFFT_2D(rows, cols);
        float[][] workingSpace = new float[rows][cols * 2];
        FloatFV fv = new FloatFV(nFeaturesPerBand * img.numBands());
        for (int b = 0; b < img.numBands(); ++b) {
            FImage band = (FImage)img.bands.get(b);
            float[][] preparedImage = FourierTransform.prepareData((float[][])band.pixels, (int)rows, (int)cols, (boolean)true);
            fft.complexForward(preparedImage);
            for (int i = 0; i < nFilters; ++i) {
                FImage ig = this.performConv(fft, preparedImage, workingSpace, this.gaborFilters[i], rows, cols);
                ig = ig.extractROI(this.boundaryExtension, this.boundaryExtension, band.width - 2 * this.boundaryExtension, band.height - 2 * this.boundaryExtension);
                this.sampleResponses(ig, (float[])fv.values, b * nFeaturesPerBand + i * blocksPerFilter);
            }
        }
        return fv;
    }

    protected int computeNumberOfSamplingBlocks() {
        return this.numberOfBlocks * this.numberOfBlocks;
    }

    protected void sampleResponses(FImage image, float[] v, int offset) {
        int gridWidth = image.width / this.numberOfBlocks;
        int gridHeight = image.height / this.numberOfBlocks;
        for (int iy = 0; iy < this.numberOfBlocks; ++iy) {
            int starty = gridHeight * iy;
            int stopy = Math.min(starty + gridHeight, image.height);
            for (int ix = 0; ix < this.numberOfBlocks; ++ix) {
                int startx = gridWidth * ix;
                int stopx = Math.min(startx + gridWidth, image.width);
                float avg = 0.0f;
                for (int y = starty; y < stopy; ++y) {
                    for (int x = startx; x < stopx; ++x) {
                        avg += image.pixels[y][x];
                    }
                }
                v[offset + iy + ix * this.numberOfBlocks] = avg /= (float)((stopx - startx) * (stopy - starty));
            }
        }
    }

    private FImage performConv(FloatFFT_2D fft, float[][] preparedImage, float[][] workingSpace, FImage filterfft, int rows, int cols) {
        float[][] preparedKernel = filterfft.pixels;
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                float reImage = preparedImage[y][x * 2];
                float imImage = preparedImage[y][1 + x * 2];
                float reKernel = preparedKernel[y][x * 2];
                float imKernel = preparedKernel[y][1 + x * 2];
                float re = reImage * reKernel - imImage * imKernel;
                float im = reImage * imKernel + imImage * reKernel;
                workingSpace[y][x * 2] = re;
                workingSpace[y][1 + x * 2] = im;
            }
        }
        fft.complexInverse(workingSpace, true);
        FImage out = new FImage(cols, rows);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                out.pixels[r][c] = (float)Math.sqrt(workingSpace[r][c * 2] * workingSpace[r][c * 2] + workingSpace[r][1 + c * 2] * workingSpace[r][1 + c * 2]);
            }
        }
        return out;
    }

    public MBFImage visualiseDescriptor(int height) {
        Float[][] C = ColourMap.HSV.generateColours(this.orientationsPerScale.length);
        FImage[] G = new FImage[this.gaborFilters.length];
        for (int i = 0; i < this.gaborFilters.length; ++i) {
            G[i] = new FImage(this.gaborFilters[i].width / 2, this.gaborFilters[i].height);
            FourierTransform.unprepareData((float[][])this.gaborFilters[i].pixels, (FImage)G[i], (boolean)false);
            G[i] = ResizeProcessor.halfSize((FImage)G[i]);
            G[i].addInplace(G[i].clone().flipY().flipX());
        }
        int blocksPerFilter = this.computeNumberOfSamplingBlocks();
        int nFeaturesPerBand = this.gaborFilters.length * blocksPerFilter;
        int nBands = ((float[])this.response.values).length / nFeaturesPerBand;
        MBFImage output = new MBFImage(nBands * height, height, ColourSpace.RGB);
        output.fill(RGBColour.WHITE);
        for (int b = 0; b < nBands; ++b) {
            float max = 0.0f;
            MBFImage[] blockImages = new MBFImage[this.numberOfBlocks * this.numberOfBlocks];
            int k = 0;
            for (int y = 0; y < this.numberOfBlocks; ++y) {
                int x = 0;
                while (x < this.numberOfBlocks) {
                    blockImages[k] = new MBFImage(G[0].width, G[0].height, 3);
                    int j = 0;
                    for (int s = 0; s < this.orientationsPerScale.length; ++s) {
                        int i = 0;
                        while (i < this.orientationsPerScale[s]) {
                            MBFImage col = new MBFImage(G[0].width, G[0].height, 3);
                            col.fill(C[s]).multiplyInplace((Comparable)Float.valueOf(((float[])this.response.values)[y + x * this.numberOfBlocks + j * this.numberOfBlocks * this.numberOfBlocks]));
                            blockImages[k].addInplace((MultiBandImage)G[j].toRGB().multiply((Image)col));
                            ++i;
                            ++j;
                        }
                    }
                    for (int i = 0; i < blockImages[k].numBands(); ++i) {
                        max = Math.max(max, ((FImage)blockImages[k].bands.get(i)).max().floatValue());
                    }
                    ++x;
                    ++k;
                }
            }
            int ts = height / 4;
            ResizeProcessor rp = new ResizeProcessor(ts, ts, true);
            int k2 = 0;
            for (int y = 0; y < this.numberOfBlocks; ++y) {
                int x = 0;
                while (x < this.numberOfBlocks) {
                    blockImages[k2].divideInplace((Comparable)Float.valueOf(max));
                    MBFImage tmp = (MBFImage)blockImages[k2].process((SinglebandImageProcessor)rp);
                    tmp.drawLine(0, 0, 0, ts - 1, 1, (Object)RGBColour.WHITE);
                    tmp.drawLine(0, 0, ts - 1, 0, 1, (Object)RGBColour.WHITE);
                    tmp.drawLine(ts - 1, 0, ts - 1, ts - 1, 1, (Object)RGBColour.WHITE);
                    tmp.drawLine(0, ts - 1, ts - 1, ts - 1, 1, (Object)RGBColour.WHITE);
                    output.drawImage((Image)tmp, x * ts + b * height, y * ts);
                    ++x;
                    ++k2;
                }
            }
        }
        return output;
    }

    public FloatFV getResponse() {
        return this.response;
    }
}

