/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.dense.gradient.dsift;

import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.feature.local.list.MemoryLocalFeatureList;
import org.openimaj.image.FImage;
import org.openimaj.image.feature.dense.gradient.dsift.AbstractDenseSIFT;
import org.openimaj.image.feature.dense.gradient.dsift.ByteDSIFTKeypoint;
import org.openimaj.image.feature.dense.gradient.dsift.FloatDSIFTKeypoint;
import org.openimaj.image.processing.convolution.FImageConvolveSeparable;
import org.openimaj.image.processing.convolution.FImageGradients;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.array.ArrayUtils;

public class DenseSIFT
extends AbstractDenseSIFT<FImage> {
    protected int stepX = 5;
    protected int stepY = 5;
    protected int binWidth = 5;
    protected int binHeight = 5;
    protected int numBinsX = 4;
    protected int numBinsY = 4;
    protected int numOriBins = 8;
    protected float gaussianWindowSize = 2.0f;
    protected float valueThreshold = 0.2f;
    protected volatile WorkingData data = new WorkingData();
    protected volatile float[][] descriptors;
    protected volatile float[] energies;

    public DenseSIFT() {
    }

    public DenseSIFT(int step, int binSize) {
        this.binWidth = binSize;
        this.binHeight = binSize;
        this.stepX = step;
        this.stepY = step;
    }

    public DenseSIFT(int stepX, int stepY, int binWidth, int binHeight, int numBinsX, int numBinsY, int numOriBins) {
        this(stepX, stepY, binWidth, binHeight, numBinsX, numBinsY, numOriBins, 2.0f);
    }

    public DenseSIFT(int stepX, int stepY, int binWidth, int binHeight, int numBinsX, int numBinsY, int numOriBins, float gaussianWindowSize) {
        this(stepX, stepY, binWidth, binHeight, numBinsX, numBinsY, numOriBins, gaussianWindowSize, 0.2f);
    }

    public DenseSIFT(int stepX, int stepY, int binWidth, int binHeight, int numBinsX, int numBinsY, int numOriBins, float gaussianWindowSize, float valueThreshold) {
        this.binWidth = binWidth;
        this.binHeight = binHeight;
        this.stepX = stepX;
        this.stepY = stepY;
        this.numBinsX = numBinsX;
        this.numBinsY = numBinsY;
        this.numOriBins = numOriBins;
        this.gaussianWindowSize = gaussianWindowSize;
        this.valueThreshold = valueThreshold;
    }

    private float[] buildKernel(int binSize, int numBins, int binIndex, float windowSize) {
        int kernelSize = 2 * binSize - 1;
        float[] kernel = new float[kernelSize];
        float delta = (float)binSize * ((float)binIndex - 0.5f * (float)(numBins - 1));
        float sigma = (float)binSize * windowSize;
        int x = -binSize + 1;
        int i = 0;
        while (x <= binSize - 1) {
            float z = ((float)x - delta) / sigma;
            kernel[i] = (1.0f - (float)(Math.abs(x) / binSize)) * (binIndex >= 0 ? (float)Math.exp(-0.5f * z * z) : 1.0f);
            ++x;
            ++i;
        }
        return kernel;
    }

    protected void extractFeatures() {
        int frameSizeX = this.binWidth * (this.numBinsX - 1) + 1;
        int frameSizeY = this.binHeight * (this.numBinsY - 1) + 1;
        for (int biny = 0; biny < this.numBinsY; ++biny) {
            float[] yker = this.buildKernel(this.binHeight, this.numBinsY, biny, this.gaussianWindowSize);
            for (int binx = 0; binx < this.numBinsX; ++binx) {
                float[] xker = this.buildKernel(this.binWidth, this.numBinsX, binx, this.gaussianWindowSize);
                for (int bint = 0; bint < this.numOriBins; ++bint) {
                    FImage conv = (FImage)this.data.gradientMagnitudes[bint].process((SinglebandImageProcessor)new FImageConvolveSeparable(xker, yker));
                    float[][] src = conv.pixels;
                    int descriptorOffset = bint + binx * this.numOriBins + biny * (this.numBinsX * this.numOriBins);
                    int descriptorIndex = 0;
                    for (int framey = this.data.boundMinY; framey <= this.data.boundMaxY - frameSizeY + 1; framey += this.stepY) {
                        for (int framex = this.data.boundMinX; framex <= this.data.boundMaxX - frameSizeX + 1; framex += this.stepX) {
                            this.descriptors[descriptorIndex][descriptorOffset] = src[framey + biny * this.binHeight][framex + binx * this.binWidth];
                            ++descriptorIndex;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void analyseImage(FImage image, Rectangle bounds) {
        if (this.data == null) {
            this.data = new WorkingData();
        }
        this.data.boundMinX = (int)bounds.x;
        this.data.boundMaxX = (int)(bounds.width - 1.0f);
        this.data.boundMinY = (int)bounds.y;
        this.data.boundMaxY = (int)(bounds.height - 1.0f);
        this.data.setupWorkingSpace(image, this);
        FImageGradients.gradientMagnitudesAndQuantisedOrientations((FImage)image, (FImage[])this.data.gradientMagnitudes);
        this.extractFeatures();
        this.normaliseDescriptors();
    }

    private void normaliseDescriptors() {
        int frameSizeX = this.binWidth * (this.numBinsX - 1) + 1;
        int frameSizeY = this.binHeight * (this.numBinsY - 1) + 1;
        float energyNorm = frameSizeX * frameSizeY;
        for (int j = 0; j < this.descriptors.length; ++j) {
            float[] arr = this.descriptors[j];
            this.energies[j] = ArrayUtils.sumValues((float[])arr) / energyNorm;
            ArrayUtils.normalise((float[])arr);
            boolean changed = false;
            for (int i = 0; i < arr.length; ++i) {
                if (!(arr[i] > this.valueThreshold)) continue;
                arr[i] = this.valueThreshold;
                changed = true;
            }
            if (!changed) continue;
            ArrayUtils.normalise((float[])arr);
        }
    }

    @Override
    public LocalFeatureList<FloatDSIFTKeypoint> getFloatKeypoints() {
        MemoryLocalFeatureList keys = new MemoryLocalFeatureList(this.numOriBins * this.numBinsX * this.numBinsY, this.descriptors.length);
        int frameSizeX = this.binWidth * (this.numBinsX - 1) + 1;
        int frameSizeY = this.binHeight * (this.numBinsY - 1) + 1;
        float deltaCenterX = 0.5f * (float)this.binWidth * (float)(this.numBinsX - 1);
        float deltaCenterY = 0.5f * (float)this.binHeight * (float)(this.numBinsY - 1);
        int i = 0;
        for (int framey = this.data.boundMinY; framey <= this.data.boundMaxY - frameSizeY + 1; framey += this.stepY) {
            int framex = this.data.boundMinX;
            while (framex <= this.data.boundMaxX - frameSizeX + 1) {
                keys.add((Object)new FloatDSIFTKeypoint((float)framex + deltaCenterX, (float)framey + deltaCenterY, this.descriptors[i], this.energies[i]));
                framex += this.stepX;
                ++i;
            }
        }
        return keys;
    }

    @Override
    public LocalFeatureList<ByteDSIFTKeypoint> getByteKeypoints() {
        MemoryLocalFeatureList keys = new MemoryLocalFeatureList(this.numOriBins * this.numBinsX * this.numBinsY, this.descriptors.length);
        int frameSizeX = this.binWidth * (this.numBinsX - 1) + 1;
        int frameSizeY = this.binHeight * (this.numBinsY - 1) + 1;
        float deltaCenterX = 0.5f * (float)this.binWidth * (float)(this.numBinsX - 1);
        float deltaCenterY = 0.5f * (float)this.binHeight * (float)(this.numBinsY - 1);
        int i = 0;
        for (int framey = this.data.boundMinY; framey <= this.data.boundMaxY - frameSizeY + 1; framey += this.stepY) {
            int framex = this.data.boundMinX;
            while (framex <= this.data.boundMaxX - frameSizeX + 1) {
                keys.add((Object)new ByteDSIFTKeypoint((float)framex + deltaCenterX, (float)framey + deltaCenterY, this.descriptors[i], this.energies[i]));
                framex += this.stepX;
                ++i;
            }
        }
        return keys;
    }

    @Override
    public LocalFeatureList<FloatDSIFTKeypoint> getFloatKeypoints(float energyThreshold) {
        MemoryLocalFeatureList keys = new MemoryLocalFeatureList(this.numOriBins * this.numBinsX * this.numBinsY);
        int frameSizeX = this.binWidth * (this.numBinsX - 1) + 1;
        int frameSizeY = this.binHeight * (this.numBinsY - 1) + 1;
        float deltaCenterX = 0.5f * (float)this.binWidth * (float)(this.numBinsX - 1);
        float deltaCenterY = 0.5f * (float)this.binHeight * (float)(this.numBinsY - 1);
        int i = 0;
        for (int framey = this.data.boundMinY; framey <= this.data.boundMaxY - frameSizeY + 1; framey += this.stepY) {
            int framex = this.data.boundMinX;
            while (framex <= this.data.boundMaxX - frameSizeX + 1) {
                if (this.energies[i] >= energyThreshold) {
                    keys.add((Object)new FloatDSIFTKeypoint((float)framex + deltaCenterX, (float)framey + deltaCenterY, this.descriptors[i], this.energies[i]));
                }
                framex += this.stepX;
                ++i;
            }
        }
        return keys;
    }

    @Override
    public LocalFeatureList<ByteDSIFTKeypoint> getByteKeypoints(float energyThreshold) {
        MemoryLocalFeatureList keys = new MemoryLocalFeatureList(this.numOriBins * this.numBinsX * this.numBinsY);
        int frameSizeX = this.binWidth * (this.numBinsX - 1) + 1;
        int frameSizeY = this.binHeight * (this.numBinsY - 1) + 1;
        float deltaCenterX = 0.5f * (float)this.binWidth * (float)(this.numBinsX - 1);
        float deltaCenterY = 0.5f * (float)this.binHeight * (float)(this.numBinsY - 1);
        int i = 0;
        for (int framey = this.data.boundMinY; framey <= this.data.boundMaxY - frameSizeY + 1; framey += this.stepY) {
            int framex = this.data.boundMinX;
            while (framex <= this.data.boundMaxX - frameSizeX + 1) {
                if (this.energies[i] >= energyThreshold) {
                    keys.add((Object)new ByteDSIFTKeypoint((float)framex + deltaCenterX, (float)framey + deltaCenterY, this.descriptors[i], this.energies[i]));
                }
                framex += this.stepX;
                ++i;
            }
        }
        return keys;
    }

    @Override
    public float[][] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public DenseSIFT clone() {
        DenseSIFT clone = (DenseSIFT)super.clone();
        clone.descriptors = null;
        clone.energies = null;
        clone.data = null;
        return clone;
    }

    @Override
    public void setBinWidth(int size) {
        this.binWidth = size;
    }

    @Override
    public void setBinHeight(int size) {
        this.binHeight = size;
    }

    @Override
    public int getBinWidth() {
        return this.binWidth;
    }

    @Override
    public int getBinHeight() {
        return this.binHeight;
    }

    @Override
    public int getNumBinsX() {
        return this.numBinsX;
    }

    @Override
    public int getNumBinsY() {
        return this.numBinsY;
    }

    @Override
    public int getNumOriBins() {
        return this.numOriBins;
    }

    static class WorkingData {
        protected int boundMinX;
        protected int boundMaxX;
        protected int boundMinY;
        protected int boundMaxY;
        protected FImage[] gradientMagnitudes;

        WorkingData() {
        }

        protected void setupWorkingSpace(FImage image, DenseSIFT dsift) {
            if (this.gradientMagnitudes == null) {
                this.gradientMagnitudes = new FImage[dsift.numOriBins];
            }
            if (this.gradientMagnitudes[0] == null || this.gradientMagnitudes[0].width != image.width || this.gradientMagnitudes[0].height != image.height) {
                for (int i = 0; i < dsift.numOriBins; ++i) {
                    this.gradientMagnitudes[i] = new FImage(image.width, image.height);
                }
            }
            int rangeX = this.boundMaxX - this.boundMinX - (dsift.numBinsX - 1) * dsift.binWidth;
            int rangeY = this.boundMaxY - this.boundMinY - (dsift.numBinsY - 1) * dsift.binHeight;
            int numWindowsX = rangeX >= 0 ? rangeX / dsift.stepX + 1 : 0;
            int numWindowsY = rangeY >= 0 ? rangeY / dsift.stepY + 1 : 0;
            int numFeatures = numWindowsX * numWindowsY;
            dsift.descriptors = new float[numFeatures][dsift.numOriBins * dsift.numBinsX * dsift.numBinsY];
            dsift.energies = new float[numFeatures];
        }
    }
}

