/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.text.extraction;

import java.util.Map;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.analysis.pyramid.PyramidProcessor;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianOctave;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramid;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramidOptions;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.image.text.extraction.LiuSamarabanduTextExtractorBasic;
import org.openimaj.image.text.extraction.TextExtractor;
import org.openimaj.math.geometry.shape.Rectangle;

@Reference(type=ReferenceType.Inproceedings, author={"Liu, X.", "Samarabandu, J."}, title="Multiscale Edge-Based Text Extraction from Complex Images", year="2006", booktitle="Multimedia and Expo, 2006 IEEE International Conference on", pages={"1721 ", "1724"}, month="july", number="", volume="", customData={"keywords", "multiscale edge-based text extraction;printed document image;scene text;text detection;document image processing;edge detection;feature extraction;text analysis;", "doi", "10.1109/ICME.2006.262882", "ISSN", ""})
public class LiuSamarabanduTextExtractorMultiscale
extends TextExtractor<FImage> {
    private static final boolean DEBUG = true;
    private final LiuSamarabanduTextExtractorBasic basicTextExtractor = new LiuSamarabanduTextExtractorBasic();
    private Map<Rectangle, FImage> extractedRegions;
    private boolean doubleSizePyramid = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceWait() {
        LiuSamarabanduTextExtractorMultiscale liuSamarabanduTextExtractorMultiscale = this;
        synchronized (liuSamarabanduTextExtractorMultiscale) {
            try {
                this.wait(200000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void processImage(FImage image) {
        PyramidTextExtractor ped = new PyramidTextExtractor();
        GaussianPyramidOptions gpo = new GaussianPyramidOptions();
        gpo.setScales(1);
        gpo.setExtraScaleSteps(1);
        gpo.setPyramidProcessor((PyramidProcessor)ped);
        gpo.setDoubleInitialImage(this.doubleSizePyramid);
        GaussianPyramid gp = new GaussianPyramid(gpo);
        image.analyseWith((ImageAnalyser)gp);
        FImage msFMap = ped.getFeatureMap();
        FImage fmap = this.basicTextExtractor.textRegionDetection(image);
        if (this.doubleSizePyramid) {
            fmap = ResizeProcessor.doubleSize((FImage)fmap);
        }
        msFMap = fmap.add(msFMap);
        DisplayUtilities.display((Image)msFMap.normalise(), (String)"Fused Feature Map");
        this.basicTextExtractor.processFeatureMap(msFMap, image);
        this.extractedRegions = this.basicTextExtractor.getTextRegions();
        if (this.doubleSizePyramid) {
            for (Rectangle r : this.extractedRegions.keySet()) {
                r.scale(0.5f);
            }
        }
        image.internalAssign(fmap);
    }

    @Override
    public Map<Rectangle, FImage> getTextRegions() {
        return this.extractedRegions;
    }

    public boolean isDoubleSizePyramid() {
        return this.doubleSizePyramid;
    }

    public void setDoubleSizePyramid(boolean doubleSizePyramid) {
        this.doubleSizePyramid = doubleSizePyramid;
    }

    public class PyramidTextExtractor
    implements PyramidProcessor<FImage> {
        private FImage featureMap = null;

        public FImage getFeatureMap() {
            return this.featureMap;
        }

        public void process(GaussianPyramid<FImage> pyramid) {
            FImage fmap = null;
            for (GaussianOctave octave : pyramid) {
                FImage octaveFMap = LiuSamarabanduTextExtractorMultiscale.this.basicTextExtractor.textRegionDetection((FImage)octave.getNextOctaveImage());
                if (fmap == null) {
                    fmap = octaveFMap;
                    continue;
                }
                octaveFMap = ResizeProcessor.resample((FImage)octaveFMap, (int)fmap.getWidth(), (int)fmap.getHeight()).normalise();
                DisplayUtilities.display((Image)octaveFMap, (String)"Resized feature map");
                fmap.addInplace(octaveFMap);
            }
            this.featureMap = fmap;
        }
    }
}

