/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.segmentation;

import java.util.List;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.PixelSet;
import org.openimaj.image.processor.connectedcomponent.render.BlobRenderer;

public class SegmentationUtilities {
    private SegmentationUtilities() {
    }

    public static MBFImage renderSegments(MBFImage image, List<? extends PixelSet> components) {
        for (PixelSet pixelSet : components) {
            BlobRenderer br = new BlobRenderer((Image)image, (Object)RGBColour.randomColour());
            br.process(new ConnectedComponent(pixelSet.pixels));
        }
        return image;
    }

    public static MBFImage renderSegments(int width, int height, List<? extends PixelSet> components) {
        return SegmentationUtilities.renderSegments(new MBFImage(width, height, ColourSpace.RGB), components);
    }
}

