/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.pixel.statistics;

import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.pixel.statistics.BlockHistogramModel;
import org.openimaj.math.statistics.distribution.MultidimensionalHistogram;

public class MaskingBlockHistogramModel
extends BlockHistogramModel {
    private static final long serialVersionUID = 1L;
    private FImage mask;

    public MaskingBlockHistogramModel(FImage mask, int blocks_x, int blocks_y, int ... nbins) {
        super(blocks_x, blocks_y, nbins);
        this.mask = mask;
    }

    @Override
    protected void accum(MBFImage im, int bx, int by) {
        assert (im.numBands() == this.ndims);
        MultidimensionalHistogram histogram = this.histograms[by][bx];
        int height = im.getHeight();
        int width = im.getWidth();
        int cols_per_block = width / this.blocks_x;
        int startx = bx * cols_per_block;
        int stopx = (1 + bx) * cols_per_block;
        int rows_per_block = height / this.blocks_y;
        int starty = by * rows_per_block;
        int stopy = (1 + by) * rows_per_block;
        if (stopx >= width) {
            stopx = width;
        }
        if (stopy >= height) {
            stopy = height;
        }
        for (int y = starty; y < stopy; ++y) {
            for (int x = startx; x < stopx; ++x) {
                if (this.mask.pixels[y][x] != 1.0f) continue;
                int[] bins = new int[this.ndims];
                for (int i = 0; i < this.ndims; ++i) {
                    bins[i] = (int)(((FImage)im.getBand((int)i)).pixels[y][x] * (float)histogram.nbins[i]);
                    if (bins[i] < histogram.nbins[i]) continue;
                    bins[i] = histogram.nbins[i] - 1;
                }
                int bin = 0;
                for (int i = 0; i < this.ndims; ++i) {
                    int f = 1;
                    for (int j = 0; j < i; ++j) {
                        f *= histogram.nbins[j];
                    }
                    bin += f * bins[i];
                }
                double[] dArray = (double[])histogram.values;
                int n = bin;
                dArray[n] = dArray[n] + 1.0;
            }
        }
    }
}

