/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.model.landmark;

import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.analysis.algorithm.TemplateMatcher;
import org.openimaj.image.model.landmark.LandmarkModel;
import org.openimaj.image.model.landmark.LandmarkModelFactory;
import org.openimaj.image.pixel.FValuePixel;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.PointList;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.pair.ObjectFloatPair;

public class FPatchLandmarkModel
implements LandmarkModel<FImage> {
    int blockSize = 11;
    int searchSize = 31;
    FImage average;
    int n = 0;
    TemplateMatcher matcher;

    protected Rectangle getROI(int x, int y, int w, int h) {
        if (w % 2 == 0) {
            ++w;
        }
        if (h % 2 == 0) {
            ++h;
        }
        int roiX = Math.max(0, x - (int)((double)w / 2.0));
        int roiY = Math.max(0, y - (int)((double)h / 2.0));
        int newWidth = (int)((double)w / 2.0) + 1 + (x - roiX);
        int newHeight = (int)((double)h / 2.0) + 1 + (y - roiY);
        return new Rectangle((float)roiX, (float)roiY, (float)newWidth, (float)newHeight);
    }

    protected FImage extractBlock(FImage image, Point2d pt, int sz) {
        return (FImage)image.extractROI(this.getROI((int)pt.getX(), (int)pt.getY(), sz, sz));
    }

    @Override
    public void updateModel(FImage image, Point2d point, PointList pointList) {
        FImage extracted = this.extractBlock(image, point, this.blockSize);
        ++this.n;
        if (this.average == null) {
            this.average = extracted;
        } else {
            this.average.addInplace((FImage)extracted.subtractInplace(this.average).divide((Object)Float.valueOf(this.n)));
        }
        this.matcher = null;
    }

    @Override
    public float computeCost(FImage image, Point2d point, PointList pointList) {
        FImage extracted = this.extractBlock(image, point, this.blockSize);
        if (this.matcher == null) {
            this.matcher = new TemplateMatcher(this.average, TemplateMatcher.Mode.NORM_SUM_SQUARED_DIFFERENCE);
        }
        this.matcher.setSearchBounds(null);
        extracted.analyseWith((ImageAnalyser)this.matcher);
        return this.matcher.getResponseMap().pixels[0][0];
    }

    @Override
    public ObjectFloatPair<Point2d> updatePosition(FImage image, Point2d initial, PointList pointList) {
        Rectangle roi = this.getROI((int)initial.getX(), (int)initial.getY(), this.searchSize, this.searchSize);
        if (this.matcher == null) {
            this.matcher = new TemplateMatcher(this.average, TemplateMatcher.Mode.NORM_SUM_SQUARED_DIFFERENCE);
        }
        this.matcher.setSearchBounds(roi);
        image.analyseWith((ImageAnalyser)this.matcher);
        FValuePixel p = this.matcher.getBestResponses(1)[0];
        return new ObjectFloatPair((Object)p, 0.0f);
    }

    public static class Factory
    implements LandmarkModelFactory<FImage> {
        @Override
        public LandmarkModel<FImage> createLandmarkModel() {
            return new FPatchLandmarkModel();
        }

        @Override
        public LandmarkModel<FImage> createLandmarkModel(float scaleFactor) {
            return new FPatchLandmarkModel();
        }
    }
}

