/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.model.landmark;

import org.openimaj.image.FImage;
import org.openimaj.image.model.landmark.LandmarkModel;
import org.openimaj.image.model.landmark.LandmarkModelFactory;
import org.openimaj.image.pixel.sampling.FLineSampler;
import org.openimaj.image.pixel.statistics.FStatisticalPixelProfileModel;
import org.openimaj.image.pixel.statistics.PixelProfileModel;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.PointList;
import org.openimaj.math.geometry.point.PointListConnections;
import org.openimaj.util.pair.ObjectFloatPair;

public class FNormalLandmarkModel
implements LandmarkModel<FImage> {
    private PointListConnections connections;
    private PixelProfileModel<FImage> model;
    private float normalLength;
    private int numModelSamples;
    private int numSearchSamples;

    public FNormalLandmarkModel(PointListConnections connections, FLineSampler sampler, int numModelSamples, int numSearchSamples, float normalLength) {
        this.connections = connections;
        this.model = new FStatisticalPixelProfileModel(numModelSamples, sampler);
        this.normalLength = normalLength;
        this.numModelSamples = numModelSamples;
        this.numSearchSamples = numSearchSamples;
    }

    @Override
    public void updateModel(FImage image, Point2d point, PointList pointList) {
        float lineScale = this.normalLength * pointList.computeIntrinsicScale();
        Line2d line = this.connections.calculateNormalLine(point, pointList, lineScale);
        this.model.updateModel(image, line);
    }

    @Override
    public float computeCost(FImage image, Point2d point, PointList pointList) {
        float lineScale = this.normalLength * pointList.computeIntrinsicScale();
        Line2d line = this.connections.calculateNormalLine(point, pointList, lineScale);
        return this.model.computeCost(image, line);
    }

    @Override
    public ObjectFloatPair<Point2d> updatePosition(FImage image, Point2d initial, PointList pointList) {
        float scale = (float)this.numSearchSamples * this.normalLength * pointList.computeIntrinsicScale() / (float)this.numModelSamples;
        Line2d line = this.connections.calculateNormalLine(initial, pointList, scale);
        Point2d newBest = this.model.computeNewBest(image, line, this.numSearchSamples);
        float distance = this.model.computeMovementDistance(image, line, this.numSearchSamples, newBest);
        return new ObjectFloatPair((Object)newBest, distance);
    }

    public static class Factory
    implements LandmarkModelFactory<FImage> {
        private PointListConnections connections;
        private float normalLength;
        private int numSearchSamples;
        private FLineSampler sampler;
        private int numModelSamples;

        public Factory(PointListConnections connections, FLineSampler sampler, int numModelSamples, int numSearchSamples, float normalLength) {
            this.connections = connections;
            this.sampler = sampler;
            this.numModelSamples = numModelSamples;
            this.normalLength = normalLength;
            this.numSearchSamples = numSearchSamples;
        }

        public FNormalLandmarkModel createLandmarkModel() {
            return new FNormalLandmarkModel(this.connections, this.sampler, this.numModelSamples, this.numSearchSamples, this.normalLength);
        }

        public FNormalLandmarkModel createLandmarkModel(float scaleFactor) {
            return new FNormalLandmarkModel(this.connections, this.sampler, this.numModelSamples, this.numSearchSamples, scaleFactor * this.normalLength);
        }
    }
}

