/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.analysis.colour.CIEDE2000;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.pixel.PixelSet;
import org.openimaj.image.segmentation.FelzenszwalbHuttenlocherSegmenter;

@Reference(type=ReferenceType.Inproceedings, author={"Che-Hua Yeh", "Yuan-Chen Ho", "Brian A. Barsky", "Ming Ouhyoung"}, title="Personalized Photograph Ranking and Selection System", year="2010", booktitle="Proceedings of ACM Multimedia", pages={"211", "220"}, month="October", customData={"location", "Florence, Italy"})
public class ColourContrast
implements ImageAnalyser<MBFImage>,
FeatureVectorProvider<DoubleFV> {
    FelzenszwalbHuttenlocherSegmenter<MBFImage> segmenter;
    double contrast;

    public ColourContrast() {
        this.segmenter = new FelzenszwalbHuttenlocherSegmenter();
    }

    public ColourContrast(float sigma, float k, int minSize) {
        this.segmenter = new FelzenszwalbHuttenlocherSegmenter(sigma, k, minSize);
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.contrast});
    }

    public void analyseImage(MBFImage image) {
        int i;
        List<ConnectedComponent> ccs = this.segmenter.segment(image);
        MBFImage labImage = ColourSpace.convert((MBFImage)image, (ColourSpace)ColourSpace.CIE_Lab);
        float[][] avgs = new float[ccs.size()][3];
        int w = image.getWidth();
        int h = image.getHeight();
        for (i = 0; i < avgs.length; ++i) {
            for (Pixel p : ccs.get((int)i).pixels) {
                Float[] v = (Float[])labImage.getPixel(p);
                float[] fArray = avgs[i];
                fArray[0] = fArray[0] + v[0].floatValue();
                float[] fArray2 = avgs[i];
                fArray2[0] = fArray2[0] + v[1].floatValue();
                float[] fArray3 = avgs[i];
                fArray3[0] = fArray3[0] + v[2].floatValue();
            }
            int sz = ccs.get((int)i).pixels.size();
            float[] fArray = avgs[i];
            fArray[0] = fArray[0] / (float)sz;
            float[] fArray4 = avgs[i];
            fArray4[1] = fArray4[1] / (float)sz;
            float[] fArray5 = avgs[i];
            fArray5[2] = fArray5[2] / (float)sz;
        }
        for (i = 0; i < avgs.length; ++i) {
            for (int j = i + 1; j < avgs.length; ++j) {
                PixelSet ci = (PixelSet)ccs.get(i);
                PixelSet cj = (PixelSet)ccs.get(i);
                float C = CIEDE2000.calculateDeltaE((float[])avgs[i], (float[])avgs[j]);
                this.contrast += (double)((1.0f - this.distance(ci, cj, w, h)) * (C / (float)(ci.calculateArea() * cj.calculateArea())));
            }
        }
    }

    float distance(PixelSet c1, PixelSet c2, int w, int h) {
        double[] cen1 = c1.calculateCentroid();
        double[] cen2 = c2.calculateCentroid();
        double dx = (cen1[0] - cen2[0]) / (double)w;
        double dy = (cen1[1] - cen2[1]) / (double)h;
        return (float)(Math.sqrt(dx * dx + dy * dy) / Math.sqrt(2.0));
    }
}

