/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.dense.gradient.dsift;

import org.openimaj.image.FImage;
import org.openimaj.image.feature.dense.gradient.dsift.DenseSIFT;
import org.openimaj.image.processing.convolution.FTriangleFilter;
import org.openimaj.image.processor.ImageProcessor;

public class ApproximateDenseSIFT
extends DenseSIFT {
    public ApproximateDenseSIFT() {
    }

    public ApproximateDenseSIFT(int step, int binSize) {
        super(step, binSize);
    }

    public ApproximateDenseSIFT(int stepX, int stepY, int binWidth, int binHeight, int numBinsX, int numBinsY, int numOriBins) {
        super(stepX, stepY, binWidth, binHeight, numBinsX, numBinsY, numOriBins);
    }

    public ApproximateDenseSIFT(int stepX, int stepY, int binWidth, int binHeight, int numBinsX, int numBinsY, int numOriBins, float gaussianWindowSize) {
        super(stepX, stepY, binWidth, binHeight, numBinsX, numBinsY, numOriBins, gaussianWindowSize);
    }

    public ApproximateDenseSIFT(int stepX, int stepY, int binWidth, int binHeight, int numBinsX, int numBinsY, int numOriBins, float gaussianWindowSize, float valueThreshold) {
        super(stepX, stepY, binWidth, binHeight, numBinsX, numBinsY, numOriBins, gaussianWindowSize, valueThreshold);
    }

    private float computeWindowMean(int binSize, int numBins, int binIndex, double windowSize) {
        float delta = (float)binSize * ((float)binIndex - 0.5f * (float)(numBins - 1));
        float sigma = (float)binSize * (float)windowSize;
        float acc = 0.0f;
        for (int x = -binSize + 1; x <= binSize - 1; ++x) {
            float z = ((float)x - delta) / sigma;
            acc += binIndex >= 0 ? (float)Math.exp(-0.5f * z * z) : 1.0f;
        }
        return acc /= (float)(2 * binSize - 1);
    }

    @Override
    protected void extractFeatures() {
        int frameSizeX = this.binWidth * (this.numBinsX - 1) + 1;
        int frameSizeY = this.binHeight * (this.numBinsY - 1) + 1;
        for (int bint = 0; bint < this.numOriBins; ++bint) {
            FImage conv = (FImage)this.data.gradientMagnitudes[bint].process((ImageProcessor)new FTriangleFilter(this.binWidth, this.binHeight));
            float[][] src = conv.pixels;
            for (int biny = 0; biny < this.numBinsY; ++biny) {
                float wy = this.computeWindowMean(this.binHeight, this.numBinsY, biny, this.gaussianWindowSize);
                wy *= (float)this.binHeight;
                for (int binx = 0; binx < this.numBinsX; ++binx) {
                    float wx = this.computeWindowMean(this.binWidth, this.numBinsX, binx, this.gaussianWindowSize);
                    float w = (wx *= (float)this.binWidth) * wy;
                    int descriptorOffset = bint + binx * this.numOriBins + biny * (this.numBinsX * this.numOriBins);
                    int descriptorIndex = 0;
                    for (int framey = this.data.boundMinY; framey <= this.data.boundMaxY - frameSizeY + 1; framey += this.stepY) {
                        for (int framex = this.data.boundMinX; framex <= this.data.boundMaxX - frameSizeX + 1; framex += this.stepX) {
                            this.descriptors[descriptorIndex][descriptorOffset] = w * src[framey + biny * this.binHeight][framex + binx * this.binWidth];
                            ++descriptorIndex;
                        }
                    }
                }
            }
        }
    }

    @Override
    public ApproximateDenseSIFT clone() {
        return (ApproximateDenseSIFT)super.clone();
    }
}

