/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.dense.gradient.binning;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.image.analysis.algorithm.histogram.WindowedHistogramExtractor;
import org.openimaj.image.analysis.algorithm.histogram.binning.SpatialBinningStrategy;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.statistics.distribution.Histogram;
import org.openimaj.util.array.ArrayUtils;

@Reference(type=ReferenceType.Inproceedings, author={"Dalal, Navneet", "Triggs, Bill"}, title="Histograms of Oriented Gradients for Human Detection", year="2005", booktitle="Proceedings of the 2005 IEEE Computer Society Conference on Computer Vision and Pattern Recognition (CVPR'05) - Volume 1 - Volume 01", pages={"886", "", "893"}, url="http://dx.doi.org/10.1109/CVPR.2005.177", publisher="IEEE Computer Society", series="CVPR '05", customData={"isbn", "0-7695-2372-2", "numpages", "8", "doi", "10.1109/CVPR.2005.177", "acmid", "1069007", "address", "Washington, DC, USA"})
public class FixedHOGStrategy
implements SpatialBinningStrategy {
    int cellWidth = 6;
    int cellHeight = 6;
    int cellsPerBlockX = 3;
    int cellsPerBlockY = 3;
    int blockStepX = 1;
    int blockStepY = 1;
    BlockNormalisation norm = BlockNormalisation.L2;

    public FixedHOGStrategy(int cellSize, int cellsPerBlock, BlockNormalisation norm) {
        this(cellSize, cellsPerBlock, 1, norm);
    }

    public FixedHOGStrategy(int cellSize, int cellsPerBlock, int blockStep, BlockNormalisation norm) {
        this(cellSize, cellSize, cellsPerBlock, cellsPerBlock, blockStep, blockStep, norm);
    }

    public FixedHOGStrategy(int cellWidth, int cellHeight, int cellsPerBlockX, int cellsPerBlockY, int blockStepX, int blockStepY, BlockNormalisation norm) {
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.cellsPerBlockX = cellsPerBlockX;
        this.cellsPerBlockY = cellsPerBlockY;
        this.norm = norm;
        this.blockStepX = blockStepX;
        this.blockStepY = blockStepY;
    }

    public Histogram extract(WindowedHistogramExtractor binnedData, Rectangle region, Histogram output) {
        Histogram[][] cells = this.computeCells(binnedData, region);
        Histogram[][] blocks = this.computeBlocks(cells);
        int blockSize = ((double[])blocks[0][0].values).length;
        int blockArea = this.cellsPerBlockX * this.cellsPerBlockY;
        if (output == null || ((double[])output.values).length != blocks[0].length * blocks.length * blockSize) {
            output = new Histogram(blocks[0].length * blocks.length * blockSize);
        }
        int k = 0;
        for (int j = 0; j < blocks.length; ++j) {
            int i = 0;
            while (i < blocks[0].length) {
                this.norm.normalise(blocks[j][i], blockArea);
                System.arraycopy(blocks[j][i].values, 0, output.values, k * blockSize, blockSize);
                ++i;
                ++k;
            }
        }
        return output;
    }

    private Histogram[][] computeBlocks(Histogram[][] cells) {
        int numBlocksX = 1 + (cells[0].length - this.cellsPerBlockX) / this.blockStepX;
        int numBlocksY = 1 + (cells.length - this.cellsPerBlockY) / this.blockStepY;
        Histogram[][] blocks = new Histogram[numBlocksY][numBlocksX];
        for (int y = 0; y < numBlocksY; ++y) {
            for (int x = 0; x < numBlocksX; ++x) {
                Histogram[] blockData = new Histogram[this.cellsPerBlockX * this.cellsPerBlockY];
                int k = 0;
                for (int j = 0; j < this.cellsPerBlockY; ++j) {
                    for (int i = 0; i < this.cellsPerBlockX; ++i) {
                        blockData[k++] = cells[y * this.blockStepY + j][x * this.blockStepX + i];
                    }
                }
                blocks[y][x] = new Histogram((DoubleFV[])blockData);
            }
        }
        return blocks;
    }

    private Histogram[][] computeCells(WindowedHistogramExtractor binnedData, Rectangle region) {
        int numCellsX = (int)((region.width + (float)(this.cellWidth / 2)) / (float)this.cellWidth);
        int numCellsY = (int)((region.height + (float)(this.cellHeight / 2)) / (float)this.cellHeight);
        Histogram[][] cells = new Histogram[numCellsY][numCellsX];
        int j = 0;
        int y = (int)region.y;
        while (j < numCellsY) {
            int i = 0;
            int x = (int)region.x;
            while (i < numCellsX) {
                cells[j][i] = binnedData.computeHistogram(x, y, this.cellWidth, this.cellHeight);
                cells[j][i].normaliseL2();
                ++i;
                x += this.cellWidth;
            }
            ++j;
            y += this.cellHeight;
        }
        return cells;
    }

    public static enum BlockNormalisation {
        L1{

            @Override
            final void normalise(Histogram h, int blockArea) {
                h.normaliseL1();
            }
        }
        ,
        L2{

            @Override
            final void normalise(Histogram h, int blockArea) {
                ArrayUtils.divide((double[])((double[])h.values), (double)blockArea);
            }
        }
        ,
        L1sqrt{

            @Override
            final void normalise(Histogram h, int blockArea) {
                h.normaliseL1();
                for (int x = 0; x < ((double[])h.values).length; ++x) {
                    ((double[])h.values)[x] = Math.sqrt(((double[])h.values)[x]);
                }
            }
        }
        ,
        L2clip{

            @Override
            final void normalise(Histogram h, int blockArea) {
                double sumsq = 0.0;
                for (int x = 0; x < ((double[])h.values).length; ++x) {
                    ((double[])h.values)[x] = ((double[])h.values)[x] / (double)blockArea;
                    if (((double[])h.values)[x] > 0.2) {
                        ((double[])h.values)[x] = 0.2;
                    }
                    sumsq += ((double[])h.values)[x] * ((double[])h.values)[x];
                }
                double invNorm = 1.0 / Math.sqrt(sumsq);
                int x = 0;
                while (x < ((double[])h.values).length) {
                    double[] dArray = (double[])h.values;
                    int n = x++;
                    dArray[n] = dArray[n] * invNorm;
                }
            }
        };


        abstract void normalise(Histogram var1, int var2);
    }
}

