/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.dense.binarypattern;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.pixel.Pixel;

@Reference(type=ReferenceType.Article, author={"Ojala, T.", "Pietikainen, M.", "Harwood, D."}, title="A Comparative Study of Texture Measures with Classification Based on Feature Distributions", year="1996", journal="Pattern Recognition", pages={"51", "59"}, month="January", number="1", volume="29")
public class BasicLocalBinaryPattern
implements ImageAnalyser<FImage> {
    protected int[][] pattern = null;

    public int[][] getPattern() {
        return this.pattern;
    }

    public static int[][] calculateLBP(FImage image) {
        int[][] pattern = new int[image.height][image.width];
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                pattern[y][x] = BasicLocalBinaryPattern.calculateLBP(image, x, y);
            }
        }
        return pattern;
    }

    public static int calculateLBP(FImage image, int x, int y) {
        float thresh = image.pixels[y][x];
        int i = 0;
        int pattern = 0;
        for (int yy = -1; yy < 2; ++yy) {
            for (int xx = -1; xx < 2; ++xx) {
                if (xx == 0 && yy == 0) continue;
                int xxx = x + xx;
                int yyy = y + yy;
                float pix = 0.0f;
                if (xxx >= 0 && xxx < image.width && yyy >= 0 && yyy < image.height) {
                    pix = image.pixels[yyy][xxx];
                }
                if (pix >= thresh) {
                    pattern = (int)((double)pattern + Math.pow(2.0, i));
                }
                ++i;
            }
        }
        return pattern;
    }

    public static int calculateLBP(FImage image, Pixel point) {
        return BasicLocalBinaryPattern.calculateLBP(image, point.x, point.y);
    }

    public void analyseImage(FImage image) {
        this.pattern = BasicLocalBinaryPattern.calculateLBP(image);
    }
}

