/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.contour;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.contour.ContourFollowingStrategy;
import org.openimaj.image.contour.Direction;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.util.function.Operation;
import org.openimaj.util.pair.IndependentPair;

@Reference(type=ReferenceType.Article, author={"Suzuki, S.", "Abe, K."}, title="Topological Structural Analysis of Digitized Binary Image by Border Following", year="1985", journal="Computer Vision, Graphics and Image Processing", pages={"32", "46"}, month="January", number="1", volume="30")
public class SuzukiNeighborStrategy
extends ContourFollowingStrategy {
    @Override
    public void contour(FImage image, Pixel start, Pixel from, final Operation<Pixel> operation) {
        this.directedContour(image, start, from, new Operation<IndependentPair<Pixel, boolean[]>>(){

            public void perform(IndependentPair<Pixel, boolean[]> object) {
                operation.perform(object.firstObject());
            }
        });
    }

    public void directedContour(FImage image, Pixel ij, Pixel i2j2, Operation<IndependentPair<Pixel, boolean[]>> operation) {
        Direction trace;
        Direction dir = Direction.fromTo(ij, i2j2);
        Pixel i1j1 = null;
        for (trace = dir.clockwise(); trace != dir; trace = trace.clockwise()) {
            Pixel activePixel = trace.active(image, ij);
            if (activePixel == null) continue;
            i1j1 = activePixel;
            break;
        }
        if (i1j1 == null) {
            return;
        }
        i2j2 = i1j1;
        Pixel i3j3 = ij;
        boolean[] checked = new boolean[]{false, false, false, false, false, false, false, false};
        while (true) {
            dir = Direction.fromTo(i3j3, i2j2);
            trace = dir.counterClockwise();
            Pixel i4j4 = null;
            this.resetChecked(checked);
            while ((i4j4 = trace.active(image, i3j3)) == null) {
                checked[trace.ordinal()] = true;
                trace = trace.counterClockwise();
            }
            operation.perform((Object)IndependentPair.pair((Object)i3j3, (Object)checked));
            if (i4j4.equals((Object)ij) && i3j3.equals((Object)i1j1)) break;
            i2j2 = i3j3;
            i3j3 = i4j4;
        }
    }

    private void resetChecked(boolean[] checked) {
        for (int i = 0; i < checked.length; ++i) {
            checked[i] = false;
        }
    }
}

