/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.contour;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openimaj.image.contour.ContourType;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Rectangle;

public class Contour
extends Polygon {
    public ContourType type;
    public List<Contour> children = new ArrayList<Contour>();
    public Contour parent;
    public Pixel start;
    Rectangle rect = null;

    public Contour(ContourType type) {
        this.type = type;
        this.start = new Pixel(0, 0);
    }

    public Contour(ContourType type, int x, int y) {
        this.type = type;
        this.start = new Pixel(x, y);
    }

    public Contour(ContourType type, Pixel p) {
        this.type = type;
        this.start = p;
    }

    public Contour(int x, int y) {
        this.type = null;
        this.start = new Pixel(x, y);
    }

    protected void setParent(Contour bp) {
        this.parent = bp;
        bp.children.add(this);
    }

    public String toString() {
        StringWriter contour = new StringWriter();
        PrintWriter pw = new PrintWriter(contour);
        pw.println(String.format("[%s] start: %s %s", new Object[]{this.type, this.start, this.points}));
        for (Contour child : this.children) {
            pw.print((Object)child);
        }
        pw.flush();
        return contour.toString();
    }

    public void finish() {
        this.rect = this.calculateRegularBoundingBox();
    }

    public Iterator<Contour> contourIterator() {
        return new ContourIterator();
    }

    public Iterable<Contour> contourIterable() {
        return new Iterable<Contour>(){

            @Override
            public Iterator<Contour> iterator() {
                return Contour.this.contourIterator();
            }
        };
    }

    public boolean isHole() {
        return this.type != null && this.type.equals((Object)ContourType.HOLE);
    }

    private class ContourIterator
    implements Iterator<Contour> {
        final List<Contour> toProcess = new ArrayList<Contour>();

        ContourIterator() {
            this.toProcess.add(Contour.this);
        }

        @Override
        public boolean hasNext() {
            return !this.toProcess.isEmpty();
        }

        @Override
        public Contour next() {
            Contour next = this.toProcess.remove(this.toProcess.size() - 1);
            this.toProcess.addAll(next.children);
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removal not supported");
        }
    }
}

