/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.connectedcomponent;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;

public class ConnectedComponentLabeler
implements ImageAnalyser<FImage> {
    protected float bgThreshold = 0.0f;
    protected Algorithm algorithm = Algorithm.TWO_PASS;
    protected ConnectedComponent.ConnectMode mode;
    protected List<ConnectedComponent> components;

    public ConnectedComponentLabeler(ConnectedComponent.ConnectMode mode) {
        this.mode = mode;
    }

    public ConnectedComponentLabeler(Algorithm algorithm, ConnectedComponent.ConnectMode mode) {
        this.algorithm = algorithm;
        this.mode = mode;
    }

    public ConnectedComponentLabeler(Algorithm algorithm, float bgThreshold, ConnectedComponent.ConnectMode mode) {
        this.algorithm = algorithm;
        this.bgThreshold = bgThreshold;
        this.mode = mode;
    }

    public List<ConnectedComponent> findComponents(FImage image) {
        this.analyseImage(image);
        return this.components;
    }

    public void analyseImage(FImage image) {
        this.components = this.algorithm.findComponents(image, this.bgThreshold, this.mode);
    }

    public List<ConnectedComponent> getComponents() {
        return this.components;
    }

    public static enum Algorithm {
        SINGLE_PASS{

            @Override
            public List<ConnectedComponent> findComponents(FImage image, float bgThreshold, ConnectedComponent.ConnectMode mode) {
                ArrayList<ConnectedComponent> components = new ArrayList<ConnectedComponent>();
                for (int y = 0; y < image.height; ++y) {
                    for (int x = 0; x < image.width; ++x) {
                        float element = image.pixels[y][x];
                        if (!(element > bgThreshold)) continue;
                        List neighbours = mode.getNeighbours(image, x, y, bgThreshold);
                        ConnectedComponent currentComponent = null;
                        for (Pixel p : neighbours) {
                            ConnectedComponent cc = this.searchPixel(p, components);
                            if (cc == null) continue;
                            if (currentComponent == null) {
                                currentComponent = cc;
                                continue;
                            }
                            if (currentComponent == cc) continue;
                            currentComponent.merge(cc);
                            components.remove(cc);
                        }
                        if (currentComponent == null) {
                            currentComponent = new ConnectedComponent();
                            components.add(currentComponent);
                        }
                        currentComponent.addPixel(x, y);
                    }
                }
                return components;
            }

            private ConnectedComponent searchPixel(Pixel p, List<ConnectedComponent> components) {
                for (ConnectedComponent c : components) {
                    if (!c.find(p)) continue;
                    return c;
                }
                return null;
            }
        }
        ,
        TWO_PASS{

            @Override
            public List<ConnectedComponent> findComponents(FImage image, float bgThreshold, ConnectedComponent.ConnectMode mode) {
                ArrayList<ConnectedComponent> components = new ArrayList<ConnectedComponent>();
                TIntIntHashMap linked = new TIntIntHashMap();
                int[][] labels = new int[image.height][image.width];
                int nextLabel = 1;
                for (int y = 0; y < image.height; ++y) {
                    for (int x = 0; x < image.width; ++x) {
                        int i;
                        float element = image.pixels[y][x];
                        if (!(element > bgThreshold)) continue;
                        List neighbours = mode.getNeighbours(image, x, y, bgThreshold);
                        ArrayList<Integer> L = new ArrayList<Integer>();
                        for (Pixel p : neighbours) {
                            if (labels[p.y][p.x] == 0) continue;
                            L.add(labels[p.y][p.x]);
                        }
                        if (L.size() == 0) {
                            linked.put(nextLabel, nextLabel);
                            labels[y][x] = nextLabel++;
                            continue;
                        }
                        int min = Integer.MAX_VALUE;
                        Iterator iterator = L.iterator();
                        while (iterator.hasNext()) {
                            i = (Integer)iterator.next();
                            if (i >= min) continue;
                            min = i;
                        }
                        labels[y][x] = min;
                        iterator = L.iterator();
                        while (iterator.hasNext()) {
                            i = (Integer)iterator.next();
                            this.merge(linked, i, min);
                        }
                    }
                }
                HashMap<Integer, ConnectedComponent> comp = new HashMap<Integer, ConnectedComponent>();
                for (int i = 1; i <= linked.size(); ++i) {
                    int m;
                    int min = linked.get(i);
                    while ((m = linked.get(min)) != min) {
                        min = m;
                    }
                    linked.put(i, min);
                }
                for (int y = 0; y < image.height; ++y) {
                    for (int x = 0; x < image.width; ++x) {
                        if (labels[y][x] == 0) continue;
                        int min = linked.get(labels[y][x]);
                        if (comp.containsKey(min)) {
                            ((ConnectedComponent)comp.get(min)).addPixel(x, y);
                            continue;
                        }
                        ConnectedComponent cc = new ConnectedComponent();
                        cc.addPixel(x, y);
                        comp.put(min, cc);
                    }
                }
                components.addAll(comp.values());
                return components;
            }

            private void merge(TIntIntHashMap linked, int start, int target) {
                if (start == target) {
                    return;
                }
                int old = linked.get(start);
                if (old > target) {
                    linked.put(start, target);
                    this.merge(linked, old, target);
                } else {
                    this.merge(linked, target, old);
                }
            }
        }
        ,
        FLOOD_FILL{

            @Override
            public List<ConnectedComponent> findComponents(FImage image, float bgThreshold, ConnectedComponent.ConnectMode mode) {
                ArrayList<ConnectedComponent> components = new ArrayList<ConnectedComponent>();
                int[][] labels = new int[image.height][image.width];
                int nextColor = 1;
                for (int y = 0; y < image.height; ++y) {
                    for (int x = 0; x < image.width; ++x) {
                        if (image.pixels[y][x] == 0.0f || labels[y][x] != 0) continue;
                        components.add(this.floodFill(image, new Pixel(x, y), labels, nextColor));
                        ++nextColor;
                    }
                }
                return components;
            }

            protected ConnectedComponent floodFill(FImage image, Pixel start, int[][] output, int color) {
                ConnectedComponent cc = new ConnectedComponent();
                LinkedHashSet<Pixel> queue = new LinkedHashSet<Pixel>();
                if (image.pixels[start.y][start.x] == 0.0f) {
                    return cc;
                }
                queue.add(start);
                while (queue.size() > 0) {
                    Pixel n = (Pixel)queue.iterator().next();
                    queue.remove(n);
                    if (image.pixels[n.y][n.x] == 0.0f || output[n.y][n.x] == color) continue;
                    int e = n.x;
                    for (int w = n.x; w > 0 && image.pixels[n.y][w - 1] != 0.0f; --w) {
                    }
                    while (e < image.width - 1 && image.pixels[n.y][e + 1] != 0.0f) {
                        ++e;
                    }
                    for (int i = w; i <= e; ++i) {
                        output[n.y][i] = color;
                        cc.addPixel(i, n.y);
                        int north = n.y - 1;
                        int south = n.y + 1;
                        if (north >= 0 && image.pixels[north][i] != 0.0f && output[north][i] != color) {
                            queue.add(new Pixel(i, north));
                        }
                        if (south >= image.height || image.pixels[south][i] == 0.0f || output[south][i] == color) continue;
                        queue.add(new Pixel(i, south));
                    }
                }
                return cc;
            }
        };


        public abstract List<ConnectedComponent> findComponents(FImage var1, float var2, ConnectedComponent.ConnectMode var3);
    }
}

