/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.spectral;

import ch.akuhn.matrix.Vector;
import ch.akuhn.matrix.eigenvalues.Eigenvalues;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openimaj.ml.clustering.DataClusterer;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.SpatialClusterer;
import org.openimaj.ml.clustering.spectral.SpectralClusteringConf;
import org.openimaj.ml.clustering.spectral.SpectralIndexedClusters;
import org.openimaj.util.pair.DoubleObjectPair;
import org.openimaj.util.pair.IndependentPair;

public class PreparedSpectralClustering
implements DataClusterer<Eigenvalues, SpectralIndexedClusters> {
    static final Logger logger = LogManager.getLogger(PreparedSpectralClustering.class);
    private SpectralClusteringConf<double[]> conf;

    public PreparedSpectralClustering(SpectralClusteringConf<double[]> conf) {
        this.conf = conf;
    }

    public int[][] performClustering(Eigenvalues data) {
        return this.cluster(data).clusters();
    }

    @Override
    public SpectralIndexedClusters cluster(Eigenvalues eig) {
        IndependentPair<double[], double[][]> lowestCols = this.bestCols(eig);
        return this.eigenspaceCluster(lowestCols);
    }

    protected SpectralIndexedClusters eigenspaceCluster(IndependentPair<double[], double[][]> lowestCols) {
        SpatialClusterer clusterer = (SpatialClusterer)this.conf.internal.apply(lowestCols);
        Object cluster = clusterer.cluster((Object[])lowestCols.getSecondObject());
        if (cluster instanceof IndexClusters) {
            IndexClusters clusters = new IndexClusters(((IndexClusters)cluster).clusters());
            return new SpectralIndexedClusters(clusters, lowestCols);
        }
        int[] clustered = cluster.defaultHardAssigner().assign((Object[])lowestCols.getSecondObject());
        return new SpectralIndexedClusters(new IndexClusters(clustered), lowestCols);
    }

    protected IndependentPair<double[], double[][]> bestCols(Eigenvalues eig) {
        int eigenVectorSelect = this.conf.eigenChooser.nEigenVectors(this.conf.laplacian.eigenIterator(eig), eig.getN());
        int eigenVectorSkip = this.conf.skipEigenVectors;
        logger.debug("Selected dimensions: " + eigenVectorSelect);
        logger.debug("Skipping dimesions: " + eigenVectorSkip);
        int nrows = eig.vector[0].size();
        double[][] ret = new double[nrows][eigenVectorSelect -= eigenVectorSkip];
        double[] retSum = new double[nrows];
        double[] eigvals = new double[eigenVectorSelect];
        Iterator<DoubleObjectPair<Vector>> iterator = this.conf.laplacian.eigenIterator(eig);
        for (int i = 0; i < eigenVectorSkip; ++i) {
            iterator.next();
        }
        int col = 0;
        while (iterator.hasNext()) {
            DoubleObjectPair<Vector> v = iterator.next();
            eigvals[col] = v.first;
            for (Vector.Entry d : ((Vector)v.second).entries()) {
                double elColI = d.value;
                if (this.conf.eigenValueScale) {
                    elColI *= Math.sqrt(v.first);
                }
                ret[d.index][col] = elColI;
                int n = d.index;
                retSum[n] = retSum[n] + elColI * elColI;
            }
            if (++col != eigenVectorSelect) continue;
            break;
        }
        if (!this.conf.eigenValueScale) {
            for (int i = 0; i < ret.length; ++i) {
                double[] row = ret[i];
                int j = 0;
                while (j < row.length) {
                    int n = j++;
                    row[n] = row[n] / Math.sqrt(retSum[i]);
                }
            }
        }
        return IndependentPair.pair((Object)eigvals, (Object)ret);
    }
}

