/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.spectral;

import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.SparseMatrix;
import ch.akuhn.matrix.Vector;
import ch.akuhn.matrix.eigenvalues.Eigenvalues;
import ch.akuhn.matrix.eigenvalues.FewEigenvalues;
import java.util.Iterator;
import org.openimaj.ml.clustering.spectral.EigenChooser;
import org.openimaj.util.pair.DoubleObjectPair;

public class HardCodedEigenChooser
extends EigenChooser {
    int count;

    public HardCodedEigenChooser(int eigK) {
        this.count = eigK;
    }

    @Override
    public int nEigenVectors(Iterator<DoubleObjectPair<Vector>> vals, int total) {
        return this.count;
    }

    @Override
    public Eigenvalues prepare(SparseMatrix laplacian) {
        FewEigenvalues eig = FewEigenvalues.of((Matrix)laplacian);
        return eig.greatest(this.count);
    }

    public String toString() {
        return String.format("hardcoded_eig=%d", this.count);
    }
}

