/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.random;

import java.util.Arrays;
import java.util.Random;
import org.openimaj.data.DataSource;
import org.openimaj.data.RandomData;
import org.openimaj.ml.clustering.FloatCentroidsResult;
import org.openimaj.ml.clustering.random.RandomFloatClusterer;

public class RandomSetFloatClusterer
extends RandomFloatClusterer {
    public RandomSetFloatClusterer(int M) {
        super(M);
    }

    public RandomSetFloatClusterer(int M, int K) {
        super(M, K);
    }

    @Override
    public FloatCentroidsResult cluster(float[][] data) {
        FloatCentroidsResult result = new FloatCentroidsResult();
        if (this.K == -1) {
            result.centroids = data;
        } else {
            if (data.length < this.K) {
                throw new IllegalArgumentException("Not enough data");
            }
            result.centroids = new float[this.K][];
            int[] indices = this.seed >= 0L ? RandomData.getUniqueRandomInts((int)this.K, (int)0, (int)data.length, (Random)new Random(this.seed)) : RandomData.getUniqueRandomInts((int)this.K, (int)0, (int)data.length);
            for (int i = 0; i < indices.length; ++i) {
                int dIndex = indices[i];
                result.centroids[i] = Arrays.copyOf(data[dIndex], data[dIndex].length);
            }
        }
        return result;
    }

    @Override
    public FloatCentroidsResult cluster(DataSource<float[]> data) {
        FloatCentroidsResult result = new FloatCentroidsResult();
        if (this.K == -1) {
            int nc = data.size();
            result.centroids = new float[nc][data.numDimensions()];
        } else {
            result.centroids = new float[this.K][data.numDimensions()];
        }
        data.getRandomRows((Object[])result.centroids);
        return result;
    }
}

