/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.random;

import ch.akuhn.matrix.SparseMatrix;
import gnu.trove.list.array.TIntArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.SparseMatrixClusterer;

public class RandomClusterer
implements SparseMatrixClusterer<IndexClusters> {
    private Random random;
    private int forceClusters = -1;

    public RandomClusterer() {
        this.random = new Random();
    }

    public RandomClusterer(long seed) {
        this.random = new Random(seed);
    }

    public RandomClusterer(int nclusters) {
        this();
        this.forceClusters = nclusters;
    }

    public RandomClusterer(int nclusters, long seed) {
        this(seed);
        this.forceClusters = nclusters;
    }

    @Override
    public IndexClusters cluster(SparseMatrix data) {
        int nClusters = 0;
        nClusters = this.forceClusters > 0 ? this.forceClusters : this.random.nextInt(data.rowCount());
        HashMap<Integer, TIntArrayList> clusters = new HashMap<Integer, TIntArrayList>();
        for (int i = 0; i < data.rowCount(); ++i) {
            int cluster = this.random.nextInt(nClusters);
            TIntArrayList l = (TIntArrayList)clusters.get(cluster);
            if (l == null) {
                l = new TIntArrayList();
                clusters.put(cluster, l);
            }
            l.add(i);
        }
        int[][] outClusters = new int[clusters.size()][];
        int i = 0;
        for (Map.Entry is : clusters.entrySet()) {
            outClusters[i++] = ((TIntArrayList)is.getValue()).toArray();
        }
        return new IndexClusters(outClusters, data.rowCount());
    }

    public int[][] performClustering(SparseMatrix data) {
        return this.cluster(data).clusters();
    }
}

