/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.soft;

import org.openimaj.feature.FloatFVComparator;
import org.openimaj.feature.FloatFVComparison;
import org.openimaj.knn.FloatNearestNeighbours;
import org.openimaj.knn.FloatNearestNeighboursExact;
import org.openimaj.knn.FloatNearestNeighboursProvider;
import org.openimaj.knn.approximate.FloatNearestNeighboursKDTree;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.SoftAssigner;
import org.openimaj.util.pair.IndependentPair;

public class FloatKNNAssigner
implements SoftAssigner<float[], float[]> {
    protected FloatNearestNeighbours nn;
    protected int numNeighbours;

    public FloatKNNAssigner(CentroidsProvider<float[]> provider, boolean exact, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        if (exact) {
            this.nn = new FloatNearestNeighboursExact((float[][])provider.getCentroids());
        } else {
            FloatNearestNeighbours internal;
            if (provider instanceof FloatNearestNeighboursProvider && (internal = ((FloatNearestNeighboursProvider)provider).getNearestNeighbours()) != null && internal instanceof FloatNearestNeighboursKDTree) {
                this.nn = (FloatNearestNeighboursKDTree)internal;
                return;
            }
            this.nn = new FloatNearestNeighboursKDTree((float[][])provider.getCentroids(), 8, 768);
        }
    }

    public FloatKNNAssigner(float[][] data, boolean exact, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = exact ? new FloatNearestNeighboursExact(data) : new FloatNearestNeighboursKDTree(data, 8, 768);
    }

    public FloatKNNAssigner(CentroidsProvider<float[]> provider, FloatFVComparison comparison, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = new FloatNearestNeighboursExact((float[][])provider.getCentroids(), (FloatFVComparator)comparison);
    }

    public FloatKNNAssigner(float[][] data, FloatFVComparison comparison, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = new FloatNearestNeighboursExact(data, (FloatFVComparator)comparison);
    }

    public int[][] assign(float[][] data) {
        int[][] indices = new int[data.length][this.numNeighbours];
        float[][] distances = new float[data.length][this.numNeighbours];
        this.nn.searchKNN((Object[])data, this.numNeighbours, indices, (Object[])distances);
        return indices;
    }

    @Override
    public int[] assign(float[] data) {
        return this.assign(new float[][]{data})[0];
    }

    public void assignWeighted(float[][] data, int[][] assignments, float[][] weights) {
        this.nn.searchKNN((Object[])data, this.numNeighbours, assignments, (Object[])weights);
    }

    @Override
    public IndependentPair<int[], float[]> assignWeighted(float[] data) {
        int[][] indices = new int[data.length][this.numNeighbours];
        float[][] distances = new float[data.length][this.numNeighbours];
        this.nn.searchKNN((Object[])new float[][]{data}, this.numNeighbours, indices, (Object[])distances);
        return new IndependentPair((Object)indices[0], (Object)distances[0]);
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }

    @Override
    public int size() {
        return this.nn.size();
    }
}

