/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.feature.FloatFVComparator;
import org.openimaj.knn.FloatNearestNeighboursExact;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.util.pair.IntFloatPair;

public class ExactFloatAssigner
implements HardAssigner<float[], float[], IntFloatPair> {
    protected FloatNearestNeighboursExact nn;

    public ExactFloatAssigner(CentroidsProvider<float[]> provider) {
        this(provider, null);
    }

    public ExactFloatAssigner(CentroidsProvider<float[]> provider, FloatFVComparator comparison) {
        this.nn = new FloatNearestNeighboursExact((float[][])provider.getCentroids(), comparison);
    }

    public ExactFloatAssigner(float[][] data, FloatFVComparator comparison) {
        this.nn = new FloatNearestNeighboursExact(data, comparison);
    }

    public int[] assign(float[][] data) {
        int[] argmins = new int[data.length];
        float[] mins = new float[data.length];
        this.nn.searchNN(data, argmins, mins);
        return argmins;
    }

    @Override
    public int assign(float[] data) {
        return this.assign(new float[][]{data})[0];
    }

    public void assignDistance(float[][] data, int[] indices, float[] distances) {
        this.nn.searchNN(data, indices, distances);
    }

    @Override
    public IntFloatPair assignDistance(float[] data) {
        int[] index = new int[1];
        float[] distance = new float[1];
        this.nn.searchNN((float[][])new float[][]{data}, index, distance);
        return new IntFloatPair(index[0], distance[0]);
    }

    @Override
    public int size() {
        return this.nn.size();
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }

    public FloatNearestNeighboursExact getNN() {
        return this.nn;
    }
}

