/*
	AUTOMATICALLY GENERATED BY jTemp FROM
	/Users/jsh2/Work/openimaj/target/checkout/machine-learning/clustering/src/main/jtemp/org/openimaj/ml/clustering/assignment/soft/#T#KNNAssigner.jtemp
*/
/**
 * Copyright (c) 2011, The University of Southampton and the individual contributors.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *   * 	Redistributions of source code must retain the above copyright notice,
 * 	this list of conditions and the following disclaimer.
 *
 *   *	Redistributions in binary form must reproduce the above copyright notice,
 * 	this list of conditions and the following disclaimer in the documentation
 * 	and/or other materials provided with the distribution.
 *
 *   *	Neither the name of the University of Southampton nor the names of its
 * 	contributors may be used to endorse or promote products derived from this
 * 	software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openimaj.ml.clustering.assignment.soft;

import org.openimaj.feature.ShortFVComparison;
import org.openimaj.knn.ShortNearestNeighbours;
import org.openimaj.knn.ShortNearestNeighboursExact;
import org.openimaj.knn.ShortNearestNeighboursProvider;
import org.openimaj.knn.approximate.ShortNearestNeighboursKDTree;
import org.openimaj.ml.clustering.assignment.SoftAssigner;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.util.pair.IndependentPair;

/**
 * A {@link SoftAssigner} that picks a fixed number of nearest neighbours.
 * Weights returned are actually the distances to the centroids.
 * 
 * @author Jonathon Hare (jsh2@ecs.soton.ac.uk)
 *
 */
public class ShortKNNAssigner implements SoftAssigner<short[], float[]> {
	protected ShortNearestNeighbours nn;
	protected int numNeighbours;

	/**
	 * Construct the assigner using the given cluster data. The assigner
	 * is backed by either a {@link ShortNearestNeighboursExact} or 
	 * {@link ShortNearestNeighboursKDTree}, depending on whether the exact
	 * parameter is true or false. If the parameter is true, then the 
	 * resultant {@link ShortNearestNeighboursExact} will use Euclidean
	 * distance.
	 * 
	 * @param provider the cluster data provider
	 * @param exact if true, then use exact mode; false implies approximate mode.
	 * @param numNeighbours the number of nearest neighbours to select.
	 */
	public ShortKNNAssigner(CentroidsProvider<short[]> provider, boolean exact, int numNeighbours) {
		this.numNeighbours = numNeighbours;
		
		if (exact) {
			nn = new ShortNearestNeighboursExact(provider.getCentroids());
		} else {
			if (provider instanceof ShortNearestNeighboursProvider) {
				ShortNearestNeighbours internal = ((ShortNearestNeighboursProvider)provider).getNearestNeighbours();

				if (internal != null && internal instanceof ShortNearestNeighboursKDTree) {
					nn = (ShortNearestNeighboursKDTree) internal;
					return;
				}
			}

			nn = new ShortNearestNeighboursKDTree(provider.getCentroids(), ShortNearestNeighboursKDTree.DEFAULT_NTREES, ShortNearestNeighboursKDTree.DEFAULT_NCHECKS);
		}
	}
	
	/**
	 * Construct the assigner using the given cluster data. The assigner
	 * is backed by either a {@link ShortNearestNeighboursExact} or 
	 * {@link ShortNearestNeighboursKDTree}, depending on whether the exact
	 * parameter is true or false. If the parameter is true, then the 
	 * resultant {@link ShortNearestNeighboursExact} will use Euclidean
	 * distance.
	 * 
	 * @param data the cluster data
	 * @param exact if true, then use exact mode; false implies approximate mode.
	 * @param numNeighbours the number of nearest neighbours to select.
	 */
	public ShortKNNAssigner(short[][] data, boolean exact, int numNeighbours) {
		this.numNeighbours = numNeighbours;
		
		if (exact) {
			nn = new ShortNearestNeighboursExact(data);
		} else {
			nn = new ShortNearestNeighboursKDTree(data, ShortNearestNeighboursKDTree.DEFAULT_NTREES, ShortNearestNeighboursKDTree.DEFAULT_NCHECKS);
		}
	}
	
	/**
	 * Construct the assigner using the given cluster data and 
	 * distance function. The assigner will operate in exact mode,
	 * using a {@link ShortNearestNeighboursExact}.
	 * 
	 * @param provider the cluster data provider
	 * @param comparison the distance function
	 * @param numNeighbours the number of nearest neighbours to select.
	 */
	public ShortKNNAssigner(CentroidsProvider<short[]> provider, ShortFVComparison comparison, int numNeighbours) {
		this.numNeighbours = numNeighbours;
		
		nn = new ShortNearestNeighboursExact(provider.getCentroids(), comparison);
	}
	
	/**
	 * Construct the assigner using the given cluster data and 
	 * distance function. The assigner will operate in exact mode,
	 * using a {@link ShortNearestNeighboursExact}.
	 * 
	 * @param data the cluster data
	 * @param comparison the distance function
	 * @param numNeighbours the number of nearest neighbours to select.
	 */
	public ShortKNNAssigner(short[][] data, ShortFVComparison comparison, int numNeighbours) {
		this.numNeighbours = numNeighbours;
		
		nn = new ShortNearestNeighboursExact(data, comparison);
	}

	@Override
	public int[][] assign(short[][] data) {
		int [][] indices = new int [data.length][numNeighbours];
		float [][] distances = new float [data.length][numNeighbours];
		
		nn.searchKNN(data, numNeighbours, indices, distances);
		
		return indices;
	}

	@Override
	public int[] assign(short[] data) {
		return assign(new short[][] { data })[0];
	}

	@Override
	public void assignWeighted(short[][] data, int[][] assignments, float[][] weights) {
		nn.searchKNN(data, numNeighbours, assignments, weights);
	}

	@Override
	public IndependentPair<int[], float[]> assignWeighted(short[] data) {
		int [][] indices = new int [data.length][numNeighbours];
		float [][] distances = new float [data.length][numNeighbours];
		
		nn.searchKNN(new short[][] { data }, numNeighbours, indices, distances);
		
		return new IndependentPair<int[], float[]>(indices[0], distances[0]);
	}
	
	@Override
	public int numDimensions() {
	    return nn.numDimensions();
	}
	
	@Override
	public int size() {
	    return nn.size();
	}
}
