/*
	AUTOMATICALLY GENERATED BY jTemp FROM
	/Users/jsh2/Work/openimaj/target/checkout/machine-learning/clustering/src/main/jtemp/org/openimaj/ml/clustering/assignment/hard/Exact#T#Assigner.jtemp
*/
/**
 * Copyright (c) 2011, The University of Southampton and the individual contributors.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *   * 	Redistributions of source code must retain the above copyright notice,
 * 	this list of conditions and the following disclaimer.
 *
 *   *	Redistributions in binary form must reproduce the above copyright notice,
 * 	this list of conditions and the following disclaimer in the documentation
 * 	and/or other materials provided with the distribution.
 *
 *   *	Neither the name of the University of Southampton nor the names of its
 * 	contributors may be used to endorse or promote products derived from this
 * 	software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.feature.IntFVComparator;
import org.openimaj.knn.IntNearestNeighboursExact;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.util.pair.IntFloatPair;

/**
 * A {@link HardAssigner} that assigns points to the closest
 * cluster based on the distance to the centroid.
 * 
 * @author Jonathon Hare (jsh2@ecs.soton.ac.uk)
 */
public class ExactIntAssigner implements HardAssigner<int[], float[], IntFloatPair> {
	protected IntNearestNeighboursExact nn;
	
	/**
	 * Construct the assigner using the given cluster data. The
	 * distance function defaults to Euclidean.
	 * 
	 * @param provider the cluster data provider
	 */
	public ExactIntAssigner(CentroidsProvider<int[]> provider) {
		this(provider, null);
	}
	
	/**
	 * Construct the assigner using the given cluster data and 
	 * distance function.
	 * 
	 * @param provider the cluster data provider
	 * @param comparison the distance function
	 */
	public ExactIntAssigner(CentroidsProvider<int[]> provider, IntFVComparator comparison) {
		nn = new IntNearestNeighboursExact(provider.getCentroids(), comparison);
	}
	
	/**
	 * Construct the assigner using the given cluster data and 
	 * distance function.
	 * 
	 * @param data the cluster data
	 * @param comparison the distance function
	 */
	public ExactIntAssigner(int[][] data, IntFVComparator comparison) {
		nn = new IntNearestNeighboursExact(data, comparison);
	}
	
	@Override
	public int[] assign(int[][] data) {
		int [] argmins = new int [data.length];
		float [] mins = new float [data.length];
		
		nn.searchNN(data, argmins, mins);
		
		return argmins;
	}

	@Override
	public int assign(int[] data) {
		return assign(new int[][] { data })[0];
	}

	@Override
	public void assignDistance(int[][] data, int[] indices, float[] distances) {
		nn.searchNN(data, indices, distances);
	}

	@Override
	public IntFloatPair assignDistance(int[] data) {
		int [] index = new int [1];
		float [] distance = new float [1];
		
		nn.searchNN(new int[][] { data }, index, distance);
		
		return new IntFloatPair(index[0], distance[0]);
	}
	
	@Override
	public int size() {
	    return nn.size();
	}
	
	@Override
	public int numDimensions() {
	    return nn.numDimensions();
	}
	
	/**
	 * Get the underlying nearest-neighbour implementation.
	 * 
	 * @return the underlying nearest-neighbour implementation.
	 */
	public IntNearestNeighboursExact getNN() {
		return this.nn;
	}
}
