/*
 * Decompiled with CFR 0.152.
 */
package com.jsaragih;

import com.jsaragih.IO;
import com.jsaragih.Tracker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.algorithm.TemplateMatcher;

public class Patch {
    public int _t;
    public double _a;
    public double _b;
    public FImage _W;
    protected FImage im_ = new FImage(0, 0);
    protected TemplateMatcher matcher;

    FImage Grad(FImage im) {
        FImage grad = new FImage(im.width, im.height);
        for (int y = 1; y < im.height - 1; ++y) {
            for (int x = 1; x < im.width - 1; ++x) {
                float vx = im.pixels[y][x + 1] - im.pixels[y][x - 1];
                float vy = im.pixels[y + 1][x] - im.pixels[y - 1][x];
                grad.pixels[y][x] = vx * vx + vy * vy;
            }
        }
        return grad;
    }

    final float SGN(float x) {
        return x < 0.0f ? 0.0f : 1.0f;
    }

    FImage LBP(FImage im) {
        FImage lp = new FImage(im.width, im.height);
        return lp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(String fname) throws FileNotFoundException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fname));
            Scanner sc = new Scanner(br);
            Patch.read(sc, true);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(String fname) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(fname));
            this.write(bw);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    void write(BufferedWriter s) throws IOException {
        s.write(IO.Types.PATCH.ordinal() + " " + this._t + " " + this._a + " " + this._b + " ");
        IO.writeImg(s, this._W);
    }

    static Patch read(Scanner s, boolean readType) {
        if (readType) {
            int type = s.nextInt();
            assert (type == IO.Types.PATCH.ordinal());
        }
        Patch p = new Patch();
        p._t = s.nextInt();
        p._a = s.nextDouble();
        p._b = s.nextDouble();
        p._W = IO.readImg(s);
        p.matcher = new TemplateMatcher(p._W.clone(), TemplateMatcher.Mode.NORM_CORRELATION_COEFFICIENT);
        return p;
    }

    Patch() {
    }

    public Patch(int t, double a, double b, FImage W) {
        this._t = t;
        this._a = a;
        this._b = b;
        this._W = W;
        this.matcher = new TemplateMatcher(W.clone(), TemplateMatcher.Mode.NORM_CORRELATION_COEFFICIENT);
    }

    void response(FImage im, FImage resp) {
        FImage I;
        assert (im.height >= this._W.height && im.width >= this._W.width);
        int h = im.height - this._W.height + 1;
        int w = im.width - this._W.width + 1;
        if (resp.height != h || resp.width != w) {
            resp.internalAssign(new FImage(w, h));
        }
        if (this._t == 0) {
            I = im;
        } else {
            I = this.im_.height == im.height && this.im_.width == im.width ? this.im_ : (this.im_.height >= im.height && this.im_.width >= im.width ? this.im_.extractROI(0, 0, im.width, im.height) : (this.im_ = new FImage(im.width, im.height)));
            if (this._t == 1) {
                I = this.Grad(im);
            } else if (this._t == 2) {
                I = this.LBP(im);
            } else {
                throw new RuntimeException("ERROR: Unsupported patch type!\n");
            }
        }
        this.matcher.analyseImage(I);
        FImage res = this.matcher.getResponseMap();
        for (int y = 0; y < resp.height; ++y) {
            for (int x = 0; x < resp.width; ++x) {
                resp.pixels[y][x] = (float)(1.0 / (1.0 + Math.exp((double)res.pixels[y][x] * this._a + this._b)));
            }
        }
    }

    public Patch copy() {
        return new Patch(this._t, this._a, this._b, this._W);
    }

    static {
        Tracker.init();
    }
}

