/*
 * Decompiled with CFR 0.152.
 */
package com.jsaragih;

import Jama.Matrix;
import com.jsaragih.IO;
import com.jsaragih.Tracker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import org.openimaj.image.FImage;
import org.openimaj.image.processing.transform.RemapProcessor;

public class PAW {
    int _nPix;
    double _xmin;
    double _ymin;
    Matrix _src;
    Matrix _dst;
    int[][] _tri;
    int[][] _tridx;
    FImage _mask;
    Matrix _coeff;
    Matrix _alpha;
    Matrix _beta;
    FImage _mapx;
    FImage _mapy;

    boolean sameSide(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        double x = (x3 - x2) * (y0 - y2) - (x0 - x2) * (y3 - y2);
        double y = (x3 - x2) * (y1 - y2) - (x1 - x2) * (y3 - y2);
        return x * y >= 0.0;
    }

    int isWithinTri(double x, double y, int[][] tri, Matrix shape) {
        int n = tri.length;
        int p = shape.getRowDimension() / 2;
        for (int t = 0; t < n; ++t) {
            double s32;
            double s22;
            int i = tri[t][0];
            int j = tri[t][1];
            int k = tri[t][2];
            double s11 = shape.get(i, 0);
            double s21 = shape.get(j, 0);
            double s31 = shape.get(k, 0);
            double s12 = shape.get(i + p, 0);
            if (!this.sameSide(x, y, s11, s12, s21, s22 = shape.get(j + p, 0), s31, s32 = shape.get(k + p, 0)) || !this.sameSide(x, y, s21, s22, s11, s12, s31, s32) || !this.sameSide(x, y, s31, s32, s11, s12, s21, s22)) continue;
            return t;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PAW load(String fname) throws FileNotFoundException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fname));
            Scanner sc = new Scanner(br);
            PAW pAW = PAW.read(sc, true);
            return pAW;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(String fname) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(fname));
            this.write(bw);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    void write(BufferedWriter s) throws IOException {
        s.write(IO.Types.PAW.ordinal() + " " + this._nPix + " " + this._xmin + " " + this._ymin + " ");
        IO.writeMat(s, this._src);
        IO.writeIntArray(s, this._tri);
        IO.writeIntArray(s, this._tridx);
        IO.writeImg(s, this._mask);
        IO.writeMat(s, this._alpha);
        IO.writeMat(s, this._beta);
    }

    static PAW read(Scanner s, boolean readType) {
        if (readType) {
            int type = s.nextInt();
            assert (type == IO.Types.PAW.ordinal());
        }
        PAW paw = new PAW();
        paw._nPix = s.nextInt();
        paw._xmin = s.nextDouble();
        paw._ymin = s.nextDouble();
        paw._src = IO.readMat(s);
        paw._tri = IO.readIntArray(s);
        paw._tridx = IO.readIntArray(s);
        paw._mask = IO.readImgByte(s);
        paw._alpha = IO.readMat(s);
        paw._beta = IO.readMat(s);
        paw._mapx = new FImage(paw._mask.width, paw._mask.height);
        paw._mapy = new FImage(paw._mask.width, paw._mask.height);
        paw._coeff = new Matrix(paw.nTri(), 6);
        paw._dst = paw._src;
        return paw;
    }

    int nPoints() {
        return this._src.getRowDimension() / 2;
    }

    int nTri() {
        return this._tri.length;
    }

    int width() {
        return this._mask.width;
    }

    int height() {
        return this._mask.height;
    }

    PAW(Matrix src, int[][] tri) {
        double ymin;
        double xmin;
        assert (src.getColumnDimension() == 1);
        assert (tri[0].length == 3);
        this._src = src.copy();
        this._tri = (int[][])tri.clone();
        int n = this.nPoints();
        this._alpha = new Matrix(this.nTri(), 3);
        this._beta = new Matrix(this.nTri(), 3);
        for (int i = 0; i < this.nTri(); ++i) {
            int j = this._tri[i][0];
            int k = this._tri[i][1];
            int l = this._tri[i][2];
            double c1 = this._src.get(l + n, 0) - this._src.get(j + n, 0);
            double c2 = this._src.get(l, 0) - this._src.get(j, 0);
            double c4 = this._src.get(k + n, 0) - this._src.get(j + n, 0);
            double c3 = this._src.get(k, 0) - this._src.get(j, 0);
            double c5 = c3 * c1 - c2 * c4;
            this._alpha.set(i, 0, (this._src.get(j + n, 0) * c2 - this._src.get(j, 0) * c1) / c5);
            this._alpha.set(i, 1, c1 / c5);
            this._alpha.set(i, 2, -c2 / c5);
            this._beta.set(i, 0, (this._src.get(j, 0) * c4 - this._src.get(j + n, 0) * c3) / c5);
            this._beta.set(i, 1, -c4 / c5);
            this._beta.set(i, 2, c3 / c5);
        }
        double xmax = xmin = this._src.get(0, 0);
        double ymax = ymin = this._src.get(n, 0);
        for (int i = 0; i < n; ++i) {
            double vx = this._src.get(i, 0);
            double vy = this._src.get(i + n, 0);
            xmax = Math.max(xmax, vx);
            ymax = Math.max(ymax, vy);
            xmin = Math.min(xmin, vx);
            ymin = Math.min(ymin, vy);
        }
        int w = (int)(xmax - xmin + 1.0);
        int h = (int)(ymax - ymin + 1.0);
        this._mask = new FImage(w, h);
        this._tridx = new int[h][w];
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                int n2 = this.isWithinTri((double)j + xmin, (double)i + ymin, tri, this._src);
                this._tridx[i][j] = n2;
                this._mask.pixels[i][j] = n2 == -1 ? 0.0f : 0.0f;
            }
        }
        this._mapx = new FImage(this._mask.width, this._mask.height);
        this._mapy = new FImage(this._mask.width, this._mask.height);
        this._coeff = new Matrix(this.nTri(), 6);
        this._dst = this._src;
        this._xmin = xmin;
        this._ymin = ymin;
    }

    PAW() {
    }

    void crop(FImage src, FImage dst, Matrix s) {
        assert (s.getRowDimension() == this._src.getRowDimension() && s.getColumnDimension() == 1);
        this._dst = s;
        this.calcCoeff();
        this.warpRegion(this._mapx, this._mapy);
        RemapProcessor.remap((FImage)src, (FImage)dst, (FImage)this._mapx, (FImage)this._mapy);
    }

    void calcCoeff() {
        int p = this.nPoints();
        for (int l = 0; l < this.nTri(); ++l) {
            int i = this._tri[l][0];
            int j = this._tri[l][1];
            int k = this._tri[l][2];
            double c1 = this._dst.get(i, 0);
            double c2 = this._dst.get(j, 0) - c1;
            double c3 = this._dst.get(k, 0) - c1;
            double c4 = this._dst.get(i + p, 0);
            double c5 = this._dst.get(j + p, 0) - c4;
            double c6 = this._dst.get(k + p, 0) - c4;
            double[] coeff = this._coeff.getArray()[l];
            double[] alpha = this._alpha.getArray()[l];
            double[] beta = this._beta.getArray()[l];
            coeff[0] = c1 + c2 * alpha[0] + c3 * beta[0];
            coeff[1] = c2 * alpha[1] + c3 * beta[1];
            coeff[2] = c2 * alpha[2] + c3 * beta[2];
            coeff[3] = c4 + c5 * alpha[0] + c6 * beta[0];
            coeff[4] = c5 * alpha[1] + c6 * beta[1];
            coeff[5] = c5 * alpha[2] + c6 * beta[2];
        }
    }

    void warpRegion(FImage mapx, FImage mapy) {
        if (mapx.height != this._mask.height || mapx.width != this._mask.width) {
            this._mapx.internalAssign(new FImage(this._mask.width, this._mask.height));
        }
        if (mapy.height != this._mask.height || mapy.width != this._mask.width) {
            this._mapy.internalAssign(new FImage(this._mask.width, this._mask.height));
        }
        int k = -1;
        double[] a = null;
        float[][] xp = mapx.pixels;
        float[][] yp = mapy.pixels;
        float[][] mp = this._mask.pixels;
        for (int y = 0; y < this._mask.height; ++y) {
            double yi = (double)y + this._ymin;
            for (int x = 0; x < this._mask.width; ++x) {
                double xi = (double)x + this._xmin;
                if (mp[y][x] == 0.0f) {
                    xp[y][x] = -1.0f;
                    yp[y][x] = -1.0f;
                    continue;
                }
                int j = this._tridx[y][x];
                if (j != k) {
                    a = this._coeff.getArray()[j];
                    k = j;
                }
                double[] ap = a;
                void xo = ap[0];
                xp[y][x] = (float)((xo += ap[1] * xi) + ap[2] * yi);
                double yo = ap[3];
                yp[y][x] = (float)((yo += ap[4] * xi) + ap[5] * yi);
            }
        }
    }

    static {
        Tracker.init();
    }
}

