/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test.referencing;

import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.test.Assert;
import org.opengis.test.ValidatorContainer;
import org.opengis.test.referencing.ReferencingValidator;

public class CSValidator
extends ReferencingValidator {
    public CSValidator(ValidatorContainer validatorContainer) {
        super(validatorContainer, "org.opengis.referencing.cs");
    }

    public void dispatch(CoordinateSystem coordinateSystem) {
        if (coordinateSystem instanceof CartesianCS) {
            this.validate((CartesianCS)coordinateSystem);
        } else if (coordinateSystem instanceof EllipsoidalCS) {
            this.validate((EllipsoidalCS)coordinateSystem);
        } else if (coordinateSystem instanceof SphericalCS) {
            this.validate((SphericalCS)coordinateSystem);
        } else if (coordinateSystem instanceof CylindricalCS) {
            this.validate((CylindricalCS)coordinateSystem);
        } else if (coordinateSystem instanceof PolarCS) {
            this.validate((PolarCS)coordinateSystem);
        } else if (coordinateSystem instanceof LinearCS) {
            this.validate((LinearCS)coordinateSystem);
        } else if (coordinateSystem instanceof VerticalCS) {
            this.validate((VerticalCS)coordinateSystem);
        } else if (coordinateSystem instanceof TimeCS) {
            this.validate((TimeCS)coordinateSystem);
        } else if (coordinateSystem instanceof UserDefinedCS) {
            this.validate((UserDefinedCS)coordinateSystem);
        } else if (coordinateSystem != null) {
            this.validateIdentifiedObject((IdentifiedObject)coordinateSystem);
            this.validateAxes(coordinateSystem);
        }
    }

    public void validate(CoordinateSystemAxis coordinateSystemAxis) {
        if (coordinateSystemAxis == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)coordinateSystemAxis);
        Assert.assertValidRange("CoordinateSystemAxis: expected maximum >= minimum.", coordinateSystemAxis.getMinimumValue(), coordinateSystemAxis.getMaximumValue());
    }

    public void validate(CartesianCS cartesianCS) {
        if (cartesianCS == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)cartesianCS);
        this.validateAxes((CoordinateSystem)cartesianCS);
    }

    public void validate(EllipsoidalCS ellipsoidalCS) {
        if (ellipsoidalCS == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)ellipsoidalCS);
        this.validateAxes((CoordinateSystem)ellipsoidalCS);
        int n = ellipsoidalCS.getDimension();
        Assert.assertBetween("EllipsoidalCS: wrong number of dimensions.", 2, 3, n);
    }

    public void validate(SphericalCS sphericalCS) {
        if (sphericalCS == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)sphericalCS);
        this.validateAxes((CoordinateSystem)sphericalCS);
        int n = sphericalCS.getDimension();
        Assert.assertEquals((String)"SphericalCS: wrong number of dimensions.", (long)3L, (long)n);
    }

    public void validate(CylindricalCS cylindricalCS) {
        if (cylindricalCS == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)cylindricalCS);
        this.validateAxes((CoordinateSystem)cylindricalCS);
        int n = cylindricalCS.getDimension();
        Assert.assertEquals((String)"CylindricalCS: wrong number of dimensions.", (long)3L, (long)n);
    }

    public void validate(PolarCS polarCS) {
        if (polarCS == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)polarCS);
        this.validateAxes((CoordinateSystem)polarCS);
        int n = polarCS.getDimension();
        Assert.assertEquals((String)"PolarCS: wrong number of dimensions.", (long)2L, (long)n);
    }

    public void validate(LinearCS linearCS) {
        if (linearCS == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)linearCS);
        this.validateAxes((CoordinateSystem)linearCS);
        int n = linearCS.getDimension();
        Assert.assertEquals((String)"LinearCS: wrong number of dimensions.", (long)1L, (long)n);
    }

    public void validate(VerticalCS verticalCS) {
        if (verticalCS == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)verticalCS);
        this.validateAxes((CoordinateSystem)verticalCS);
        int n = verticalCS.getDimension();
        Assert.assertEquals((String)"VerticalCS: wrong number of dimensions.", (long)1L, (long)n);
    }

    public void validate(TimeCS timeCS) {
        if (timeCS == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)timeCS);
        this.validateAxes((CoordinateSystem)timeCS);
        int n = timeCS.getDimension();
        Assert.assertEquals((String)"TimeCS: wrong number of dimensions.", (long)1L, (long)n);
    }

    public void validate(UserDefinedCS userDefinedCS) {
        if (userDefinedCS == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)userDefinedCS);
        this.validateAxes((CoordinateSystem)userDefinedCS);
        int n = userDefinedCS.getDimension();
        Assert.assertBetween("UserDefinedCS: wrong number of dimensions.", 2, 3, n);
    }

    private void validateAxes(CoordinateSystem coordinateSystem) {
        int n = coordinateSystem.getDimension();
        Assert.assertStrictlyPositive("CoordinateSystem: dimension must be greater than zero.", n);
        for (int i = 0; i < n; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            this.mandatory("CoordinateSystem: axis can't be null.", coordinateSystemAxis);
            this.validate(coordinateSystemAxis);
        }
    }
}

