/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class PipelineRecordingParameters {
    public final String path;
    public final Encoder encoder;
    public final OutputFormat outputFormat;
    public final int bitrate;
    public final int frameRate;

    public PipelineRecordingParameters(OutputFormat outputFormat, Encoder encoder, int frameRate, int bitrate, String path) {
        this.outputFormat = outputFormat;
        this.encoder = encoder;
        this.frameRate = frameRate;
        this.bitrate = bitrate;
        this.path = path;
    }

    public static enum OutputFormat {
        MPEG_4(2),
        THREE_GPP(1),
        WEBM(9);

        final int format;

        private OutputFormat(int format) {
            this.format = format;
        }
    }

    public static enum Encoder {
        H264(2),
        H263(1),
        VP8(4),
        MPEG_4_SP(3);

        final int format;

        private Encoder(int format) {
            this.format = format;
        }
    }

    public static class Builder {
        private String path = "/sdcard/EasyOpenCV/pipeline_recording_" + new SimpleDateFormat("dd-MM-yyyy_HH:mm:ss", Locale.getDefault()).format(new Date()) + ".mp4";
        private Encoder encoder = Encoder.H264;
        private OutputFormat outputFormat = OutputFormat.MPEG_4;
        private int bitrate = 4000000;
        private int frameRate = 30;

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setEncoder(Encoder encoder) {
            this.encoder = encoder;
            return this;
        }

        public Builder setOutputFormat(OutputFormat outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public Builder setBitrate(int bitrate, BitrateUnits units) {
            this.bitrate = bitrate * units.scalar;
            return this;
        }

        public Builder setFrameRate(int frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public PipelineRecordingParameters build() {
            return new PipelineRecordingParameters(this.outputFormat, this.encoder, this.frameRate, this.bitrate, this.path);
        }
    }

    public static enum BitrateUnits {
        bps(1),
        Kbps(1000),
        Mbps(1000000);

        final int scalar;

        private BitrateUnits(int scalar) {
            this.scalar = scalar;
        }
    }
}

