/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import com.qualcomm.robotcore.util.Device;
import org.opencv.android.Utils;
import org.opencv.core.Mat;
import org.openftc.easyopencv.OpenCvCamera;
import org.openftc.easyopencv.OpenCvViewport;

public class OpenCvViewRenderer {
    private final int statBoxW;
    private final int statBoxH;
    private final int statBoxTextLineSpacing;
    private final int statBoxTextFirstLineYFromBottomOffset;
    private final int statBoxLTxtMargin;
    private static final float referenceDPI = 443.0f;
    private final float metricsScale;
    private static final int OVERLAY_COLOR = Color.rgb((int)102, (int)20, (int)68);
    private static final int PAUSED_COLOR = Color.rgb((int)255, (int)166, (int)0);
    private static final int RC_ACTIVITY_BG_COLOR = Color.rgb((int)239, (int)239, (int)239);
    private Paint fpsMeterNormalBgPaint;
    private Paint fpsMeterRecordingPaint;
    private Paint fpsMeterTextPaint;
    private final float fpsMeterTextSize;
    private Paint paintBlackBackground;
    private double aspectRatio;
    private boolean fpsMeterEnabled = true;
    private float fps = 0.0f;
    private int pipelineMs = 0;
    private int overheadMs = 0;
    private int width;
    private int height;
    private final boolean offscreen;
    private volatile boolean isRecording;
    private volatile OpenCvViewport.OptimizedRotation optimizedViewRotation;
    private volatile OpenCvCamera.ViewportRenderingPolicy renderingPolicy = OpenCvCamera.ViewportRenderingPolicy.MAXIMIZE_EFFICIENCY;
    private Bitmap bitmapFromMat;

    public OpenCvViewRenderer(Context context, boolean renderingOffsceen) {
        this.offscreen = renderingOffsceen;
        this.metricsScale = this.offscreen ? 1.0f : (Device.isRevControlHub() ? 0.5f : context.getResources().getDisplayMetrics().xdpi / 443.0f);
        this.fpsMeterTextSize = 30.0f * this.metricsScale;
        this.statBoxW = (int)(450.0f * this.metricsScale);
        this.statBoxH = (int)(120.0f * this.metricsScale);
        this.statBoxTextLineSpacing = (int)(35.0f * this.metricsScale);
        this.statBoxLTxtMargin = (int)(5.0f * this.metricsScale);
        this.statBoxTextFirstLineYFromBottomOffset = (int)(80.0f * this.metricsScale);
        this.fpsMeterNormalBgPaint = new Paint();
        this.fpsMeterNormalBgPaint.setColor(OVERLAY_COLOR);
        this.fpsMeterNormalBgPaint.setStyle(Paint.Style.FILL);
        this.fpsMeterRecordingPaint = new Paint();
        this.fpsMeterRecordingPaint.setColor(-65536);
        this.fpsMeterRecordingPaint.setStyle(Paint.Style.FILL);
        this.fpsMeterTextPaint = new Paint();
        this.fpsMeterTextPaint.setColor(-1);
        this.fpsMeterTextPaint.setTextSize(this.fpsMeterTextSize);
        this.fpsMeterTextPaint.setAntiAlias(true);
        this.paintBlackBackground = new Paint();
        this.paintBlackBackground.setColor(-16777216);
        this.paintBlackBackground.setStyle(Paint.Style.FILL);
    }

    private void unifiedDraw(Canvas canvas, int onscreenWidth, int onscreenHeight, OpenCvViewport.RenderHook userHook, Object userCtx) {
        int topLeftX;
        int topLeftY;
        int scaledHeight;
        int scaledWidth;
        int x_offset_statbox = 0;
        int y_offset_statbox = 0;
        double canvasAspect = (float)onscreenWidth / (float)onscreenHeight;
        if (this.aspectRatio > canvasAspect) {
            scaledWidth = onscreenWidth;
            scaledHeight = (int)Math.round((double)onscreenWidth / this.aspectRatio);
            topLeftY = Math.abs(onscreenHeight - scaledHeight) / 2;
            topLeftX = 0;
            y_offset_statbox = topLeftY;
        } else {
            scaledHeight = onscreenHeight;
            scaledWidth = (int)Math.round((double)onscreenHeight * this.aspectRatio);
            topLeftY = 0;
            x_offset_statbox = topLeftX = Math.abs(onscreenWidth - scaledWidth) / 2;
        }
        Rect bmpRect = this.createRect(topLeftX, topLeftY, scaledWidth, scaledHeight);
        canvas.drawRect(bmpRect, this.paintBlackBackground);
        canvas.drawBitmap(this.bitmapFromMat, null, bmpRect, null);
        int canvasSaveBeforeUserDraw = canvas.save();
        if (userHook != null) {
            float scaleBitmapPxToCanvasPx = (float)scaledWidth / (float)this.bitmapFromMat.getWidth();
            canvas.translate((float)topLeftX, (float)topLeftY);
            userHook.onDrawFrame(canvas, scaledWidth, scaledHeight, scaleBitmapPxToCanvasPx, this.metricsScale, userCtx);
        }
        canvas.restoreToCount(canvasSaveBeforeUserDraw);
        if (this.fpsMeterEnabled) {
            Rect statsRect = this.createRect(x_offset_statbox, onscreenHeight - y_offset_statbox - this.statBoxH, this.statBoxW, this.statBoxH);
            this.drawStats(canvas, statsRect);
        }
    }

    private void drawStats(Canvas canvas, Rect rect) {
        if (this.isRecording) {
            canvas.drawRect(rect, this.fpsMeterRecordingPaint);
        } else {
            canvas.drawRect(rect, this.fpsMeterNormalBgPaint);
        }
        int statBoxLTxtStart = rect.left + this.statBoxLTxtMargin;
        int textLine1Y = rect.bottom - this.statBoxTextFirstLineYFromBottomOffset;
        int textLine2Y = textLine1Y + this.statBoxTextLineSpacing;
        int textLine3Y = textLine2Y + this.statBoxTextLineSpacing;
        canvas.drawText(String.format("OpenFTC EasyOpenCV v%s", "1.7.3"), (float)statBoxLTxtStart, (float)textLine1Y, this.fpsMeterTextPaint);
        canvas.drawText(String.format("FPS@%dx%d: %.2f", this.width, this.height, Float.valueOf(this.fps)), (float)statBoxLTxtStart, (float)textLine2Y, this.fpsMeterTextPaint);
        canvas.drawText(String.format("Pipeline: %dms - Overhead: %dms", this.pipelineMs, this.overheadMs), (float)statBoxLTxtStart, (float)textLine3Y, this.fpsMeterTextPaint);
    }

    Rect createRect(int tlx, int tly, int w, int h) {
        return new Rect(tlx, tly, tlx + w, tly + h);
    }

    public void setFpsMeterEnabled(boolean fpsMeterEnabled) {
        this.fpsMeterEnabled = fpsMeterEnabled;
    }

    public void notifyStatistics(float fps, int pipelineMs, int overheadMs) {
        this.fps = fps;
        this.pipelineMs = pipelineMs;
        this.overheadMs = overheadMs;
    }

    public void setRecording(boolean recording) {
        this.isRecording = recording;
    }

    public void setOptimizedViewRotation(OpenCvViewport.OptimizedRotation optimizedViewRotation) {
        this.optimizedViewRotation = optimizedViewRotation;
    }

    public void render(Mat mat, Canvas canvas, OpenCvViewport.RenderHook userHook, Object userCtx) {
        if (this.bitmapFromMat == null || this.bitmapFromMat.getWidth() != mat.width() || this.bitmapFromMat.getHeight() != mat.height()) {
            if (this.bitmapFromMat != null) {
                this.bitmapFromMat.recycle();
            }
            this.bitmapFromMat = Bitmap.createBitmap((int)mat.width(), (int)mat.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Utils.matToBitmap((Mat)mat, (Bitmap)this.bitmapFromMat);
        this.width = this.bitmapFromMat.getWidth();
        this.height = this.bitmapFromMat.getHeight();
        this.aspectRatio = (float)this.width / (float)this.height;
        if (!this.offscreen) {
            canvas.drawColor(RC_ACTIVITY_BG_COLOR);
        }
        OpenCvViewport.OptimizedRotation optimizedRotationSafe = this.optimizedViewRotation;
        if (this.renderingPolicy == OpenCvCamera.ViewportRenderingPolicy.MAXIMIZE_EFFICIENCY || optimizedRotationSafe == OpenCvViewport.OptimizedRotation.NONE) {
            this.unifiedDraw(canvas, canvas.getWidth(), canvas.getHeight(), userHook, userCtx);
        } else if (this.renderingPolicy == OpenCvCamera.ViewportRenderingPolicy.OPTIMIZE_VIEW) {
            if (optimizedRotationSafe == OpenCvViewport.OptimizedRotation.ROT_180) {
                canvas.rotate((float)optimizedRotationSafe.val, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
                this.unifiedDraw(canvas, canvas.getWidth(), canvas.getHeight(), userHook, userCtx);
            } else {
                canvas.rotate((float)optimizedRotationSafe.val, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
                int origin_x = (canvas.getWidth() - canvas.getHeight()) / 2;
                int origin_y = -origin_x;
                canvas.translate((float)origin_x, (float)origin_y);
                this.unifiedDraw(canvas, canvas.getHeight(), canvas.getWidth(), userHook, userCtx);
            }
        }
    }

    public void setRenderingPolicy(OpenCvCamera.ViewportRenderingPolicy policy) {
        this.renderingPolicy = policy;
    }

    public void renderPaused(Canvas canvas) {
        canvas.drawColor(PAUSED_COLOR);
        Rect rect = this.createRect(0, canvas.getHeight() - this.statBoxH, this.statBoxW, this.statBoxH);
        canvas.drawRect(rect, this.fpsMeterNormalBgPaint);
        int statBoxLTxtStart = rect.left + this.statBoxLTxtMargin;
        int textLine1Y = rect.bottom - this.statBoxTextFirstLineYFromBottomOffset;
        int textLine2Y = textLine1Y + this.statBoxTextLineSpacing;
        int textLine3Y = textLine2Y + this.statBoxTextLineSpacing;
        canvas.drawText(String.format("OpenFTC EasyOpenCV v%s", "1.7.3"), (float)statBoxLTxtStart, (float)textLine1Y, this.fpsMeterTextPaint);
        canvas.drawText("VIEWPORT PAUSED", (float)statBoxLTxtStart, (float)textLine2Y, this.fpsMeterTextPaint);
    }
}

