/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import android.content.Context;
import android.graphics.Canvas;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import java.util.concurrent.ArrayBlockingQueue;
import org.firstinspires.ftc.robotcore.external.function.Consumer;
import org.firstinspires.ftc.robotcore.internal.collections.EvictingBlockingQueue;
import org.opencv.core.Mat;
import org.openftc.easyopencv.MatRecycler;
import org.openftc.easyopencv.OpenCvCamera;
import org.openftc.easyopencv.OpenCvViewRenderer;
import org.openftc.easyopencv.OpenCvViewport;
import org.openftc.easyopencv.Util;

public class OpenCvSurfaceViewViewport
extends SurfaceView
implements SurfaceHolder.Callback,
OpenCvViewport {
    private RenderThread renderThread;
    private static final int VISION_PREVIEW_FRAME_QUEUE_CAPACITY = 2;
    private static final int FRAMEBUFFER_RECYCLER_CAPACITY = 4;
    private final EvictingBlockingQueue<MatRecycler.RecyclableMat> visionPreviewFrameQueue = new EvictingBlockingQueue(new ArrayBlockingQueue(2));
    private MatRecycler framebufferRecycler;
    private volatile RenderingState internalRenderingState = RenderingState.STOPPED;
    private final Object syncObj = new Object();
    private volatile boolean userRequestedActive = false;
    private volatile boolean userRequestedPause = false;
    private boolean needToDeactivateRegardlessOfUser = false;
    private boolean surfaceExistsAndIsReady = false;
    private volatile boolean useGpuCanvas;
    private final OpenCvViewRenderer renderer;
    private volatile OpenCvViewport.RenderHook renderHook;
    private String TAG = "OpenCvViewport";

    public OpenCvSurfaceViewViewport(Context context, View.OnClickListener onClickListener) {
        super(context);
        this.renderer = new OpenCvViewRenderer(context, false);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.visionPreviewFrameQueue.setEvictAction((Consumer)new Consumer<MatRecycler.RecyclableMat>(){

            public void accept(MatRecycler.RecyclableMat value) {
                OpenCvSurfaceViewViewport.this.framebufferRecycler.returnMat(value);
            }
        });
        this.setOnClickListener(onClickListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseGpuCanvas(boolean useGpuCanvas) throws IllegalStateException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.internalRenderingState != RenderingState.STOPPED) {
                throw new IllegalStateException();
            }
            this.useGpuCanvas = useGpuCanvas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSize(int width, int height) {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.internalRenderingState != RenderingState.STOPPED) {
                throw new IllegalStateException("Cannot set size while renderer is active!");
            }
            this.visionPreviewFrameQueue.clear();
            this.framebufferRecycler = new MatRecycler(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void post(Mat mat, Object context) {
        Object object = this.syncObj;
        synchronized (object) {
            if (mat == null) {
                throw new IllegalArgumentException("cannot post null mat!");
            }
            if (this.internalRenderingState == RenderingState.ACTIVE) {
                try {
                    MatRecycler.RecyclableMat matToCopyTo = this.framebufferRecycler.takeMat();
                    mat.copyTo((Mat)matToCopyTo);
                    matToCopyTo.setContext(context);
                    this.visionPreviewFrameQueue.offer((Object)matToCopyTo);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public void checkState() {
        if (!this.surfaceExistsAndIsReady) {
            Log.d((String)this.TAG, (String)"CheckState(): surface not ready or doesn't exist");
            return;
        }
        if (!this.userRequestedActive || this.needToDeactivateRegardlessOfUser) {
            if (this.needToDeactivateRegardlessOfUser) {
                Log.d((String)this.TAG, (String)"CheckState(): lifecycle mandates deactivation regardless of user");
            } else {
                Log.d((String)this.TAG, (String)"CheckState(): user requested that we deactivate");
            }
            if (this.internalRenderingState != RenderingState.STOPPED) {
                Log.d((String)this.TAG, (String)"CheckState(): deactivating viewport");
                this.renderThread.notifyExitRequested();
                this.renderThread.interrupt();
                Util.joinUninterruptibly(this.renderThread);
                this.internalRenderingState = RenderingState.STOPPED;
            } else {
                Log.d((String)this.TAG, (String)"CheckState(): already deactivated");
            }
        } else if (this.userRequestedActive) {
            Log.d((String)this.TAG, (String)"CheckState(): user requested that we activate");
            if (this.internalRenderingState == RenderingState.STOPPED) {
                Log.d((String)this.TAG, (String)"CheckState(): activating viewport");
                this.internalRenderingState = RenderingState.PAUSED;
                this.internalRenderingState = this.userRequestedPause ? RenderingState.PAUSED : RenderingState.ACTIVE;
                this.renderThread = new RenderThread();
                this.renderThread.start();
            } else {
                Log.d((String)this.TAG, (String)"CheckState(): already activated");
            }
        }
        if (this.internalRenderingState != RenderingState.STOPPED && (this.userRequestedPause && this.internalRenderingState != RenderingState.PAUSED || !this.userRequestedPause && this.internalRenderingState != RenderingState.ACTIVE)) {
            if (this.userRequestedPause) {
                Log.d((String)this.TAG, (String)"CheckState(): pausing viewport");
                this.internalRenderingState = RenderingState.PAUSED;
            } else {
                Log.d((String)this.TAG, (String)"CheckState(): resuming viewport");
                this.internalRenderingState = RenderingState.ACTIVE;
            }
            this.renderThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void activate() {
        Object object = this.syncObj;
        synchronized (object) {
            this.userRequestedActive = true;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate() {
        Object object = this.syncObj;
        synchronized (object) {
            this.userRequestedActive = false;
            this.checkState();
        }
    }

    @Override
    public void setOptimizedViewRotation(OpenCvViewport.OptimizedRotation rotation) {
        this.renderer.setOptimizedViewRotation(rotation);
    }

    @Override
    public void notifyStatistics(float fps, int pipelineMs, int overheadMs) {
        this.renderer.notifyStatistics(fps, pipelineMs, overheadMs);
    }

    @Override
    public void setRecording(boolean recording) {
        this.renderer.setRecording(recording);
    }

    @Override
    public void setFpsMeterEnabled(boolean enabled) {
        this.renderer.setFpsMeterEnabled(enabled);
    }

    @Override
    public void setRenderingPolicy(OpenCvCamera.ViewportRenderingPolicy policy) {
        this.renderer.setRenderingPolicy(policy);
    }

    @Override
    public void setRenderHook(OpenCvViewport.RenderHook renderHook) {
        this.renderHook = renderHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.syncObj;
        synchronized (object) {
            this.userRequestedPause = false;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.syncObj;
        synchronized (object) {
            this.userRequestedPause = true;
            this.checkState();
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Log.d((String)this.TAG, (String)"surfaceCreated()");
        Log.d((String)this.TAG, (String)"...surfaceCreated()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.d((String)this.TAG, (String)"surfaceChanged()");
        Object object = this.syncObj;
        synchronized (object) {
            this.needToDeactivateRegardlessOfUser = false;
            this.surfaceExistsAndIsReady = true;
            this.checkState();
        }
        Log.d((String)this.TAG, (String)"...surfaceChanged()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceDestroyed(SurfaceHolder holder) {
        Log.d((String)this.TAG, (String)"surfaceDestroyed()");
        Object object = this.syncObj;
        synchronized (object) {
            this.needToDeactivateRegardlessOfUser = true;
            this.checkState();
            this.surfaceExistsAndIsReady = false;
        }
        Log.d((String)this.TAG, (String)"...surfaceDestroyed()");
    }

    private static enum RenderingState {
        STOPPED,
        ACTIVE,
        PAUSED;

    }

    class RenderThread
    extends Thread {
        boolean shouldPaintOrange = true;
        volatile boolean exitRequested = false;
        private String TAG = "OpenCvViewportRenderThread";

        RenderThread() {
        }

        public void notifyExitRequested() {
            this.exitRequested = true;
        }

        private Canvas lockCanvas() {
            if (OpenCvSurfaceViewViewport.this.useGpuCanvas) {
                return OpenCvSurfaceViewViewport.this.getHolder().getSurface().lockHardwareCanvas();
            }
            return OpenCvSurfaceViewViewport.this.getHolder().lockCanvas();
        }

        private void swapBuffer(Canvas canvas) {
            if (OpenCvSurfaceViewViewport.this.useGpuCanvas) {
                OpenCvSurfaceViewViewport.this.getHolder().getSurface().unlockCanvasAndPost(canvas);
            } else {
                OpenCvSurfaceViewViewport.this.getHolder().unlockCanvasAndPost(canvas);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = OpenCvSurfaceViewViewport.this.syncObj;
            synchronized (object) {
                for (MatRecycler.RecyclableMat mat : OpenCvSurfaceViewViewport.this.visionPreviewFrameQueue) {
                    OpenCvSurfaceViewViewport.this.framebufferRecycler.returnMat(mat);
                }
                OpenCvSurfaceViewViewport.this.visionPreviewFrameQueue.clear();
            }
            Log.d((String)this.TAG, (String)"Render thread is up!");
            Canvas canvas = this.lockCanvas();
            canvas.drawColor(-16776961);
            this.swapBuffer(canvas);
            while (!this.exitRequested) {
                switch (OpenCvSurfaceViewViewport.this.internalRenderingState) {
                    case ACTIVE: {
                        MatRecycler.RecyclableMat mat;
                        this.shouldPaintOrange = true;
                        try {
                            mat = (MatRecycler.RecyclableMat)((Object)OpenCvSurfaceViewViewport.this.visionPreviewFrameQueue.take());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            break;
                        }
                        canvas = this.lockCanvas();
                        if (canvas != null) {
                            OpenCvSurfaceViewViewport.this.renderer.render(mat, canvas, OpenCvSurfaceViewViewport.this.renderHook, mat.getContext());
                            this.swapBuffer(canvas);
                        } else {
                            Log.d((String)this.TAG, (String)"Canvas was null");
                        }
                        OpenCvSurfaceViewViewport.this.framebufferRecycler.returnMat(mat);
                        break;
                    }
                    case PAUSED: {
                        if (this.shouldPaintOrange) {
                            this.shouldPaintOrange = false;
                            canvas = this.lockCanvas();
                            if (canvas != null) {
                                OpenCvSurfaceViewViewport.this.renderer.renderPaused(canvas);
                                this.swapBuffer(canvas);
                            }
                        }
                        try {
                            Thread.sleep(50L);
                            break;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            Log.d((String)this.TAG, (String)"About to exit");
        }
    }
}

