/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import android.app.Activity;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.media.MediaCodec;
import android.media.MediaRecorder;
import android.util.Log;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.qualcomm.robotcore.eventloop.opmode.OpMode;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerImpl;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerNotifier;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.ElapsedTime;
import com.qualcomm.robotcore.util.GlobalWarningSource;
import com.qualcomm.robotcore.util.MovingStatistics;
import com.qualcomm.robotcore.util.RobotLog;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.firstinspires.ftc.robotcore.external.android.util.Size;
import org.firstinspires.ftc.robotcore.external.function.Consumer;
import org.firstinspires.ftc.robotcore.external.function.Continuation;
import org.firstinspires.ftc.robotcore.external.function.ContinuationResult;
import org.firstinspires.ftc.robotcore.external.stream.CameraStreamServer;
import org.firstinspires.ftc.robotcore.external.stream.CameraStreamSource;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.opencv.android.Utils;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;
import org.openftc.easyopencv.LIFO_OpModeCallbackDelegate;
import org.openftc.easyopencv.OpenCvCamera;
import org.openftc.easyopencv.OpenCvCameraException;
import org.openftc.easyopencv.OpenCvCameraRotation;
import org.openftc.easyopencv.OpenCvNativeViewViewport;
import org.openftc.easyopencv.OpenCvPipeline;
import org.openftc.easyopencv.OpenCvSurfaceViewViewport;
import org.openftc.easyopencv.OpenCvViewRenderer;
import org.openftc.easyopencv.OpenCvViewport;
import org.openftc.easyopencv.PipelineRecordingParameters;
import org.openftc.easyopencv.TimestampedOpenCvPipeline;

public abstract class OpenCvCameraBase
implements OpenCvCamera,
CameraStreamSource,
GlobalWarningSource {
    private OpenCvPipeline pipeline = null;
    private LinearLayout viewportContainerLayout;
    private MovingStatistics msFrameIntervalRollingAverage;
    private MovingStatistics msUserPipelineRollingAverage;
    private MovingStatistics msTotalFrameProcessingTimeRollingAverage;
    private ElapsedTime timer;
    private OpenCvViewport viewport;
    private int containerLayoutId;
    private OpenCvCameraRotation rotation;
    private int frameCount = 0;
    private float avgFps;
    private int avgPipelineTime;
    private int avgOverheadTime;
    private int avgTotalFrameTime;
    private long currentFrameStartTime;
    private final Object bitmapFrameLock = new Object();
    private Continuation<? extends Consumer<Bitmap>> bitmapContinuation;
    private Mat rotatedMat = new Mat();
    private Mat matToUseIfPipelineReturnedCropped;
    private Mat croppedColorCvtedMat = new Mat();
    private Scalar brown = new Scalar(82.0, 61.0, 46.0, 255.0);
    private OpModeNotificationsForOrientation opModeNotificationsForOrientation = new OpModeNotificationsForOrientation();
    private ComponentCallbacksForRotation componentCallbacksForRotation = new ComponentCallbacksForRotation();
    private volatile boolean hasBeenCleanedUp = false;
    private final Object pipelineChangeLock = new Object();
    private final Object viewportLock = new Object();
    private MediaRecorder mediaRecorder;
    private Surface mediaRecorderSurface;
    private long mediaRecorderSurfaceNativeHandle;
    private int width;
    private int height;
    OpenCvCamera.ViewportRenderer desiredViewportRenderer = OpenCvCamera.ViewportRenderer.SOFTWARE;
    OpenCvCamera.ViewportRenderingPolicy desiredRenderingPolicy = OpenCvCamera.ViewportRenderingPolicy.MAXIMIZE_EFFICIENCY;
    boolean fpsMeterDesired = true;
    private OpModeNotifications opModeNotifications = new OpModeNotifications();

    public OpenCvCameraBase() {
        System.out.println("OpenCvCameraBase ctor: EasyOpenCV version 1.7.3");
        this.frameCount = 0;
        LIFO_OpModeCallbackDelegate.getInstance().add(this.opModeNotifications);
        RobotLog.registerGlobalWarningSource((GlobalWarningSource)this);
        CameraStreamServer.getInstance().setSource((CameraStreamSource)this);
    }

    public OpenCvCameraBase(int containerLayoutId) {
        this();
        this.containerLayoutId = containerLayoutId;
        AppUtil.getInstance().getApplication().registerComponentCallbacks((ComponentCallbacks)this.componentCallbacksForRotation);
        OpModeManagerImpl.getOpModeManagerOfActivity((Activity)AppUtil.getInstance().getActivity()).registerListener((OpModeManagerNotifier.Notifications)this.opModeNotificationsForOrientation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanupForClosingCamera() {
        Object object = this.viewportLock;
        synchronized (object) {
            if (this.viewport != null) {
                this.removeViewportAsync((View)this.viewport);
                this.viewport = null;
            }
        }
    }

    public synchronized boolean hasBeenCleanedUp() {
        return this.hasBeenCleanedUp;
    }

    public final synchronized void prepareForOpenCameraDevice() {
        if (this.containerLayoutId != 0 && this.viewport == null) {
            this.setupViewport(this.containerLayoutId);
            this.viewport.setRenderingPolicy(this.desiredRenderingPolicy);
        }
    }

    public final synchronized void prepareForStartStreaming(int width, int height, OpenCvCameraRotation rotation) {
        this.rotation = rotation;
        this.msFrameIntervalRollingAverage = new MovingStatistics(30);
        this.msUserPipelineRollingAverage = new MovingStatistics(30);
        this.msTotalFrameProcessingTimeRollingAverage = new MovingStatistics(30);
        this.timer = new ElapsedTime();
        Size sizeAfterRotation = this.getFrameSizeAfterRotation(width, height, rotation);
        this.width = sizeAfterRotation.getWidth();
        this.height = sizeAfterRotation.getHeight();
        if (this.viewport != null) {
            this.viewport.setSize(width, height);
            this.viewport.setOptimizedViewRotation(this.getOptimizedViewportRotation(rotation, AppUtil.getInstance().getActivity().getWindowManager().getDefaultDisplay().getRotation()));
            this.viewport.activate();
        }
    }

    public final synchronized void cleanupForEndStreaming() {
        if (this.mediaRecorder != null) {
            this.stopRecordingPipeline();
        }
        this.matToUseIfPipelineReturnedCropped = null;
        if (this.viewport != null) {
            this.viewport.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void pauseViewport() {
        Object object = this.viewportLock;
        synchronized (object) {
            if (this.viewport != null) {
                this.viewport.pause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void resumeViewport() {
        Object object = this.viewportLock;
        synchronized (object) {
            if (this.viewport != null) {
                this.viewport.resume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void showFpsMeterOnViewport(boolean show) {
        Object object = this.viewportLock;
        synchronized (object) {
            this.fpsMeterDesired = show;
            if (this.viewport != null) {
                this.viewport.setFpsMeterEnabled(show);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPipeline(OpenCvPipeline pipeline) {
        Object object = this.pipelineChangeLock;
        synchronized (object) {
            this.pipeline = pipeline;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupViewport(final int containerLayoutId) {
        final CountDownLatch latch = new CountDownLatch(1);
        final RuntimeException[] exToRethrowOnOpModeThread = new RuntimeException[]{null};
        AppUtil.getInstance().getActivity().runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    OpenCvCameraBase.this.viewportContainerLayout = (LinearLayout)AppUtil.getInstance().getActivity().findViewById(containerLayoutId);
                    if (OpenCvCameraBase.this.viewportContainerLayout == null) {
                        throw new OpenCvCameraException("Viewport container specified by user does not exist!");
                    }
                    if (OpenCvCameraBase.this.viewportContainerLayout.getChildCount() != 0) {
                        throw new OpenCvCameraException("Viewport container specified by user is not empty!");
                    }
                    View.OnClickListener onClickListener = new View.OnClickListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onClick(View v) {
                            Object object = OpenCvCameraBase.this.pipelineChangeLock;
                            synchronized (object) {
                                if (OpenCvCameraBase.this.pipeline != null) {
                                    OpenCvCameraBase.this.pipeline.onViewportTapped();
                                }
                            }
                        }
                    };
                    Object object = OpenCvCameraBase.this.viewportLock;
                    synchronized (object) {
                        switch (OpenCvCameraBase.this.desiredViewportRenderer) {
                            case SOFTWARE: 
                            case GPU_ACCELERATED: {
                                OpenCvCameraBase.this.viewport = new OpenCvSurfaceViewViewport((Context)AppUtil.getInstance().getActivity(), onClickListener);
                                ((OpenCvSurfaceViewViewport)OpenCvCameraBase.this.viewport).setUseGpuCanvas(OpenCvCameraBase.this.desiredViewportRenderer == OpenCvCamera.ViewportRenderer.GPU_ACCELERATED);
                                break;
                            }
                            case NATIVE_VIEW: {
                                OpenCvCameraBase.this.viewport = new OpenCvNativeViewViewport((Context)AppUtil.getInstance().getActivity(), onClickListener);
                            }
                        }
                        OpenCvCameraBase.this.viewport.setFpsMeterEnabled(OpenCvCameraBase.this.fpsMeterDesired);
                        OpenCvCameraBase.this.viewport.setRenderHook(new OpenCvViewport.RenderHook(){

                            @Override
                            public void onDrawFrame(Canvas canvas, int onscreenWidth, int onscreenHeight, float scaleBmpPxToCanvasPx, float scaleCanvasDensity, Object context) {
                                OpenCvViewport.FrameContext frameContext = (OpenCvViewport.FrameContext)context;
                                if (frameContext.generatingPipeline != null) {
                                    try {
                                        frameContext.generatingPipeline.onDrawFrame(canvas, onscreenWidth, onscreenHeight, scaleBmpPxToCanvasPx, scaleCanvasDensity, frameContext.userContext);
                                    }
                                    catch (Exception e) {
                                        OpenCvCameraBase.this.emulateEStop(e);
                                    }
                                }
                            }
                        });
                        OpenCvCameraBase.this.viewport.setSize(320, 240);
                        ((View)OpenCvCameraBase.this.viewport).setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                        OpenCvCameraBase.this.viewportContainerLayout.setVisibility(0);
                        OpenCvCameraBase.this.viewportContainerLayout.addView((View)OpenCvCameraBase.this.viewport);
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    exToRethrowOnOpModeThread[0] = e;
                }
                catch (Error e) {
                    e.printStackTrace();
                }
                finally {
                    latch.countDown();
                }
            }
        });
        try {
            latch.await();
            if (exToRethrowOnOpModeThread[0] != null) {
                throw exToRethrowOnOpModeThread[0];
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
            Object object = this.viewportLock;
            synchronized (object) {
                this.viewport = null;
            }
        }
    }

    private void removeViewportAsync(final View viewport) {
        AppUtil.getInstance().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                OpenCvCameraBase.this.viewportContainerLayout.removeView(viewport);
                OpenCvCameraBase.this.viewportContainerLayout.setVisibility(8);
            }
        });
    }

    protected void notifyStartOfFrameProcessing() {
        this.currentFrameStartTime = System.currentTimeMillis();
    }

    @Override
    public synchronized void startRecordingPipeline(PipelineRecordingParameters parameters) {
        System.out.println("startRecordingPipeline()");
        try {
            if (!this.isStreaming()) {
                throw new IllegalStateException("A recording session may only be started once a streaming session is already in flight");
            }
            if (this.mediaRecorder != null) {
                throw new IllegalStateException("A recording session is already ongoing!");
            }
            this.mediaRecorderSurface = MediaCodec.createPersistentInputSurface();
            this.mediaRecorderSurfaceNativeHandle = this.nativeGetSurfaceHandle(this.mediaRecorderSurface);
            this.mediaRecorder = new MediaRecorder();
            this.mediaRecorder.setInputSurface(this.mediaRecorderSurface);
            this.mediaRecorder.setVideoSource(2);
            this.mediaRecorder.setOutputFormat(parameters.outputFormat.format);
            this.mediaRecorder.setVideoSize(this.width, this.height);
            this.mediaRecorder.setVideoEncoder(parameters.encoder.format);
            this.mediaRecorder.setVideoEncodingBitRate(parameters.bitrate);
            this.mediaRecorder.setOutputFile(parameters.path);
            this.mediaRecorder.setCaptureRate((double)parameters.frameRate);
            this.mediaRecorder.prepare();
            this.mediaRecorder.start();
            if (this.viewport != null) {
                this.viewport.setRecording(true);
            }
        }
        catch (IOException e) {
            this.nativeReleaseSurfaceHandle(this.mediaRecorderSurfaceNativeHandle);
            this.mediaRecorderSurfaceNativeHandle = 0L;
            this.mediaRecorderSurface.release();
            this.mediaRecorderSurface = null;
            this.mediaRecorder = null;
            throw new OpenCvCameraException("Unable to begin recording");
        }
        catch (Exception e) {
            this.nativeReleaseSurfaceHandle(this.mediaRecorderSurfaceNativeHandle);
            this.mediaRecorderSurfaceNativeHandle = 0L;
            this.mediaRecorderSurface.release();
            this.mediaRecorderSurface = null;
            this.mediaRecorder = null;
            throw e;
        }
        finally {
            System.out.println("...startRecordingPipeline()");
        }
    }

    @Override
    public synchronized void stopRecordingPipeline() {
        System.out.println("stopRecordingPipeline()");
        try {
            if (this.mediaRecorder != null) {
                this.mediaRecorder.stop();
                this.nativeReleaseSurfaceHandle(this.mediaRecorderSurfaceNativeHandle);
                this.mediaRecorderSurfaceNativeHandle = 0L;
                this.mediaRecorderSurface.release();
                this.mediaRecorderSurface = null;
                this.mediaRecorder = null;
                if (this.viewport != null) {
                    this.viewport.setRecording(false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.out.println("...stopRecordingPipeline()");
        }
    }

    protected synchronized void handleFrame(Mat frame, long timestamp) {
        try {
            this.handleFrameUserCrashable(frame, timestamp);
        }
        catch (Exception e) {
            this.emulateEStop(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void handleFrameUserCrashable(Mat frame, long timestamp) {
        Mat matForDisplay;
        OpenCvPipeline pipelineSafe;
        this.msFrameIntervalRollingAverage.add(this.timer.milliseconds());
        this.timer.reset();
        double secondsPerFrame = this.msFrameIntervalRollingAverage.getMean() / 1000.0;
        this.avgFps = (float)(1.0 / secondsPerFrame);
        Mat userProcessedFrame = null;
        int rotateCode = this.mapRotationEnumToOpenCvRotateCode(this.rotation);
        if (rotateCode != -1) {
            Core.rotate((Mat)frame, (Mat)this.rotatedMat, (int)rotateCode);
            frame = this.rotatedMat;
        }
        Object object = this.pipelineChangeLock;
        synchronized (object) {
            pipelineSafe = this.pipeline;
        }
        if (pipelineSafe != null) {
            if (pipelineSafe instanceof TimestampedOpenCvPipeline) {
                ((TimestampedOpenCvPipeline)pipelineSafe).setTimestamp(timestamp);
            }
            long pipelineStart = System.currentTimeMillis();
            userProcessedFrame = pipelineSafe.processFrameInternal(frame);
            this.msUserPipelineRollingAverage.add((double)(System.currentTimeMillis() - pipelineStart));
        }
        if (pipelineSafe == null) {
            matForDisplay = frame;
        } else {
            if (userProcessedFrame == null) {
                throw new OpenCvCameraException("User pipeline returned null");
            }
            if (userProcessedFrame.empty()) {
                throw new OpenCvCameraException("User pipeline returned empty mat");
            }
            if (userProcessedFrame.cols() != frame.cols() || userProcessedFrame.rows() != frame.rows()) {
                if (userProcessedFrame.cols() > frame.cols() || userProcessedFrame.rows() > frame.rows()) {
                    throw new OpenCvCameraException("User pipeline returned frame of unexpected size");
                }
                if (this.matToUseIfPipelineReturnedCropped == null) {
                    this.matToUseIfPipelineReturnedCropped = frame.clone();
                }
                this.matToUseIfPipelineReturnedCropped.setTo(this.brown);
                int usrFrmTyp = userProcessedFrame.type();
                if (usrFrmTyp == CvType.CV_8UC1) {
                    Imgproc.cvtColor((Mat)userProcessedFrame, (Mat)this.croppedColorCvtedMat, (int)9);
                    userProcessedFrame = this.croppedColorCvtedMat;
                } else if (usrFrmTyp != CvType.CV_8UC4 && usrFrmTyp != CvType.CV_8UC3) {
                    throw new OpenCvCameraException("User pipeline returned a frame of an illegal type. Valid types are CV_8UC1, CV_8UC3, and CV_8UC4");
                }
                userProcessedFrame.copyTo(this.matToUseIfPipelineReturnedCropped.submat(new Rect(0, 0, userProcessedFrame.cols(), userProcessedFrame.rows())));
                matForDisplay = this.matToUseIfPipelineReturnedCropped;
            } else {
                matForDisplay = userProcessedFrame;
            }
        }
        if (this.mediaRecorder != null) {
            this.nativeCopyMatToSurface(this.mediaRecorderSurfaceNativeHandle, matForDisplay.nativeObj);
        }
        if (this.viewport != null) {
            this.viewport.post(matForDisplay, new OpenCvViewport.FrameContext(pipelineSafe, pipelineSafe != null ? pipelineSafe.getUserContextForDrawHook() : null));
        }
        this.avgPipelineTime = (int)Math.round(this.msUserPipelineRollingAverage.getMean());
        this.avgTotalFrameTime = (int)Math.round(this.msTotalFrameProcessingTimeRollingAverage.getMean());
        this.avgOverheadTime = this.avgTotalFrameTime - this.avgPipelineTime;
        if (this.viewport != null) {
            this.viewport.notifyStatistics(this.avgFps, this.avgPipelineTime, this.avgOverheadTime);
        }
        ++this.frameCount;
        this.msTotalFrameProcessingTimeRollingAverage.add((double)(System.currentTimeMillis() - this.currentFrameStartTime));
        Object object2 = this.bitmapFrameLock;
        synchronized (object2) {
            if (this.bitmapContinuation != null) {
                Bitmap bitmapForDs;
                OpenCvViewRenderer renderer = new OpenCvViewRenderer((Context)AppUtil.getInstance().getActivity(), true);
                OpenCvViewport.OptimizedRotation optimizedRotation = this.getOptimizedViewportRotation(this.rotation, AppUtil.getInstance().getActivity().getWindowManager().getDefaultDisplay().getRotation());
                renderer.setOptimizedViewRotation(optimizedRotation);
                renderer.notifyStatistics(this.avgFps, this.avgPipelineTime, this.avgOverheadTime);
                renderer.setRenderingPolicy(this.desiredRenderingPolicy);
                if (pipelineSafe != null) {
                    float fixedAspect;
                    int fixedWidth = 1280;
                    int fixedHeight = 720;
                    float imageAspect = (float)matForDisplay.width() / (float)matForDisplay.height();
                    if (imageAspect > (fixedAspect = (float)fixedWidth / (float)fixedHeight)) {
                        fixedHeight = Math.round((float)fixedWidth / imageAspect);
                    } else {
                        fixedWidth = Math.round((float)fixedHeight * imageAspect);
                    }
                    if (this.desiredRenderingPolicy == OpenCvCamera.ViewportRenderingPolicy.OPTIMIZE_VIEW && (optimizedRotation == OpenCvViewport.OptimizedRotation.ROT_90_CLOCKWISE || optimizedRotation == OpenCvViewport.OptimizedRotation.ROT_90_COUNTERCLOCWISE)) {
                        int tmp = fixedWidth;
                        fixedWidth = fixedHeight;
                        fixedHeight = tmp;
                    }
                    bitmapForDs = Bitmap.createBitmap((int)fixedWidth, (int)fixedHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
                    renderer.setFpsMeterEnabled(this.fpsMeterDesired);
                    Canvas canvas = new Canvas(bitmapForDs);
                    renderer.render(matForDisplay, canvas, new OpenCvViewport.RenderHook(){

                        @Override
                        public void onDrawFrame(Canvas canvas, int onscreenWidth, int onscreenHeight, float scaleBmpPxToCanvasPx, float canvasDensityScale, Object userContext) {
                            pipelineSafe.onDrawFrame(canvas, onscreenWidth, onscreenHeight, scaleBmpPxToCanvasPx, canvasDensityScale, userContext);
                        }
                    }, pipelineSafe.getUserContextForDrawHook());
                } else {
                    bitmapForDs = Bitmap.createBitmap((int)matForDisplay.cols(), (int)matForDisplay.rows(), (Bitmap.Config)Bitmap.Config.RGB_565);
                    Utils.matToBitmap((Mat)matForDisplay, (Bitmap)bitmapForDs);
                }
                this.bitmapContinuation.dispatch((ContinuationResult)new ContinuationResult<Consumer<Bitmap>>(){

                    public void handle(Consumer<Bitmap> bitmapConsumer) {
                        bitmapConsumer.accept((Object)bitmapForDs);
                        bitmapForDs.recycle();
                    }
                });
                this.bitmapContinuation = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFrameBitmap(Continuation<? extends Consumer<Bitmap>> continuation) {
        Object object = this.bitmapFrameLock;
        synchronized (object) {
            this.bitmapContinuation = continuation;
        }
    }

    protected void emulateEStop(Exception e) {
        RobotLog.ee((String)"OpenCvCamera", (Throwable)e, (String)"User code threw an uncaught exception");
        OpModeManagerImpl mgr = OpModeManagerImpl.getOpModeManagerOfActivity((Activity)AppUtil.getInstance().getActivity());
        mgr.initOpMode("$Stop$Robot$");
        String stacktrace = Log.getStackTraceString((Throwable)e);
        String[] lines = stacktrace.split("\n");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < Math.min(lines.length, 15); ++i) {
            builder.append(lines[i]).append("\n");
        }
        NetworkConnectionHandler.getInstance().sendCommand(new Command("CMD_SHOW_STACKTRACE", builder.toString()));
    }

    @Override
    public int getFrameCount() {
        return this.frameCount;
    }

    @Override
    public float getFps() {
        return this.avgFps;
    }

    @Override
    public int getPipelineTimeMs() {
        return this.avgPipelineTime;
    }

    @Override
    public int getOverheadTimeMs() {
        return this.avgOverheadTime;
    }

    @Override
    public int getTotalFrameTimeMs() {
        return this.avgTotalFrameTime;
    }

    @Override
    public int getCurrentPipelineMaxFps() {
        if (this.avgTotalFrameTime != 0) {
            return 1000 / this.avgTotalFrameTime;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setViewportRenderingPolicy(OpenCvCamera.ViewportRenderingPolicy policy) {
        Object object = this.viewportLock;
        synchronized (object) {
            if (!this.cameraOrientationIsTiedToDeviceOrientation()) {
                RobotLog.addGlobalWarningMessage((String)"Setting viewport rendering policy is not applicable for this type of camera - ignoring.");
            } else if (this.viewport == null) {
                this.desiredRenderingPolicy = policy;
            } else {
                throw new IllegalStateException("setViewportRenderingPolicy() must only be called before opening the camera.");
            }
        }
    }

    @Override
    public synchronized void setViewportRenderer(OpenCvCamera.ViewportRenderer renderer) {
        if (this.viewport != null) {
            throw new IllegalStateException("setViewportRenderer() must only be called before opening the camera.");
        }
        this.desiredViewportRenderer = renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGlobalWarning() {
        Object object = this.pipelineChangeLock;
        synchronized (object) {
            if (this.pipeline != null) {
                return this.pipeline.getLeakMsg();
            }
            return "";
        }
    }

    public boolean shouldTriggerWarningSound() {
        return false;
    }

    public void suppressGlobalWarning(boolean suppress) {
    }

    public void setGlobalWarning(String warning) {
    }

    public void clearGlobalWarning() {
    }

    protected Size getFrameSizeAfterRotation(int width, int height, OpenCvCameraRotation rotation) {
        int screenRenderedHeight;
        int screenRenderedWidth;
        int openCvRotateCode = this.mapRotationEnumToOpenCvRotateCode(rotation);
        if (openCvRotateCode == 0 || openCvRotateCode == 2) {
            screenRenderedWidth = height;
            screenRenderedHeight = width;
        } else {
            screenRenderedWidth = width;
            screenRenderedHeight = height;
        }
        return new Size(screenRenderedWidth, screenRenderedHeight);
    }

    protected OpenCvViewport.OptimizedRotation getOptimizedViewportRotation(OpenCvCameraRotation streamRotation, int windowRotation) {
        if (!this.cameraOrientationIsTiedToDeviceOrientation()) {
            return OpenCvViewport.OptimizedRotation.NONE;
        }
        if (windowRotation == 0) {
            if (streamRotation == OpenCvCameraRotation.SIDEWAYS_LEFT || streamRotation == OpenCvCameraRotation.SENSOR_NATIVE) {
                return OpenCvViewport.OptimizedRotation.ROT_90_COUNTERCLOCWISE;
            }
            if (streamRotation == OpenCvCameraRotation.SIDEWAYS_RIGHT) {
                return OpenCvViewport.OptimizedRotation.ROT_90_CLOCKWISE;
            }
            if (streamRotation == OpenCvCameraRotation.UPSIDE_DOWN) {
                return OpenCvViewport.OptimizedRotation.ROT_180;
            }
            return OpenCvViewport.OptimizedRotation.NONE;
        }
        if (windowRotation == 1) {
            if (streamRotation == OpenCvCameraRotation.SIDEWAYS_RIGHT) {
                return OpenCvViewport.OptimizedRotation.ROT_180;
            }
            if (streamRotation == OpenCvCameraRotation.UPRIGHT) {
                return OpenCvViewport.OptimizedRotation.ROT_90_CLOCKWISE;
            }
            if (streamRotation == OpenCvCameraRotation.UPSIDE_DOWN) {
                return OpenCvViewport.OptimizedRotation.ROT_90_COUNTERCLOCWISE;
            }
            return OpenCvViewport.OptimizedRotation.NONE;
        }
        if (windowRotation == 3) {
            if (streamRotation == OpenCvCameraRotation.SIDEWAYS_LEFT || streamRotation == OpenCvCameraRotation.SENSOR_NATIVE) {
                return OpenCvViewport.OptimizedRotation.ROT_180;
            }
            if (streamRotation == OpenCvCameraRotation.UPRIGHT) {
                return OpenCvViewport.OptimizedRotation.ROT_90_COUNTERCLOCWISE;
            }
            if (streamRotation == OpenCvCameraRotation.UPSIDE_DOWN) {
                return OpenCvViewport.OptimizedRotation.ROT_90_CLOCKWISE;
            }
            return OpenCvViewport.OptimizedRotation.NONE;
        }
        return OpenCvViewport.OptimizedRotation.NONE;
    }

    protected abstract OpenCvCameraRotation getDefaultRotation();

    protected abstract int mapRotationEnumToOpenCvRotateCode(OpenCvCameraRotation var1);

    protected abstract boolean cameraOrientationIsTiedToDeviceOrientation();

    protected abstract boolean isStreaming();

    private native long nativeGetSurfaceHandle(Surface var1);

    private native void nativeReleaseSurfaceHandle(long var1);

    private native void nativeCopyMatToSurface(long var1, long var3);

    static {
        System.loadLibrary("EasyOpenCV");
    }

    private class ComponentCallbacksForRotation
    implements ComponentCallbacks {
        private ComponentCallbacksForRotation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConfigurationChanged(Configuration newConfig) {
            int displayRot = AppUtil.getInstance().getActivity().getWindowManager().getDefaultDisplay().getRotation();
            Object object = OpenCvCameraBase.this.viewportLock;
            synchronized (object) {
                if (OpenCvCameraBase.this.viewport != null) {
                    OpenCvCameraBase.this.viewport.setOptimizedViewRotation(OpenCvCameraBase.this.getOptimizedViewportRotation(OpenCvCameraBase.this.rotation, displayRot));
                }
            }
        }

        public void onLowMemory() {
        }
    }

    private class OpModeNotificationsForOrientation
    implements OpModeManagerNotifier.Notifications {
        private OpModeNotificationsForOrientation() {
        }

        public void onOpModePreInit(OpMode opMode) {
        }

        public void onOpModePreStart(OpMode opMode) {
        }

        public void onOpModePostStop(OpMode opMode) {
            AppUtil.getInstance().getApplication().unregisterComponentCallbacks((ComponentCallbacks)OpenCvCameraBase.this.componentCallbacksForRotation);
            OpModeManagerImpl.getOpModeManagerOfActivity((Activity)AppUtil.getInstance().getActivity()).unregisterListener((OpModeManagerNotifier.Notifications)this);
        }
    }

    private class OpModeNotifications
    implements LIFO_OpModeCallbackDelegate.OnOpModeStoppedListener {
        private OpModeNotifications() {
        }

        @Override
        public void onOpModePostStop(OpMode opMode) {
            OpenCvCameraBase.this.hasBeenCleanedUp = true;
            RobotLog.unregisterGlobalWarningSource((GlobalWarningSource)OpenCvCameraBase.this);
            OpenCvCameraBase.this.closeCameraDevice();
        }
    }
}

