/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import org.openeuler.spec.ECCPremasterSecretKeySpec;
import org.openeuler.sun.security.internal.spec.TlsECCKeyAgreementParameterSpec;
import org.openeuler.sun.security.ssl.Alert;
import org.openeuler.sun.security.ssl.ClientHandshakeContext;
import org.openeuler.sun.security.ssl.HandshakeContext;
import org.openeuler.sun.security.ssl.JsseJce;
import org.openeuler.sun.security.ssl.SSLCredentials;
import org.openeuler.sun.security.ssl.SSLKeyAgreementGenerator;
import org.openeuler.sun.security.ssl.SSLKeyDerivation;
import org.openeuler.sun.security.ssl.SSLMasterKeyDerivation;
import org.openeuler.sun.security.ssl.SSLPossession;
import org.openeuler.sun.security.ssl.SSLPossessionGenerator;
import org.openeuler.sun.security.ssl.ServerHandshakeContext;

final class ECCKeyExchange {
    static final SSLPossessionGenerator poGenerator = new ECCPossessionGenerator();
    static final SSLKeyAgreementGenerator kaGenerator = new ECCKAGenerator();

    ECCKeyExchange() {
    }

    private static final class ECCKAGenerator
    implements SSLKeyAgreementGenerator {
        private ECCKAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext context) throws IOException {
            ECCPremasterSecret premaster = null;
            if (context instanceof ClientHandshakeContext) {
                for (SSLPossession possession : context.handshakePossessions) {
                    if (!(possession instanceof ECCPremasterSecret)) continue;
                    premaster = (ECCPremasterSecret)possession;
                    break;
                }
            } else {
                for (SSLCredentials credential : context.handshakeCredentials) {
                    if (!(credential instanceof ECCPremasterSecret)) continue;
                    premaster = (ECCPremasterSecret)credential;
                    break;
                }
            }
            if (premaster == null) {
                throw context.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient ECC key agreement parameters negotiated");
            }
            return new ECCKAKeyDerivation(context, (SecretKey)premaster.premasterSecret);
        }

        private static final class ECCKAKeyDerivation
        implements SSLKeyDerivation {
            private final HandshakeContext context;
            private final SecretKey preMasterSecret;

            ECCKAKeyDerivation(HandshakeContext context, SecretKey preMasterSecret) {
                this.context = context;
                this.preMasterSecret = preMasterSecret;
            }

            @Override
            public SecretKey deriveKey(String algorithm, AlgorithmParameterSpec params) throws IOException {
                SSLMasterKeyDerivation mskd = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
                if (mskd == null) {
                    throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
                }
                SSLKeyDerivation kd = mskd.createKeyDerivation(this.context, this.preMasterSecret);
                return kd.deriveKey("MasterSecret", params);
            }
        }
    }

    static final class ECCPremasterSecret
    implements SSLPossession,
    SSLCredentials {
        final ECCPremasterSecretKeySpec premasterSecret;

        ECCPremasterSecret(ECCPremasterSecretKeySpec premasterSecret) {
            this.premasterSecret = premasterSecret;
        }

        byte[] getEncoded(PublicKey publicKey, SecureRandom secureRandom) throws GeneralSecurityException {
            return this.premasterSecret.getEncryptedKey();
        }

        static ECCPremasterSecret createPremasterSecret(PublicKey publicKey, ClientHandshakeContext chc) throws GeneralSecurityException {
            String algorithm = "GmTlsEccPremasterSecret";
            KeyAgreement keyAgreement = JsseJce.getKeyAgreement(algorithm);
            TlsECCKeyAgreementParameterSpec spec = new TlsECCKeyAgreementParameterSpec(chc.clientHelloVersion, chc.negotiatedProtocol.id);
            keyAgreement.init(publicKey, (AlgorithmParameterSpec)spec, chc.sslContext.getSecureRandom());
            ECCPremasterSecretKeySpec preMaster = (ECCPremasterSecretKeySpec)keyAgreement.generateSecret("TlsEccPremasterSecret");
            return new ECCPremasterSecret(preMaster);
        }

        static ECCPremasterSecret decode(ServerHandshakeContext shc, PrivateKey privateKey, byte[] encrypted) throws GeneralSecurityException {
            String algorithm = "GmTlsEccPremasterSecret";
            KeyAgreement keyAgreement = JsseJce.getKeyAgreement(algorithm);
            TlsECCKeyAgreementParameterSpec spec = new TlsECCKeyAgreementParameterSpec(encrypted, shc.clientHelloVersion, shc.negotiatedProtocol.id, false);
            keyAgreement.init((Key)privateKey, (AlgorithmParameterSpec)spec);
            ECCPremasterSecretKeySpec preMaster = (ECCPremasterSecretKeySpec)keyAgreement.generateSecret("TlsEccPremasterSecret");
            return new ECCPremasterSecret(preMaster);
        }
    }

    private static final class ECCPossessionGenerator
    implements SSLPossessionGenerator {
        private ECCPossessionGenerator() {
        }

        @Override
        public SSLPossession createPossession(HandshakeContext context) {
            return null;
        }
    }
}

