/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.gm;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.openeuler.gm.GMTlsUtil;
import org.openeuler.sun.security.internal.spec.TlsPrfParameterSpec;

public class GMTlsPrfGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsPrfGenerator must be initialized using a TlsPrfParameterSpec";
    private TlsPrfParameterSpec spec;

    @Override
    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof TlsPrfParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsPrfParameterSpec)params;
        SecretKey key = this.spec.getSecret();
        if (key != null && !"RAW".equals(key.getFormat())) {
            throw new InvalidAlgorithmParameterException("Key encoding format must be RAW");
        }
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("GMTlsPrfGenerator must be initialized");
        }
        SecretKey key = this.spec.getSecret();
        byte[] secret = key == null ? null : key.getEncoded();
        try {
            byte[] labelBytes = this.spec.getLabel().getBytes("UTF8");
            int n = this.spec.getOutputLength();
            byte[] prfBytes = GMTlsUtil.doGMTLS11PRF(secret, labelBytes, this.spec.getSeed(), n, this.spec.getPRFHashAlg(), this.spec.getPRFHashLength(), this.spec.getPRFBlockSize());
            return new SecretKeySpec(prfBytes, "GMTlsPrf");
        }
        catch (UnsupportedEncodingException | GeneralSecurityException e) {
            throw new ProviderException("Could not generate PRF", e);
        }
    }
}

