/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLHandshakeException;
import org.openeuler.sun.security.ssl.Alert;
import org.openeuler.sun.security.ssl.ClientHandshakeContext;
import org.openeuler.sun.security.ssl.HandshakeContext;
import org.openeuler.sun.security.ssl.Krb5Helper;
import org.openeuler.sun.security.ssl.ProtocolVersion;
import org.openeuler.sun.security.ssl.SSLCredentials;
import org.openeuler.sun.security.ssl.SSLKeyAgreementGenerator;
import org.openeuler.sun.security.ssl.SSLKeyDerivation;
import org.openeuler.sun.security.ssl.SSLLogger;
import org.openeuler.sun.security.ssl.SSLMasterKeyDerivation;
import org.openeuler.sun.security.ssl.SSLPossession;
import org.openeuler.sun.security.ssl.SSLPossessionGenerator;

final class KrbKeyExchange {
    static final SSLPossessionGenerator poGenerator = new KrbPossessionGenerator();
    static final SSLKeyAgreementGenerator kaGenerator = new KrbKAGenerator();

    KrbKeyExchange() {
    }

    private static final class KrbKAGenerator
    implements SSLKeyAgreementGenerator {
        private KrbKAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext context) throws IOException {
            KrbPremasterSecret premaster = null;
            if (context instanceof ClientHandshakeContext) {
                for (SSLPossession possession : context.handshakePossessions) {
                    if (!(possession instanceof KrbPremasterSecret)) continue;
                    premaster = (KrbPremasterSecret)possession;
                    break;
                }
            } else {
                for (SSLCredentials credential : context.handshakeCredentials) {
                    if (!(credential instanceof KrbPremasterSecret)) continue;
                    premaster = (KrbPremasterSecret)credential;
                    break;
                }
            }
            if (premaster == null) {
                throw context.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient KRB key agreement parameters negotiated");
            }
            return new KRBKAKeyDerivation(context, premaster.preMaster);
        }

        private static final class KRBKAKeyDerivation
        implements SSLKeyDerivation {
            private final HandshakeContext context;
            private final byte[] secretBytes;

            KRBKAKeyDerivation(HandshakeContext context, byte[] secret) {
                this.context = context;
                this.secretBytes = secret;
            }

            @Override
            public SecretKey deriveKey(String algorithm, AlgorithmParameterSpec params) throws IOException {
                try {
                    SecretKeySpec preMasterSecret = new SecretKeySpec(this.secretBytes, "TlsPremasterSecret");
                    SSLMasterKeyDerivation mskd = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
                    if (mskd == null) {
                        throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
                    }
                    SSLKeyDerivation kd = mskd.createKeyDerivation(this.context, preMasterSecret);
                    return kd.deriveKey("MasterSecret", params);
                }
                catch (Exception gse) {
                    throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(gse);
                }
            }
        }
    }

    static final class KrbPremasterSecret
    implements SSLPossession,
    SSLCredentials {
        final byte[] preMaster;

        KrbPremasterSecret(byte[] premasterSecret) {
            this.preMaster = premasterSecret;
        }

        static KrbPremasterSecret createPremasterSecret(ProtocolVersion protocolVersion, SecureRandom rand) {
            byte[] pm = new byte[48];
            rand.nextBytes(pm);
            pm[0] = protocolVersion.major;
            pm[1] = protocolVersion.minor;
            return new KrbPremasterSecret(pm);
        }

        static KrbPremasterSecret decode(ProtocolVersion protocolVersion, ProtocolVersion clientVersion, byte[] preMaster, SecureRandom rand) {
            KrbPremasterSecret preMasterSecret = null;
            boolean versionMismatch = true;
            ProtocolVersion preMasterProtocolVersion = null;
            if (preMaster != null && preMaster.length == 48) {
                preMasterProtocolVersion = ProtocolVersion.valueOf(preMaster[0], preMaster[1]);
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Kerberos pre-master secret protocol version: " + (Object)((Object)preMasterProtocolVersion), new Object[0]);
                }
                boolean bl = versionMismatch = preMasterProtocolVersion.compare(clientVersion) != 0;
                if (versionMismatch && clientVersion.compare(ProtocolVersion.TLS10) <= 0) {
                    boolean bl2 = versionMismatch = preMasterProtocolVersion.compare(protocolVersion) != 0;
                }
            }
            if (versionMismatch) {
                preMasterSecret = KrbPremasterSecret.createPremasterSecret(clientVersion, rand);
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Kerberos pre-master secret error, generating random secret for safe failure.", new Object[0]);
                }
            } else {
                preMasterSecret = new KrbPremasterSecret(preMaster);
            }
            return preMasterSecret;
        }
    }

    static final class KrbServiceCreds
    implements SSLPossession {
        final Object serviceCreds;

        KrbServiceCreds(Object serviceCreds) {
            this.serviceCreds = serviceCreds;
        }
    }

    static final class KrbPossessionGenerator
    implements SSLPossessionGenerator {
        KrbPossessionGenerator() {
        }

        @Override
        public SSLPossession createPossession(HandshakeContext handshakeContext) {
            block8: {
                Object serviceCreds = null;
                try {
                    String serverPrincipal;
                    final AccessControlContext acc = handshakeContext.conContext.acc;
                    serviceCreds = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return Krb5Helper.getServiceCreds(acc);
                        }
                    });
                    if (serviceCreds == null) break block8;
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.fine("Using Kerberos creds", new Object[0]);
                    }
                    if ((serverPrincipal = Krb5Helper.getServerPrincipalName(serviceCreds)) != null) {
                        SecurityManager sm = System.getSecurityManager();
                        try {
                            if (sm != null) {
                                sm.checkPermission(Krb5Helper.getServicePermission(serverPrincipal, "accept"), acc);
                            }
                        }
                        catch (SecurityException se) {
                            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                                SSLLogger.fine("Permission to access Kerberos secret key denied", new Object[0]);
                            }
                            return null;
                        }
                    }
                    return new KrbServiceCreds(serviceCreds);
                }
                catch (PrivilegedActionException e) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) break block8;
                    SSLLogger.fine("Attempt to obtain Kerberos key failed: " + e.toString(), new Object[0]);
                }
            }
            return null;
        }
    }
}

