/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;

public class KrbClientKeyExchangeHelper {
    private static final String KRB5_CLASS_NAME = "sun.security.ssl.krb5.KrbClientKeyExchangeHelperImpl";
    private static final Class<?> krb5Class = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

        @Override
        public Class<?> run() {
            try {
                return Class.forName(KrbClientKeyExchangeHelper.KRB5_CLASS_NAME, true, null);
            }
            catch (ClassNotFoundException cnf) {
                return null;
            }
        }
    });
    private static Method initRreMaster;
    private static Method initEncodedTicket;
    private static Method getEncodedTicket;
    private static Method getEncryptedPreMasterSecret;
    private static Method getPlainPreMasterSecret;
    private static Method getPeerPrincipal;
    private static Method getLocalPrincipal;
    private static Exception exception;
    private Object krb5Instance;

    private static void initMethod() throws NoSuchMethodException {
        if (krb5Class == null) {
            return;
        }
        initRreMaster = krb5Class.getDeclaredMethod("init", byte[].class, String.class, AccessControlContext.class);
        initEncodedTicket = krb5Class.getDeclaredMethod("init", byte[].class, byte[].class, Object.class, AccessControlContext.class);
        getEncodedTicket = krb5Class.getDeclaredMethod("getEncodedTicket", new Class[0]);
        getEncryptedPreMasterSecret = krb5Class.getDeclaredMethod("getEncryptedPreMasterSecret", new Class[0]);
        getPlainPreMasterSecret = krb5Class.getDeclaredMethod("getPlainPreMasterSecret", new Class[0]);
        getPeerPrincipal = krb5Class.getDeclaredMethod("getPeerPrincipal", new Class[0]);
        getLocalPrincipal = krb5Class.getDeclaredMethod("getLocalPrincipal", new Class[0]);
    }

    private static Object newKrb5Instance() {
        if (krb5Class != null) {
            try {
                return krb5Class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }
        return null;
    }

    private static void ensureAvailable() {
        if (krb5Class == null) {
            throw new AssertionError((Object)"Kerberos is unavailable");
        }
        if (exception != null) {
            throw new AssertionError((Object)exception);
        }
    }

    private static Object invoke(Method method, Object obj, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    KrbClientKeyExchangeHelper() {
        KrbClientKeyExchangeHelper.ensureAvailable();
        this.krb5Instance = KrbClientKeyExchangeHelper.newKrb5Instance();
    }

    void init(byte[] preMaster, String serverName, AccessControlContext acc) throws IOException {
        KrbClientKeyExchangeHelper.ensureAvailable();
        KrbClientKeyExchangeHelper.invoke(initRreMaster, this.krb5Instance, preMaster, serverName, acc);
    }

    void init(byte[] encodedTicket, byte[] preMasterEnc, Object serviceCreds, AccessControlContext acc) throws IOException {
        KrbClientKeyExchangeHelper.ensureAvailable();
        KrbClientKeyExchangeHelper.invoke(initEncodedTicket, this.krb5Instance, encodedTicket, preMasterEnc, serviceCreds, acc);
    }

    byte[] getEncodedTicket() {
        KrbClientKeyExchangeHelper.ensureAvailable();
        return (byte[])KrbClientKeyExchangeHelper.invoke(getEncodedTicket, this.krb5Instance, new Object[0]);
    }

    byte[] getEncryptedPreMasterSecret() {
        KrbClientKeyExchangeHelper.ensureAvailable();
        return (byte[])KrbClientKeyExchangeHelper.invoke(getEncryptedPreMasterSecret, this.krb5Instance, new Object[0]);
    }

    byte[] getPlainPreMasterSecret() {
        KrbClientKeyExchangeHelper.ensureAvailable();
        return (byte[])KrbClientKeyExchangeHelper.invoke(getPlainPreMasterSecret, this.krb5Instance, new Object[0]);
    }

    Principal getPeerPrincipal() {
        KrbClientKeyExchangeHelper.ensureAvailable();
        return (Principal)KrbClientKeyExchangeHelper.invoke(getPeerPrincipal, this.krb5Instance, new Object[0]);
    }

    Principal getLocalPrincipal() {
        KrbClientKeyExchangeHelper.ensureAvailable();
        return (Principal)KrbClientKeyExchangeHelper.invoke(getLocalPrincipal, this.krb5Instance, new Object[0]);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    KrbClientKeyExchangeHelper.initMethod();
                }
                catch (NoSuchMethodException e) {
                    exception = e;
                }
                return null;
            }
        });
    }
}

