/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.gm;

import java.io.FileInputStream;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.openeuler.gm.GMTlsUtil;
import org.openeuler.sun.security.ssl.SSLLogger;

public class KeyStoreManager {
    private static final String P11KEYSTORE = "PKCS11";
    private static final String NONE = "NONE";

    public static KeyManager[] getKeyManagers() throws Exception {
        List srcDescriptors = KeyStoreDescriptor.createInstances();
        KeyStoreDescriptor destDescriptor = (KeyStoreDescriptor)srcDescriptors.get(0);
        KeyStore destKeyStore = KeyStoreManager.createDestKeyStore(srcDescriptors, destDescriptor);
        if (SSLLogger.isOn && SSLLogger.isOn("ssl,defaultctx")) {
            SSLLogger.fine("init keymanager of type " + KeyManagerFactory.getDefaultAlgorithm(), new Object[0]);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if (P11KEYSTORE.equals(destDescriptor.storeType)) {
            kmf.init(destKeyStore, null);
        } else {
            char[] passwd = destDescriptor.storePassword.isEmpty() ? null : destDescriptor.storePassword.toCharArray();
            kmf.init(destKeyStore, passwd);
        }
        return kmf.getKeyManagers();
    }

    private static KeyStore createDestKeyStore(List<KeyStoreDescriptor> srcDescriptors, KeyStoreDescriptor destDescriptor) throws Exception {
        int storeCount = srcDescriptors.size();
        String destStoreType = destDescriptor.storeType;
        String destStoreProvider = destDescriptor.storeProvider;
        String destStorePasswd = destDescriptor.storePassword;
        KeyStore destKeyStore = null;
        if (storeCount <= 1) {
            destKeyStore = KeyStoreManager.loadKeyStore(destDescriptor);
        } else {
            if (!destStoreType.isEmpty()) {
                destKeyStore = !destStoreProvider.isEmpty() ? KeyStore.getInstance(destStoreType, destStoreProvider) : KeyStore.getInstance(destStoreType);
            }
            if (destKeyStore != null) {
                char[] passwd = destStorePasswd.isEmpty() ? null : destStorePasswd.toCharArray();
                destKeyStore.load(null, passwd);
                for (int i = 0; i < storeCount; ++i) {
                    KeyStoreDescriptor srcDescriptor = srcDescriptors.get(i);
                    KeyStore srcKeyStore = KeyStoreManager.loadKeyStore(srcDescriptor);
                    GMTlsUtil.copyKeyStore(srcKeyStore, srcDescriptor.storePassword.toCharArray(), destKeyStore, passwd);
                }
            }
        }
        return destKeyStore;
    }

    private static String[] getKeyStorePropValues(String propKey, String propValue, int storeCount) {
        String[] propValues = new String[]{};
        if (!propValue.isEmpty()) {
            propValues = propValue.split(",");
        }
        if (propValues.length > 1 && propValues.length != storeCount) {
            String message = "The keyStore count is " + storeCount + " , the " + propKey + " property value count should be 0 or 1 or equals keyStore count.";
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,defaultctx")) {
                SSLLogger.fine(message, new Object[0]);
            }
            throw new IllegalArgumentException(message);
        }
        if (storeCount == 0 || propValues.length == storeCount) {
            return propValues;
        }
        Object[] newPropValues = new String[storeCount];
        String tempPropValue = propValues.length == 0 ? "" : propValues[0];
        Arrays.fill(newPropValues, tempPropValue);
        return newPropValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(KeyStoreDescriptor descriptor) throws Exception {
        final String storeName = descriptor.storeName;
        String storeType = descriptor.storeType;
        String storePassword = descriptor.storePassword;
        String storeProvider = descriptor.storeProvider;
        if (P11KEYSTORE.equals(storeType) && !NONE.equals(storeName)) {
            throw new IllegalArgumentException("if keyStoreType is PKCS11, then keyStore must be NONE");
        }
        FileInputStream fs = null;
        KeyStore ks = null;
        char[] passwd = null;
        try {
            if (!storeName.isEmpty() && !NONE.equals(storeName)) {
                fs = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws Exception {
                        return new FileInputStream(storeName);
                    }
                });
            }
            if (!storePassword.isEmpty()) {
                passwd = storePassword.toCharArray();
            }
            if (storeType.length() != 0) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,defaultctx")) {
                    SSLLogger.finest("init keystore", new Object[0]);
                }
                ks = storeProvider.isEmpty() ? KeyStore.getInstance(storeType) : KeyStore.getInstance(storeType, storeProvider);
                ks.load(fs, passwd);
            }
        }
        finally {
            if (fs != null) {
                fs.close();
                fs = null;
            }
        }
        return ks;
    }

    private static final class KeyStoreDescriptor {
        private final String storeName;
        private final String storeType;
        private final String storeProvider;
        private final String storePassword;

        private KeyStoreDescriptor(String storeName, String storeType, String storeProvider, String storePassword) {
            this.storeName = storeName;
            this.storeType = storeType;
            this.storeProvider = storeProvider;
            this.storePassword = storePassword;
        }

        private static List<KeyStoreDescriptor> createInstances() throws Exception {
            final HashMap props = new HashMap();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    props.put("keyStore", System.getProperty("javax.net.ssl.keyStore", ""));
                    props.put("keyStoreType", System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()));
                    props.put("keyStoreProvider", System.getProperty("javax.net.ssl.keyStoreProvider", ""));
                    props.put("keyStorePasswd", System.getProperty("javax.net.ssl.keyStorePassword", ""));
                    return null;
                }
            });
            String defaultKeyStore = (String)props.get("keyStore");
            String defaultKeyStoreType = (String)props.get("keyStoreType");
            String defaultKeyStoreProvider = (String)props.get("keyStoreProvider");
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,defaultctx")) {
                SSLLogger.fine("keyStore is : " + defaultKeyStore, new Object[0]);
                SSLLogger.fine("keyStore type is : " + defaultKeyStoreType, new Object[0]);
                SSLLogger.fine("keyStore provider is : " + defaultKeyStoreProvider, new Object[0]);
            }
            String defaultKeyStorePasswd = (String)props.get("keyStorePasswd");
            Object[] storeNames = defaultKeyStore.isEmpty() ? new String[]{} : defaultKeyStore.split(",");
            Object[] storeTypes = KeyStoreManager.getKeyStorePropValues("keyStoreType", defaultKeyStoreType, storeNames.length);
            Object[] storeProviders = KeyStoreManager.getKeyStorePropValues("keyStoreProvider", defaultKeyStoreProvider, storeNames.length);
            String[] storePasswords = KeyStoreManager.getKeyStorePropValues("keyStorePasswd", defaultKeyStorePasswd, storeNames.length);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,defaultctx")) {
                SSLLogger.fine("storeNames is : " + Arrays.toString(storeNames), new Object[0]);
                SSLLogger.fine("storeTypes is : " + Arrays.toString(storeTypes), new Object[0]);
                SSLLogger.fine("storeProviders is : " + Arrays.toString(storeProviders), new Object[0]);
            }
            return KeyStoreDescriptor.createInstances((String[])storeNames, (String[])storeTypes, (String[])storeProviders, storePasswords);
        }

        private static List<KeyStoreDescriptor> createInstances(String[] storeNames, String[] storeTypes, String[] storeProviders, String[] storePasswords) {
            ArrayList<KeyStoreDescriptor> descriptors = new ArrayList<KeyStoreDescriptor>();
            int storeCount = storeNames.length;
            if (storeCount == 0) {
                String storeName = "";
                String storeType = storeTypes.length > 0 ? storeTypes[0] : "";
                String storeProvider = storeProviders.length > 0 ? storeProviders[0] : "";
                String storePassword = storePasswords.length > 0 ? storePasswords[0] : "";
                KeyStoreDescriptor descriptor = new KeyStoreDescriptor(storeName, storeType, storeProvider, storePassword);
                descriptors.add(descriptor);
                return descriptors;
            }
            for (int i = 0; i < storeCount; ++i) {
                KeyStoreDescriptor descriptor = new KeyStoreDescriptor(storeNames[i], storeTypes[i], storeProviders[i], storePasswords[i]);
                descriptors.add(descriptor);
            }
            return descriptors;
        }
    }
}

