/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.gm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AlgorithmParameters;
import java.util.Arrays;
import sun.security.util.ConstraintsParameters;
import sun.security.util.Debug;
import sun.security.util.DisabledAlgorithmConstraints;

public class DisabledAlgorithmConstraintsHandler {
    private static final Debug debug = Debug.getInstance("compatible");
    private static boolean useHigherVersion = false;
    private static Method permitsMethod;

    private static void init() {
        permitsMethod = DisabledAlgorithmConstraintsHandler.getMethod("permits", new Class[]{String.class, AlgorithmParameters.class, ConstraintsParameters.class});
        if (permitsMethod != null) {
            return;
        }
        permitsMethod = DisabledAlgorithmConstraintsHandler.getMethod("permits", new Class[]{String.class, AlgorithmParameters.class, ConstraintsParameters.class, Boolean.TYPE});
        if (permitsMethod != null) {
            useHigherVersion = true;
        }
    }

    private static Method getMethod(String name, Class<?>[] parameterTypes) {
        Method method;
        block3: {
            method = null;
            try {
                method = DisabledAlgorithmConstraints.class.getDeclaredMethod(name, parameterTypes);
                method.setAccessible(true);
                if (debug != null) {
                    String params = Arrays.toString(parameterTypes);
                    params = params.substring(1, params.length() - 1);
                    debug.println("Try get method (" + params + ") success");
                }
            }
            catch (NoSuchMethodException e) {
                if (debug == null) break block3;
                debug.println("NoSuchMethodException :" + e.getMessage());
            }
        }
        return method;
    }

    public static void permits(DisabledAlgorithmConstraints constraints, String algorithm, AlgorithmParameters ap, ConstraintsParameters cp, boolean checkKey) {
        if (permitsMethod == null) {
            throw new IllegalStateException("permits(String,AlgorithmParameters,ConstraintsParameters) or permits(String,AlgorithmParameters,ConstraintsParameters,boolean) method not found");
        }
        try {
            if (useHigherVersion) {
                permitsMethod.invoke((Object)constraints, algorithm, ap, cp, checkKey);
            } else {
                permitsMethod.invoke((Object)constraints, algorithm, ap, cp);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        DisabledAlgorithmConstraintsHandler.init();
    }
}

