/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.util;

import java.math.BigInteger;
import java.security.SecureRandom;

public class Util {
    public static int rotateShiftLeft(int x, int k) {
        return x << k | x >>> 32 - k;
    }

    public static void intToBigEndian(int[] ns, byte[] bs, int off) {
        for (int n : ns) {
            Util.intToBigEndian(n, bs, off);
            off += 4;
        }
    }

    public static void intToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 24);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    public static void shortToBigEndian(short n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 8 & 0xFF);
        bs[off + 1] = (byte)(n & 0xFF);
    }

    public static int bigEndianToInt(byte[] bs, int off) {
        int n = bs[off] << 24;
        n |= (bs[++off] & 0xFF) << 16;
        n |= (bs[++off] & 0xFF) << 8;
        return n |= bs[++off] & 0xFF;
    }

    public static BigInteger createRandomBigInteger(int bitLen, SecureRandom random) {
        byte[] randomBytes = Util.createRandom(bitLen, random);
        return new BigInteger(1, randomBytes);
    }

    private static byte[] createRandom(int bitLen, SecureRandom random) throws IllegalArgumentException {
        if (bitLen < 1) {
            throw new IllegalArgumentException("The bit length must be at least 1");
        }
        int byteLen = (bitLen + 7) / 8;
        byte[] randomBytes = new byte[byteLen];
        if (random == null) {
            random = new SecureRandom();
        }
        random.nextBytes(randomBytes);
        int xBits = 8 * byteLen - bitLen;
        randomBytes[0] = (byte)(randomBytes[0] & (byte)(255 >>> xBits));
        return randomBytes;
    }

    public static byte[] asUnsignedByteArray(int length, BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes.length == length) {
            return bytes;
        }
        int start = bytes[0] == 0 && bytes.length != 1 ? 1 : 0;
        int count = bytes.length - start;
        if (count > length) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] tmp = new byte[length];
        System.arraycopy(bytes, start, tmp, tmp.length - count, count);
        return tmp;
    }

    public static byte[] concatenate(byte[] a, byte[] b) {
        if (null == a) {
            return null == b ? null : (byte[])b.clone();
        }
        if (null == b) {
            return null == a ? null : (byte[])a.clone();
        }
        byte[] r = new byte[a.length + b.length];
        System.arraycopy(a, 0, r, 0, a.length);
        System.arraycopy(b, 0, r, a.length, b.length);
        return r;
    }

    public static byte[] concatenate(byte[] a, byte[] b, byte[] c) {
        if (null == a) {
            return Util.concatenate(b, c);
        }
        if (null == b) {
            return Util.concatenate(a, c);
        }
        if (null == c) {
            return Util.concatenate(a, b);
        }
        byte[] r = new byte[a.length + b.length + c.length];
        int pos = 0;
        System.arraycopy(a, 0, r, pos, a.length);
        System.arraycopy(b, 0, r, pos += a.length, b.length);
        System.arraycopy(c, 0, r, pos += b.length, c.length);
        return r;
    }

    public static String toUpperCase(String string) {
        boolean changed = false;
        char[] chars = string.toCharArray();
        for (int i = 0; i != chars.length; ++i) {
            char ch = chars[i];
            if ('a' > ch || 'z' < ch) continue;
            changed = true;
            chars[i] = (char)(ch - 97 + 65);
        }
        if (changed) {
            return new String(chars);
        }
        return string;
    }
}

