/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.com.sun.crypto.provider;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.openeuler.com.sun.crypto.provider.CipherCore;
import org.openeuler.com.sun.crypto.provider.SM4Crypt;

abstract class SM4Cipher
extends CipherSpi {
    private CipherCore core = new CipherCore(new SM4Crypt(), 16);
    private final int fixedKeySize;
    private boolean updateCalled;

    static final void checkKeySize(Key key, int fixedKeySize) throws InvalidKeyException {
        if (fixedKeySize != -1) {
            if (key == null) {
                throw new InvalidKeyException("The key must not be null");
            }
            byte[] value = key.getEncoded();
            if (value == null) {
                throw new InvalidKeyException("Key encoding must not be null");
            }
            if (value.length != fixedKeySize) {
                throw new InvalidKeyException("The key must be " + fixedKeySize + " bytes");
            }
        }
    }

    protected SM4Cipher(int keySize) {
        this.fixedKeySize = keySize;
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        this.core.setMode(mode);
    }

    @Override
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        this.core.setPadding(paddingScheme);
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.core.getOutputSize(inputLen);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.core.getIV();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return this.core.getParameters("SM4");
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        SM4Cipher.checkKeySize(key, this.fixedKeySize);
        this.updateCalled = false;
        this.core.init(opmode, key, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SM4Cipher.checkKeySize(key, this.fixedKeySize);
        this.updateCalled = false;
        this.core.init(opmode, key, params, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SM4Cipher.checkKeySize(key, this.fixedKeySize);
        this.updateCalled = false;
        this.core.init(opmode, key, params, random);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.updateCalled = true;
        return this.core.update(input, inputOffset, inputLen);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        this.updateCalled = true;
        return this.core.update(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected int engineUpdate(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        return this.core.update(input, output);
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] out = this.core.doFinal(input, inputOffset, inputLen);
        this.updateCalled = false;
        return out;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int outLen = this.core.doFinal(input, inputOffset, inputLen, output, outputOffset);
        this.updateCalled = false;
        return outLen;
    }

    @Override
    protected int engineDoFinal(ByteBuffer input, ByteBuffer output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.core.doFinal(input, output);
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] encoded = key.getEncoded();
        if (!SM4Crypt.isKeySizeValid(encoded.length)) {
            throw new InvalidKeyException("Invalid SM4 key length: " + encoded.length + " bytes");
        }
        return Math.multiplyExact(encoded.length, 8);
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.core.wrap(key);
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.core.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    @Override
    protected void engineUpdateAAD(byte[] src, int offset, int len) {
        if (this.core.getMode() == 7 && this.updateCalled) {
            throw new IllegalStateException("AAD must be supplied before encryption/decryption starts");
        }
        this.core.updateAAD(src, offset, len);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer src) {
        int aadLen;
        if (this.core.getMode() == 7 && this.updateCalled) {
            throw new IllegalStateException("AAD must be supplied before encryption/decryption starts");
        }
        if (src != null && (aadLen = src.limit() - src.position()) > 0) {
            if (src.hasArray()) {
                int aadOfs = Math.addExact(src.arrayOffset(), src.position());
                this.core.updateAAD(src.array(), aadOfs, aadLen);
                src.position(src.limit());
            } else {
                byte[] aad = new byte[aadLen];
                src.get(aad);
                this.core.updateAAD(aad, 0, aadLen);
            }
        }
    }

    static abstract class OidImpl
    extends SM4Cipher {
        protected OidImpl(int keySize, String mode, String padding) {
            super(keySize);
            try {
                this.engineSetMode(mode);
                this.engineSetPadding(padding);
            }
            catch (GeneralSecurityException gse) {
                ProviderException pe = new ProviderException("Internal Error");
                pe.initCause(gse);
                throw pe;
            }
        }
    }

    public static final class General
    extends SM4Cipher {
        public General() {
            super(-1);
        }
    }
}

