/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.com.sun.crypto.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.AEADBadTagException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import org.openeuler.com.sun.crypto.provider.FeedbackCipher;
import org.openeuler.com.sun.crypto.provider.OCBHash;
import org.openeuler.com.sun.crypto.provider.SymmetricCipher;

public class OCBCipherBlock
extends FeedbackCipher {
    static final int DEFAULT_TAG_LEN = 16;
    static final int DEFAULT_IV_LEN = 15;
    private int tagLen = 16;
    private byte[] l_sterisk;
    private byte[] l_dollar;
    private byte[] l_0;
    private List<byte[]> l;
    private byte[] offset_0;
    private byte[] offsetBlock;
    private byte[] dataBlock;
    private int dataBlockCount;
    private int dataBlockPos;
    private byte[] checksumBlock;
    private byte[] tagBlock;
    private OCBHash ocbHash;
    private boolean decrypting;
    private byte[] offsetBlockSave;
    private byte[] checksumBlockSave;
    private byte[] dataBlockSave;
    private int dataBlockPosSave;
    private int dataBlockCountSave;

    OCBCipherBlock(SymmetricCipher embeddedCipher) {
        super(embeddedCipher);
    }

    @Override
    String getFeedback() {
        return "OCB";
    }

    @Override
    void save() {
        this.offsetBlockSave = Arrays.copyOf(this.offsetBlock, this.offsetBlock.length);
        this.checksumBlockSave = Arrays.copyOf(this.checksumBlock, this.checksumBlock.length);
        this.dataBlockSave = Arrays.copyOf(this.dataBlock, this.dataBlock.length);
        this.dataBlockPosSave = this.dataBlockPos;
        this.dataBlockCountSave = this.dataBlockCount;
        this.ocbHash.save();
    }

    @Override
    void restore() {
        System.arraycopy(this.offsetBlockSave, 0, this.offsetBlock, 0, this.offsetBlock.length);
        System.arraycopy(this.checksumBlockSave, 0, this.checksumBlock, 0, this.checksumBlock.length);
        System.arraycopy(this.dataBlockSave, 0, this.dataBlock, 0, this.dataBlock.length);
        this.dataBlockPos = this.dataBlockPosSave;
        this.dataBlockCount = this.dataBlockCountSave;
        this.ocbHash.restore();
    }

    void init(boolean decrypting, String algorithm, byte[] key, byte[] iv, int tagLen) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.getEmbeddedCipher().init(decrypting, algorithm, key);
        this.decrypting = decrypting;
        this.tagLen = tagLen;
        this.iv = (byte[])iv.clone();
        this.l_sterisk = new byte[this.blockSize];
        this.getEmbeddedCipher().encryptBlock(this.l_sterisk, 0, this.l_sterisk, 0);
        this.l_dollar = OCBHash.ocb_double(this.l_sterisk);
        this.l_0 = OCBHash.ocb_double(this.l_dollar);
        this.l = new ArrayList<byte[]>();
        this.l.add(this.l_0);
        this.offset_0 = this.getOffsetBlock0(iv, tagLen);
        this.offsetBlock = new byte[this.offset_0.length];
        System.arraycopy(this.offset_0, 0, this.offsetBlock, 0, this.offset_0.length);
        this.checksumBlock = new byte[this.blockSize];
        this.tagBlock = new byte[tagLen];
        this.dataBlock = new byte[decrypting ? this.blockSize + this.tagBlock.length : this.blockSize];
        this.dataBlockCount = 0;
        this.dataBlockPos = 0;
        this.ocbHash = new OCBHash(this.getEmbeddedCipher());
        this.ocbHash.init(this.l_sterisk, this.l);
    }

    private byte[] getNonce(byte[] iv, int tagLen) {
        byte[] nonce = new byte[this.blockSize];
        System.arraycopy(iv, 0, nonce, nonce.length - iv.length, iv.length);
        nonce[0] = (byte)(tagLen << 4);
        int n = nonce.length - iv.length - 1;
        nonce[n] = (byte)(nonce[n] | 1);
        return nonce;
    }

    private byte[] getOffsetBlock0(byte[] iv, int tagLen) {
        byte[] nonce = this.getNonce(iv, tagLen);
        int bottom = nonce[nonce.length - 1] & 0x3F;
        byte[] ktopBlock = new byte[this.blockSize];
        int n = nonce.length - 1;
        nonce[n] = (byte)(nonce[n] & 0xFFFFFFC0);
        this.getEmbeddedCipher().encryptBlock(nonce, 0, ktopBlock, 0);
        byte[] stretchBlock = new byte[this.blockSize + 8];
        System.arraycopy(ktopBlock, 0, stretchBlock, 0, ktopBlock.length);
        for (int i = 0; i < 8; ++i) {
            stretchBlock[ktopBlock.length + i] = (byte)(ktopBlock[i] ^ ktopBlock[i + 1]);
        }
        byte[] offsetBlock = new byte[this.blockSize];
        int bits = bottom % 8;
        int numBytes = bottom / 8;
        if (bits == 0) {
            System.arraycopy(stretchBlock, numBytes, offsetBlock, 0, this.blockSize);
        } else {
            for (int i = 0; i < this.blockSize; ++i) {
                int b1 = stretchBlock[numBytes] & 0xFF;
                int b2 = stretchBlock[++numBytes] & 0xFF;
                offsetBlock[i] = (byte)(b1 << bits | b2 >>> 8 - bits);
            }
        }
        return offsetBlock;
    }

    @Override
    void init(boolean decrypting, String algorithm, byte[] key, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(decrypting, algorithm, key, iv, 16);
    }

    @Override
    void reset() {
        System.arraycopy(this.offset_0, 0, this.offsetBlock, 0, this.offset_0.length);
        Arrays.fill(this.checksumBlock, (byte)0);
        Arrays.fill(this.tagBlock, (byte)0);
        Arrays.fill(this.dataBlock, (byte)0);
        this.dataBlockPos = 0;
        this.dataBlockCount = 0;
        this.ocbHash.reset();
    }

    @Override
    void updateAAD(byte[] src, int offset, int len) {
        this.ocbHash.update(src, offset, len);
    }

    @Override
    int encrypt(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) {
        return this.processPlainTextBlock(plain, plainOffset, plainLen, cipher, cipherOffset);
    }

    @Override
    int decrypt(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) {
        return this.processCipherTextBlock(cipher, cipherOffset, cipherLen, plain, plainOffset);
    }

    @Override
    int encryptFinal(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) throws IllegalBlockSizeException, ShortBufferException {
        int length = this.processPlainTextBlock(plain, plainOffset, plainLen, cipher, cipherOffset);
        length += this.processPlainTextFinal(cipher, cipherOffset + length);
        System.arraycopy(this.tagBlock, 0, cipher, cipherOffset + length, this.tagBlock.length);
        return length += this.tagBlock.length;
    }

    @Override
    int decryptFinal(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) throws IllegalBlockSizeException, AEADBadTagException, ShortBufferException {
        int length = this.processCipherTextBlock(cipher, cipherOffset, cipherLen, plain, plainOffset);
        length += this.processCipherTextFinal(plain, plainOffset + length);
        return length;
    }

    private int processPlainTextBlock(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) {
        int len = 0;
        for (int i = 0; i < plainLen; ++i) {
            this.dataBlock[this.dataBlockPos++] = plain[plainOffset + i];
            if (this.dataBlockPos != this.dataBlock.length) continue;
            len += this.processPlainTextBlock(cipher, cipherOffset + len);
        }
        return len;
    }

    private int processPlainTextBlock(byte[] cipher, int cipherOffset) {
        ++this.dataBlockCount;
        OCBHash.xor(this.checksumBlock, this.dataBlock);
        byte[] lSub = OCBHash.getLSub(this.l, OCBHash.ocb_ntz(this.dataBlockCount));
        OCBHash.xor(this.offsetBlock, lSub);
        OCBHash.xor(this.dataBlock, this.offsetBlock);
        this.getEmbeddedCipher().encryptBlock(this.dataBlock, 0, this.dataBlock, 0);
        OCBHash.xor(this.dataBlock, this.offsetBlock);
        System.arraycopy(this.dataBlock, 0, cipher, cipherOffset, this.dataBlock.length);
        this.dataBlockPos = 0;
        return this.dataBlock.length;
    }

    private int processPlainTextFinal(byte[] cipher, int cipherOffset) {
        if (this.dataBlockPos > 0) {
            OCBHash.ocb_extend(this.dataBlock, this.dataBlockPos);
            OCBHash.xor(this.checksumBlock, this.dataBlock);
            OCBHash.xor(this.offsetBlock, this.l_sterisk);
            byte[] pad = new byte[this.blockSize];
            this.getEmbeddedCipher().encryptBlock(this.offsetBlock, 0, pad, 0);
            OCBHash.xor(this.dataBlock, pad);
            System.arraycopy(this.dataBlock, 0, cipher, cipherOffset, this.dataBlockPos);
        }
        OCBHash.xor(this.checksumBlock, this.offsetBlock);
        OCBHash.xor(this.checksumBlock, this.l_dollar);
        this.getEmbeddedCipher().encryptBlock(this.checksumBlock, 0, this.checksumBlock, 0);
        byte[] hashBlock = this.ocbHash.digest();
        OCBHash.xor(this.checksumBlock, hashBlock);
        System.arraycopy(this.checksumBlock, 0, this.tagBlock, 0, this.tagBlock.length);
        return this.dataBlockPos;
    }

    private int processCipherTextBlock(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) {
        int len = 0;
        for (int i = 0; i < cipherLen; ++i) {
            this.dataBlock[this.dataBlockPos++] = cipher[cipherOffset + i];
            if (this.dataBlockPos != this.dataBlock.length) continue;
            len += this.processCipherTextBlock(plain, plainOffset + len);
        }
        return len;
    }

    private int processCipherTextBlock(byte[] plain, int plainOffset) {
        ++this.dataBlockCount;
        byte[] lSub = OCBHash.getLSub(this.l, OCBHash.ocb_ntz(this.dataBlockCount));
        OCBHash.xor(this.offsetBlock, lSub);
        OCBHash.xor(this.dataBlock, this.offsetBlock);
        this.getEmbeddedCipher().decryptBlock(this.dataBlock, 0, this.dataBlock, 0);
        OCBHash.xor(this.dataBlock, this.offsetBlock);
        System.arraycopy(this.dataBlock, 0, plain, plainOffset, this.blockSize);
        OCBHash.xor(this.checksumBlock, this.dataBlock);
        System.arraycopy(this.dataBlock, this.blockSize, this.dataBlock, 0, this.tagBlock.length);
        this.dataBlockPos = this.tagBlock.length;
        return this.blockSize;
    }

    private int processCipherTextFinal(byte[] plain, int plainOffset) throws ShortBufferException, AEADBadTagException {
        if (this.dataBlockPos < this.tagBlock.length) {
            throw new ShortBufferException("plain buffer is too small");
        }
        this.dataBlockPos -= this.tagBlock.length;
        byte[] inputTagBlock = new byte[this.tagBlock.length];
        System.arraycopy(this.dataBlock, this.dataBlockPos, inputTagBlock, 0, inputTagBlock.length);
        if (this.dataBlockPos > 0) {
            OCBHash.xor(this.offsetBlock, this.l_sterisk);
            byte[] pad = new byte[this.blockSize];
            this.getEmbeddedCipher().encryptBlock(this.offsetBlock, 0, pad, 0);
            OCBHash.xor(this.dataBlock, pad);
            System.arraycopy(this.dataBlock, 0, plain, plainOffset, this.dataBlockPos);
            OCBHash.ocb_extend(this.dataBlock, this.dataBlockPos);
            OCBHash.xor(this.checksumBlock, this.dataBlock);
        }
        OCBHash.xor(this.checksumBlock, this.offsetBlock);
        OCBHash.xor(this.checksumBlock, this.l_dollar);
        this.getEmbeddedCipher().encryptBlock(this.checksumBlock, 0, this.checksumBlock, 0);
        byte[] hashBlock = this.ocbHash.digest();
        OCBHash.xor(this.checksumBlock, hashBlock);
        System.arraycopy(this.checksumBlock, 0, this.tagBlock, 0, this.tagBlock.length);
        if (!Arrays.equals(inputTagBlock, this.tagBlock)) {
            throw new AEADBadTagException("mac check in OCB failed");
        }
        return this.dataBlockPos;
    }

    public int getTagLen() {
        return this.tagLen;
    }

    @Override
    int getBufferedLength() {
        if (this.decrypting) {
            return this.dataBlockPos;
        }
        return 0;
    }
}

