/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.security.MessageDigestSpi;
import java.util.Arrays;
import org.openeuler.util.Util;

public class SM3
extends MessageDigestSpi
implements Cloneable {
    private static final int DIGEST_LENGTH = 32;
    private static final int BLOCK_BYTE_SIZE = 64;
    private long byteCount;
    private byte[] byteBuf = new byte[64];
    private int byteBufOff;
    private int[] V = new int[8];
    private int[] W = new int[68];
    private static final int[] ROUND_CONSTS = new int[]{2043430169, -208106958, -416213915, -832427829, -1664855657, 965255983, 1930511966, -433943364, -867886727, -1735773453, 823420391, 1646840782, -1001285732, -2002571463, 289824371, 579648742, -1651869049, 991229199, 1982458398, -330050500, -660100999, -1320201997, 1654563303, -985840690, -1971681379, 351604539, 703209078, 1406418156, -1482130984, 1330705329, -1633556638, 1027854021, 2055708042, -183551212, -367102423, -734204845, -1468409689, 1358147919, -1578671458, 1137624381, -2019718534, 255530229, 511060458, 1022120916, 2044241832, -206483632, -412967263, -825934525, -1651869049, 991229199, 1982458398, -330050500, -660100999, -1320201997, 1654563303, -985840690, -1971681379, 351604539, 703209078, 1406418156, -1482130984, 1330705329, -1633556638, 1027854021};

    public SM3() {
        this.engineReset();
    }

    @Override
    protected void engineUpdate(byte input) {
        this.byteBuf[this.byteBufOff++] = input;
        if (this.byteBufOff == this.byteBuf.length) {
            this.ME();
            this.CF();
        }
        ++this.byteCount;
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        len = Math.max(0, len);
        int i = 0;
        if (this.byteBufOff != 0) {
            while (i < len) {
                this.byteBuf[this.byteBufOff++] = input[offset + i++];
                if (this.byteBufOff != this.byteBuf.length) continue;
                this.ME();
                this.CF();
                break;
            }
        }
        int limit = (len - i & 0xFFFFFFC0) + i;
        while (i < limit) {
            System.arraycopy(input, offset + i, this.byteBuf, 0, 64);
            this.ME();
            this.CF();
            i += 64;
        }
        while (i < len) {
            this.byteBuf[this.byteBufOff++] = input[offset + i++];
        }
        this.byteCount += (long)len;
    }

    @Override
    protected byte[] engineDigest() {
        long bitLength = this.byteCount << 3;
        this.engineUpdate((byte)-128);
        this.padding(bitLength);
        this.ME();
        this.CF();
        byte[] digestBytes = new byte[this.engineGetDigestLength()];
        Util.intToBigEndian(this.V, digestBytes, 0);
        this.engineReset();
        return digestBytes;
    }

    @Override
    protected void engineReset() {
        for (int i = 0; i < this.byteBuf.length; ++i) {
            this.byteBuf[i] = 0;
        }
        this.V[0] = 1937774191;
        this.V[1] = 1226093241;
        this.V[2] = 388252375;
        this.V[3] = -628488704;
        this.V[4] = -1452330820;
        this.V[5] = 372324522;
        this.V[6] = -477237683;
        this.V[7] = -1325724082;
        this.byteCount = 0L;
        this.byteBufOff = 0;
    }

    @Override
    public int engineGetDigestLength() {
        return 32;
    }

    private int P0(int x) {
        return x ^ Util.rotateShiftLeft(x, 9) ^ Util.rotateShiftLeft(x, 17);
    }

    private int P1(int x) {
        return x ^ Util.rotateShiftLeft(x, 15) ^ Util.rotateShiftLeft(x, 23);
    }

    private int FF(int j, int x, int y, int z) {
        if (j <= 15) {
            return x ^ y ^ z;
        }
        return x & y | x & z | y & z;
    }

    private int GG(int j, int x, int y, int z) {
        if (j <= 15) {
            return x ^ y ^ z;
        }
        return x & y | ~x & z;
    }

    protected void ME() {
        int j;
        for (j = 0; j < 16; ++j) {
            int index = j << 2;
            this.W[j] = (this.byteBuf[index] & 0xFF) << 24 | (this.byteBuf[++index] & 0xFF) << 16 | (this.byteBuf[++index] & 0xFF) << 8 | this.byteBuf[++index] & 0xFF;
        }
        for (j = 16; j < 68; ++j) {
            this.W[j] = this.P1(this.W[j - 16] ^ this.W[j - 9] ^ Util.rotateShiftLeft(this.W[j - 3], 15)) ^ Util.rotateShiftLeft(this.W[j - 13], 7) ^ this.W[j - 6];
        }
    }

    protected void CF() {
        int A = this.V[0];
        int B = this.V[1];
        int C = this.V[2];
        int D = this.V[3];
        int E = this.V[4];
        int F = this.V[5];
        int G = this.V[6];
        int H = this.V[7];
        for (int j = 0; j < 64; ++j) {
            int A_r12 = Util.rotateShiftLeft(A, 12);
            int SS1 = Util.rotateShiftLeft(A_r12 + E + ROUND_CONSTS[j], 7);
            int SS2 = SS1 ^ A_r12;
            int TT1 = this.FF(j, A, B, C) + D + SS2 + (this.W[j] ^ this.W[j + 4]);
            int TT2 = this.GG(j, E, F, G) + H + SS1 + this.W[j];
            D = C;
            C = Util.rotateShiftLeft(B, 9);
            B = A;
            A = TT1;
            H = G;
            G = Util.rotateShiftLeft(F, 19);
            F = E;
            E = this.P0(TT2);
        }
        this.V[0] = this.V[0] ^ A;
        this.V[1] = this.V[1] ^ B;
        this.V[2] = this.V[2] ^ C;
        this.V[3] = this.V[3] ^ D;
        this.V[4] = this.V[4] ^ E;
        this.V[5] = this.V[5] ^ F;
        this.V[6] = this.V[6] ^ G;
        this.V[7] = this.V[7] ^ H;
        this.byteBufOff = 0;
    }

    protected void padding(long bitLength) {
        if (this.byteBufOff > 56) {
            Arrays.fill(this.byteBuf, this.byteBufOff, 64, (byte)0);
            this.byteBufOff = 64;
            this.ME();
            this.CF();
        }
        if (this.byteBufOff < 56) {
            Arrays.fill(this.byteBuf, this.byteBufOff, 56, (byte)0);
            this.byteBufOff = 56;
        }
        for (int i = 56; i >= 0; i -= 8) {
            this.byteBuf[this.byteBufOff++] = (byte)(bitLength >>> i);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SM3 copy = (SM3)super.clone();
        copy.byteBuf = (byte[])copy.byteBuf.clone();
        copy.V = (int[])copy.V.clone();
        copy.W = new int[68];
        return copy;
    }
}

