/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import org.openeuler.constant.GMConstants;
import org.openeuler.util.GMUtil;

public class SM2KeyExchangeUtil {
    private static boolean DEBUG = false;

    public static byte[] generateSharedSecret(byte[] localId, ECPrivateKey localPrivateKey, ECPublicKey localPublicKey, ECPrivateKey localTempPrivateKey, ECPublicKey localTempPublicKey, byte[] peerId, ECPublicKey peerPublicKey, ECPublicKey peerTempPublicKey, int secretLen, boolean useClientMode) throws IOException, NoSuchAlgorithmException {
        BigInteger rA = localTempPrivateKey.getS();
        ECPoint RA = localTempPublicKey.getW();
        BigInteger n = localPublicKey.getParams().getOrder();
        int w = (int)Math.ceil((double)n.subtract(BigInteger.ONE).bitLength() / 2.0) - 1;
        BigInteger wk = BigInteger.ONE.shiftLeft(w);
        BigInteger x1 = RA.getAffineX();
        x1 = wk.add(x1.and(wk.subtract(BigInteger.ONE)));
        BigInteger dA = localPrivateKey.getS();
        BigInteger tA = dA.add(x1.multiply(rA)).mod(n);
        ECPoint RB = peerTempPublicKey.getW();
        BigInteger x2 = RB.getAffineX();
        x2 = wk.add(x2.and(wk.subtract(BigInteger.ONE)));
        BigInteger h = BigInteger.valueOf(localPublicKey.getParams().getCofactor());
        ECPoint PB = peerPublicKey.getW();
        EllipticCurve peerCurve = peerPublicKey.getParams().getCurve();
        ECPoint V = GMUtil.multiply(GMUtil.add(PB, GMUtil.multiply(RB, x2, peerCurve)), h.multiply(tA), peerCurve);
        BigInteger xV = V.getAffineX();
        BigInteger yV = V.getAffineY();
        MessageDigest messageDigest = MessageDigest.getInstance("SM3");
        byte[] ZA = SM2KeyExchangeUtil.generateZ(localId, localPublicKey, messageDigest);
        byte[] ZB = SM2KeyExchangeUtil.generateZ(peerId, peerPublicKey, messageDigest);
        byte[] bytes = SM2KeyExchangeUtil.concat(xV, yV, ZA, ZB, useClientMode);
        byte[] sharedSecret = SM2KeyExchangeUtil.KDF(bytes, secretLen, messageDigest);
        if (DEBUG) {
            System.out.println("xV = " + xV.toString(16));
            System.out.println("yV = " + yV.toString(16));
            System.out.println("ZA =" + new BigInteger(ZA).toString(16));
            System.out.println("ZB =" + new BigInteger(ZB).toString(16));
            System.out.println("(xv || yv || ZA || ZB) = " + Arrays.toString(bytes));
            System.out.println("sharedSecret = " + Arrays.toString(sharedSecret));
        }
        return sharedSecret;
    }

    public static ECPoint generateR(ECPublicKey publicKey, BigInteger random) {
        ECPoint g = publicKey.getParams().getGenerator();
        return GMUtil.multiply(g, random, publicKey.getParams().getCurve());
    }

    public static BigInteger generateRandom(ECPublicKey publicKey, SecureRandom secureRandom) {
        BigInteger n = publicKey.getParams().getOrder();
        return SM2KeyExchangeUtil.generateRandom(n, secureRandom);
    }

    public static BigInteger generateRandom(BigInteger n, SecureRandom secureRandom) {
        BigInteger random;
        int len = n.bitLength() / 8;
        int iterationCount = 64;
        int iterationIndex = 0;
        while (true) {
            if ((random = new BigInteger(n.bitLength(), secureRandom)).compareTo(n) >= 0 || BigInteger.ONE.equals(random)) {
                continue;
            }
            if (random.bitLength() / 8 == len) {
                ++iterationIndex;
                continue;
            }
            if (iterationIndex >= iterationCount) break;
        }
        return random;
    }

    public static byte[] generateZ(byte[] idBytes, ECPublicKey publicKey, MessageDigest messageDigest) {
        if (idBytes == null) {
            idBytes = GMConstants.DEFAULT_ID;
        }
        int idBitsLen = idBytes.length * 8;
        EllipticCurve curve = publicKey.getParams().getCurve();
        BigInteger a = curve.getA();
        BigInteger b = curve.getB();
        ECPoint g = publicKey.getParams().getGenerator();
        BigInteger gX = g.getAffineX();
        BigInteger gY = g.getAffineY();
        ECPoint q = publicKey.getW();
        BigInteger qX = q.getAffineX();
        BigInteger qY = q.getAffineY();
        int m = 0;
        if (curve.getField() instanceof ECFieldF2m) {
            m = ((ECFieldF2m)curve.getField()).getM();
        }
        BigInteger[] elements = new BigInteger[]{a, b, gX, gY, qX, qY};
        byte[] idLenBytes = new byte[]{(byte)(idBitsLen >> 8), (byte)idBitsLen};
        messageDigest.update(idLenBytes);
        messageDigest.update(idBytes);
        for (BigInteger element : elements) {
            messageDigest.update(SM2KeyExchangeUtil.convertToBytes(element, m));
        }
        return messageDigest.digest();
    }

    public static byte[] KDF(byte[] bytes, int keyLength, MessageDigest messageDigest) {
        byte[] digestBytes;
        int digestLength = messageDigest.getDigestLength();
        int hashBitsLen = digestLength * 8;
        byte[] keyBytes = new byte[keyLength];
        int keyBitsLen = keyLength * 8;
        int count = keyBitsLen / hashBitsLen + 1;
        byte[] iBytes = new byte[4];
        for (int i = 1; i < count; ++i) {
            messageDigest.update(bytes);
            SM2KeyExchangeUtil.intToBytes(iBytes, i);
            messageDigest.update(iBytes);
            digestBytes = messageDigest.digest();
            System.arraycopy(digestBytes, 0, keyBytes, (i - 1) * digestLength, digestLength);
        }
        int remainBits = keyBitsLen % hashBitsLen;
        if (remainBits != 0) {
            messageDigest.update(bytes);
            SM2KeyExchangeUtil.intToBytes(iBytes, count);
            messageDigest.update(iBytes);
            digestBytes = messageDigest.digest();
            System.arraycopy(digestBytes, 0, keyBytes, (count - 1) * digestLength, remainBits / 8);
        }
        return keyBytes;
    }

    private static void intToBytes(byte[] iBytes, int num) {
        iBytes[3] = (byte)num;
        iBytes[2] = (byte)(num >> 8 & 0xFF);
        iBytes[1] = (byte)(num >> 16 & 0xFF);
        iBytes[0] = (byte)(num >> 24 & 0xFF);
    }

    private static byte[] concat(BigInteger xV, BigInteger yV, byte[] ZA, byte[] ZB, boolean useClientMode) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(SM2KeyExchangeUtil.convertToBytes(xV));
        outputStream.write(SM2KeyExchangeUtil.convertToBytes(yV));
        if (useClientMode) {
            outputStream.write(ZB);
            outputStream.write(ZA);
        } else {
            outputStream.write(ZA);
            outputStream.write(ZB);
        }
        return outputStream.toByteArray();
    }

    private static byte[] convertToBytes(BigInteger val) {
        byte[] bytes = val.toByteArray();
        byte[] newBytes = new byte[32];
        if (bytes.length < 32) {
            System.arraycopy(bytes, 0, newBytes, 32 - bytes.length, bytes.length);
        } else {
            System.arraycopy(bytes, bytes.length - 32, newBytes, 0, newBytes.length);
        }
        return newBytes;
    }

    private static byte[] convertToBytes(BigInteger val, int m) {
        if (m == 0) {
            return SM2KeyExchangeUtil.convertToBytes(val);
        }
        int size = m % 8 == 0 ? m / 8 : m / 8 + 1;
        byte[] bytes = SM2KeyExchangeUtil.convertToBytes(val);
        if (bytes.length == size) {
            return bytes;
        }
        byte[] newBytes = new byte[size];
        if (bytes.length >= size) {
            System.arraycopy(bytes, 0, newBytes, size - bytes.length, bytes.length);
        }
        return newBytes;
    }

    public static ECPublicKey generatePublicKey(ECPrivateKey privateKey) throws InvalidKeyException {
        ECParameterSpec parameters = privateKey.getParams();
        BigInteger d = privateKey.getS();
        ECPoint G = parameters.getGenerator();
        ECPoint P = GMUtil.multiply(G, d, parameters.getCurve());
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(P, parameters);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(privateKey.getAlgorithm());
            return (ECPublicKey)keyFactory.generatePublic(ecPublicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }
}

